/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.datarepository.DRSchema;
import com.manageengine.dataengine.commons.datarepository.DRType;
import com.manageengine.dataengine.commons.datarepository.XNodeDRConfFile;
import com.manageengine.dataengine.commons.datarepository.XNodeDRSchema;
import com.manageengine.dataengine.commons.lucene.LuceneAnalyzer;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.bootstrap.XNodeManager;
import com.manageengine.dataengine.xnode.datarepository.ArchiveLocationsConfFile;
import com.manageengine.dataengine.xnode.datarepository.AuditLogDR;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryActionRequest;
import com.manageengine.dataengine.xnode.datarepository.GenericDR;
import com.manageengine.dataengine.xnode.scheduler.SchedulerType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataRepositoryManager {
    public static final String DE_MAIN_DATA_DIR = ((Path)Environment.XNODE_DATA_MAIN_DIR.value()).toAbsolutePath().normalize().toString() + File.separator;
    public static final String DE_ARCHIVE_DATA_DIR = ((Path)Environment.XNODE_DATA_ARCHIVE_DIR.value()).toAbsolutePath().normalize().toString() + File.separator;
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");
    private static ConcurrentHashMap<String, DRSchema> schemaMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, DataRepository> dataRepositoryMap = new ConcurrentHashMap();
    private static ArchiveLocationsConfFile archiveLocationsHandler;
    private static String currentArchiveLocation;
    private static volatile Object data_repo_lock;
    private static boolean isArchiveRunning;

    public static boolean isArchiveRunning() {
        return isArchiveRunning;
    }

    protected static boolean initDataRepositoryManager() throws Exception {
        boolean status = true;
        DataRepositoryManager.loadDRSchemas();
        DataRepositoryManager.loadDataRepositories();
        DataRepositoryManager.loadArchiveLocations();
        return status;
    }

    public static DRIndexField getDataRepositoryIndexField(String repoName, String fieldName) {
        return DataRepositoryManager.getDataRepository(repoName).getIndexField(fieldName);
    }

    public static ConcurrentHashMap<String, DataRepository> getDataRepositoryMap() {
        return dataRepositoryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDRSchemas() throws Exception {
        File schemasFolder = ((Path)Environment.XNODE_DR_SCHEMA_DIR.value()).toFile();
        if (!schemasFolder.exists()) {
            schemasFolder.mkdirs();
        }
        schemaMap = new ConcurrentHashMap();
        if (schemasFolder.isDirectory()) {
            File[] schemaFileList = schemasFolder.listFiles();
            BufferedReader br = null;
            for (File schemaFile : schemaFileList) {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(schemaFile)));
                    StringBuilder fileStr = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        fileStr.append(line);
                    }
                    JSONObject fileContentObj = new JSONObject(fileStr.toString());
                    XNodeDRSchema schema = new XNodeDRSchema(schemaFile.getName().replace(".json", ""), fileContentObj);
                    schemaMap.put(schema.getSchemaName(), (DRSchema)schema);
                    LOGGER.info("LOADED : DataRepository Schema '" + schemaFile.getName() + "'");
                }
                catch (Exception e) {
                    LOGGER.error("EXCEPTION : Error while parsing Schema file '" + schemaFile.getName() + "'");
                    e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
        } else {
            throw new Exception("Schema '" + Environment.XNODE_DR_SCHEMA_DIR.value() + "' file path does not exist!");
        }
        DataRepositoryManager.checkFieldWithMultipleDataTypes();
    }

    public static JSONObject syncDRSchemas(DataRepositoryActionRequest request) throws Exception {
        String key;
        JSONObject jResponse = new JSONObject();
        JSONObject jSchemas = request.drSchemaListObj();
        File schemasFolder = ((Path)Environment.XNODE_DR_SCHEMA_DIR.value()).toFile();
        schemaMap = new ConcurrentHashMap();
        Iterator iterator = jSchemas.keys();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            File file = new File(schemasFolder, key);
            if (key.endsWith(".json") && file.getCanonicalPath().startsWith(schemasFolder.getCanonicalPath())) continue;
            throw new Exception("Error while processing dr-schema-sync-request, illegal content! : " + key);
        }
        if (!schemasFolder.exists()) {
            schemasFolder.mkdirs();
        }
        if (schemasFolder.isDirectory()) {
            File[] schemaFileList;
            for (File schemaFile2 : schemaFileList = schemasFolder.listFiles()) {
                boolean isPresent = false;
                for (String reqSchema : jSchemas.keySet()) {
                    if (!reqSchema.equalsIgnoreCase(schemaFile2.getName())) continue;
                    isPresent = true;
                }
                if (isPresent) continue;
                schemaFile2.delete();
                LOGGER.info("SYNC : Going to delete schemaFile = " + schemaFile2.getName());
            }
        }
        iterator = jSchemas.keys();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            File file = new File(schemasFolder, key);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            bw.write(jSchemas.getJSONObject(key).toString(2));
            bw.close();
            XNodeDRSchema schema = new XNodeDRSchema(key.replace(".json", ""), jSchemas.getJSONObject(key));
            schemaMap.put(schema.getSchemaName(), (DRSchema)schema);
            LOGGER.info("SYNCHED : DataRepository Schema '" + key + "'");
        }
        DataRepositoryManager.checkFieldWithMultipleDataTypes();
        jResponse.put("error_code", 0);
        return jResponse;
    }

    private static void checkFieldWithMultipleDataTypes() throws Exception {
        HashMap<String, String> valMap = new HashMap<String, String>();
        for (DRSchema schema : schemaMap.values()) {
            ArrayList fieldList = schema.getIndexFields();
            for (DRIndexField field : fieldList) {
                if (valMap.containsKey(field.getFieldName().toLowerCase()) && !((String)valMap.get(field.getFieldName().toLowerCase())).equals(field.getDataType())) {
                    LOGGER.error("EXCEPTION : Field with multiple datatypes detected! " + schema.getSchemaName() + "." + field.getFieldName());
                    throw new Exception("Field with multiple datatypes detected! " + schema.getSchemaName() + "." + field.getFieldName());
                }
                valMap.put(field.getFieldName().toLowerCase(), field.getDataType());
            }
        }
    }

    public static DRSchema getDRSchema(String schemaName) {
        DRSchema schema = schemaMap.get(schemaName);
        if (schema == null) {
            throw new NoSuchElementException("Schema '" + schemaName + "' not found!");
        }
        return schema;
    }

    public static DRFieldDataType getFieldType(String fieldName, List<DataRepository> list) {
        DRFieldDataType drFieldType = null;
        for (DataRepository dataRepository : list) {
            DRIndexField drField = dataRepository.getIndexField(fieldName);
            if (drField == null) continue;
            String fieldType = drField.getDataType();
            DRFieldDataType curDRrFieldType = DRFieldDataType.get((String)fieldType);
            if (drFieldType != null && drFieldType != curDRrFieldType) {
                throw new IllegalStateException("Found different datatypes[" + drFieldType + ", " + curDRrFieldType + "] for field - " + fieldName + "!");
            }
            drFieldType = curDRrFieldType;
        }
        return drFieldType;
    }

    public static void loadDataRepositories() throws Exception {
        File datarepositoryFile = ((Path)Environment.XNODE_DR_CONF_FILE.value()).toFile();
        LOGGER.info("Loading DataRepository info from : " + datarepositoryFile.getAbsolutePath());
        XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)datarepositoryFile);
        DataRepositoryManager.updateInternalDataRepositories(drFileObj.getDataRepositories());
    }

    public static JSONObject syncDataRepositories(DataRepositoryActionRequest request) throws Exception {
        File datarepositoryFile = ((Path)Environment.XNODE_DR_CONF_FILE.value()).toFile();
        LOGGER.info("Synching DataRepository info to : " + datarepositoryFile.getAbsolutePath());
        JSONObject jResponse = new JSONObject();
        XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)datarepositoryFile, (JSONArray)request.dataRepositoryList());
        DataRepositoryManager.updateInternalDataRepositories(drFileObj.getDataRepositories());
        jResponse.put("error_code", 0);
        return jResponse;
    }

    public static JSONObject updateDataRepositories(DataRepositoryActionRequest request) throws Exception {
        File datarepositoryFile = ((Path)Environment.XNODE_DR_CONF_FILE.value()).toFile();
        LOGGER.info("Updating DataRepository info to : " + datarepositoryFile.getAbsolutePath());
        JSONObject jResponse = new JSONObject();
        XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)datarepositoryFile);
        drFileObj.update(request.dataRepositoryList());
        DataRepositoryManager.updateInternalDataRepositories(drFileObj.getDataRepositories());
        jResponse.put("error_code", 0);
        return jResponse;
    }

    public static JSONObject fetchDRMainBlocksDiskSize(DataRepositoryActionRequest request) throws Exception {
        JSONArray repoNames = request.dataRepositoryList();
        JSONObject sizeList = new JSONObject();
        long totalSize = 0L;
        if (repoNames.length() == 1 && repoNames.getString(0).equalsIgnoreCase("all")) {
            totalSize = FileUtils.sizeOf((File)((Path)Environment.XNODE_DATA_MAIN_DIR.value()).toFile());
        } else {
            for (int i = 0; i < repoNames.length(); ++i) {
                DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoNames.getString(i));
                long size = dataRepository.getMainBlocksDiskSize();
                sizeList.put(repoNames.getString(i), size);
                totalSize += size;
            }
        }
        sizeList.put("total_size", totalSize);
        return new JSONObject().put("dr_disk_size", (Object)sizeList);
    }

    public static JSONObject fetchDRMainBlocksDiskSizeOlderThan(DataRepositoryActionRequest request) throws Exception {
        JSONArray repoObjList = request.dataRepositoryList();
        JSONObject sizeList = new JSONObject();
        long totalSize = 0L;
        for (int i = 0; i < repoObjList.length(); ++i) {
            JSONObject repoObj = repoObjList.getJSONObject(i);
            String repoName = repoObj.getString("dr_name");
            int retentionDays = repoObj.optInt("retention_days", -1);
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoName);
            retentionDays = retentionDays == -1 ? dataRepository.mainBlockRetentionDays() : retentionDays;
            long size = dataRepository.getMainBlocksDiskSizeOlderThan(retentionDays);
            sizeList.put(repoName, size);
            totalSize += size;
        }
        sizeList.put("total_size", totalSize);
        return new JSONObject().put("dr_disk_size", (Object)sizeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateInternalDataRepositories(List<XNodeDRConfFile.DataRepositoryBean> drList) throws Exception {
        Object object = data_repo_lock;
        synchronized (object) {
            ConcurrentHashMap<String, DataRepository> newDataRepositoryMap = new ConcurrentHashMap<String, DataRepository>();
            for (XNodeDRConfFile.DataRepositoryBean dataRepositoryBean : drList) {
                try {
                    DataRepository dataRepository = dataRepositoryMap.get(dataRepositoryBean.repositoryName().toLowerCase());
                    if (dataRepository == null) {
                        LOGGER.info("ADD DataRepository :: Going to add DataRepository '" + dataRepositoryBean.repositoryName() + "'");
                        if (DRType.get((String)dataRepositoryBean.repositoryType()) == DRType.AUDIT_LOG) {
                            newDataRepositoryMap.put(dataRepositoryBean.repositoryName().toLowerCase(), new AuditLogDR(dataRepositoryBean));
                        } else {
                            newDataRepositoryMap.put(dataRepositoryBean.repositoryName().toLowerCase(), new GenericDR(dataRepositoryBean));
                        }
                        dataRepositoryBean.logMinDataRepositoryInfo();
                        LOGGER.info("ADD DataRepository :: DataRepository '" + dataRepositoryBean.repositoryName() + "' has been added!");
                        continue;
                    }
                    LOGGER.info("UPDATE DataRepository :: Going to update DataRepository '" + dataRepository.repositoryName() + "'");
                    newDataRepositoryMap.put(dataRepositoryBean.repositoryName().toLowerCase(), dataRepository.update(dataRepositoryBean));
                    dataRepositoryBean.logMinDataRepositoryInfo();
                    LOGGER.info("UPDATE DataRepository :: DataRepository '" + dataRepositoryBean.repositoryName() + "' has been updated!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.info("DATA Reposiotory Bean is - " + dataRepositoryBean.toString());
                    throw new RuntimeException(e);
                }
            }
            for (DataRepository drRepo : dataRepositoryMap.values()) {
                if (newDataRepositoryMap.containsKey(drRepo.repositoryName().toLowerCase())) continue;
                LOGGER.info("DELETE DataRepository :: Going to delete DataRepository '" + drRepo.repositoryName() + "'");
                DataRepositoryManager.deleteDataRepository(drRepo);
                LOGGER.info("DELETE DataRepository :: DataRepository '" + drRepo.repositoryName() + "' has been deleted!");
            }
            dataRepositoryMap = newDataRepositoryMap;
        }
    }

    private static void deleteDataRepository(DataRepository dataRepo) throws Exception {
        dataRepo.drop();
    }

    public static DataRepository getDataRepository(String repositoryName) {
        DataRepository repository = dataRepositoryMap.get(repositoryName.toLowerCase());
        if (repository == null) {
            throw new NoSuchElementException("DataRepository for '" + repositoryName + "' not found!");
        }
        return repository;
    }

    public static ConcurrentHashMap<String, DataRepository> getDataRepositories() {
        return dataRepositoryMap;
    }

    public static Analyzer getAnalyzerWrapper(List<DataRepository> dataRepositories) throws IOException {
        HashMap<String, Analyzer> fieldVsAnalyzer = new HashMap<String, Analyzer>();
        for (DataRepository dataRepository : dataRepositories) {
            fieldVsAnalyzer.putAll(dataRepository.getFieldVsAnalyzer());
        }
        return new PerFieldAnalyzerWrapper(LuceneAnalyzer.KEYWORD_LOWERCASE.analyzer(), fieldVsAnalyzer);
    }

    public static void archiveOldBlocks() throws Exception {
        isArchiveRunning = true;
        try {
            for (DataRepository dataRepository : dataRepositoryMap.values()) {
                if (XNodeManager.isShutdownInitialized() || !(dataRepository instanceof AuditLogDR) || dataRepository.mainBlockRetentionDays() == -1) continue;
                ((AuditLogDR)dataRepository).archiveOldBlocks();
            }
        }
        finally {
            isArchiveRunning = false;
        }
    }

    public static void unloadOldArchiveBlocks() throws Exception {
        for (DataRepository dataRepository : dataRepositoryMap.values()) {
            if (!(dataRepository instanceof AuditLogDR)) continue;
            ((AuditLogDR)dataRepository).unloadOldArchiveBlocks();
        }
    }

    public static boolean stopDataRepositories() {
        for (DataRepository dataRepository : dataRepositoryMap.values()) {
            dataRepository.doStop();
        }
        return true;
    }

    public static boolean closeDataRepositories() {
        boolean isClosed = true;
        for (DataRepository dataRepository : dataRepositoryMap.values()) {
            isClosed |= dataRepository.doClose();
        }
        return isClosed;
    }

    public static void loadArchiveLocations() throws Exception {
        LOGGER.info("Loading Archive Locations info from : " + ((Path)Environment.XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE.value()).toFile().getAbsolutePath());
        archiveLocationsHandler = ArchiveLocationsConfFile.load();
        currentArchiveLocation = archiveLocationsHandler.getCurrentArchiveLocation();
        if (currentArchiveLocation == null) {
            LOGGER.warn("WARNING : Current Archive Location is null! Loading default location");
            archiveLocationsHandler = ArchiveLocationsConfFile.loadDefaultLocation();
            currentArchiveLocation = archiveLocationsHandler.getCurrentArchiveLocation();
        }
        DataRepositoryManager.updateArchiveLocations();
        LOGGER.info("Current Archive Location : " + currentArchiveLocation);
    }

    public static JSONObject syncArchiveLocations(DataRepositoryActionRequest request) throws Exception {
        LOGGER.info("Synching Archive Locations info to : " + ((Path)Environment.XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE.value()).toFile().getAbsolutePath());
        JSONObject jResponse = new JSONObject();
        boolean saved = false;
        boolean clean = request.clean();
        if (clean) {
            JSONArray jLocations = request.archiveLocationList();
            int arrLen = jLocations.length();
            for (int i = 0; i < arrLen; ++i) {
                JSONObject obj = jLocations.getJSONObject(i);
                String state = obj.getString("state");
                if (!state.equalsIgnoreCase("current")) continue;
                obj.put("path", (Object)(obj.getString("path") + File.separator + "dataengine"));
            }
            archiveLocationsHandler = ArchiveLocationsConfFile.load(jLocations);
            saved = true;
        } else {
            boolean isCurrentPathUpdate = request.isCurrentPathUpdate();
            if (isCurrentPathUpdate) {
                JSONObject obj = request.archiveLocationList().getJSONObject(0);
                boolean success = DataRepositoryManager.checkArchiveFolderPermission(obj.optString("path"));
                if (success) {
                    obj.put("path", (Object)(obj.getString("path") + File.separator + "dataengine"));
                    try {
                        ArchiveLocationsConfFile.ArchiveLocation bean = ArchiveLocationsConfFile.ArchiveLocation.load(obj);
                        archiveLocationsHandler.changeCurrentArchiveLocationTo(bean);
                        saved = true;
                    }
                    catch (Exception ex) {
                        LOGGER.info("Unable to update archive location!");
                        ex.printStackTrace();
                        saved = false;
                    }
                }
            } else {
                JSONArray jLocations = request.archiveLocationList();
                int arrLen = jLocations.length();
                for (int i = 0; i < arrLen; ++i) {
                    JSONObject obj = jLocations.getJSONObject(i);
                    String state = obj.getString("state");
                    if (!state.equalsIgnoreCase("current")) continue;
                    obj.put("path", (Object)(obj.getString("path") + File.separator + "dataengine"));
                }
                archiveLocationsHandler = ArchiveLocationsConfFile.cleanAndAddAll(jLocations);
                saved = true;
            }
        }
        if (saved) {
            currentArchiveLocation = archiveLocationsHandler.getCurrentArchiveLocation();
            if (currentArchiveLocation == null) {
                LOGGER.warn("WARNING : Current Archive Location is null! Loading default location");
                archiveLocationsHandler = ArchiveLocationsConfFile.loadDefaultLocation();
                currentArchiveLocation = archiveLocationsHandler.getCurrentArchiveLocation();
            }
            DataRepositoryManager.updateArchiveLocations();
            LOGGER.info("Current Archive Location : " + currentArchiveLocation);
        }
        jResponse.put("error_code", saved ? 0 : 1);
        return jResponse;
    }

    private static void updateArchiveLocations() {
        if (DataRepositoryManager.getCurrentArchiveLocation() != null) {
            for (DataRepository dataRepository : dataRepositoryMap.values()) {
                dataRepository.setCurrentArchiveBlocksLocation(DataRepositoryManager.getCurrentArchiveLocation());
            }
        } else {
            throw new NullPointerException("Trying to assign null value for DataRepository-CurrentArchiveLocation!");
        }
    }

    public static void updateCurrentArchiveLocationBlockCount(int blockCount) throws Exception {
        archiveLocationsHandler = ArchiveLocationsConfFile.load();
        archiveLocationsHandler.updateCurrentArchiveLocationBlockCount(blockCount);
    }

    public static ArrayList<String> getArchiveLocations() {
        return archiveLocationsHandler.getArchiveLocations();
    }

    public static String getCurrentArchiveLocation() {
        return currentArchiveLocation;
    }

    public static JSONObject fetchBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONArray repoNames = request.dataRepositoryList();
        JSONArray mergeList = new JSONArray();
        for (int i = 0; i < repoNames.length(); ++i) {
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoNames.getString(i));
            JSONArray jComputedResp = dataRepository.fetchBlocksMeta(request).getJSONArray("dr_blocks_meta");
            for (int ai = 0; ai < jComputedResp.length(); ++ai) {
                mergeList.put((Object)jComputedResp.getJSONObject(ai));
            }
        }
        return new JSONObject().put("dr_blocks_meta", (Object)mergeList);
    }

    public static JSONObject fetchBlocksCount(DataRepositoryActionRequest request) throws Exception {
        JSONArray repoNames = request.dataRepositoryList();
        int totalCount = 0;
        for (int i = 0; i < repoNames.length(); ++i) {
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoNames.getString(i));
            JSONObject jComputedResp = dataRepository.fetchBlocksCount(request);
            totalCount += jComputedResp.getInt("dr_blocks_count");
        }
        return new JSONObject().put("dr_blocks_count", totalCount);
    }

    public static JSONObject syncFrozenBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONObject syncObjList = request.dataRepositoryListObj();
        JSONObject jComputedResp = null;
        Iterator iterator = syncObjList.keys();
        while (iterator.hasNext()) {
            String repoName = (String)iterator.next();
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoName);
            jComputedResp = dataRepository.syncBlocksMeta(request);
        }
        return jComputedResp;
    }

    public static JSONObject fetchToDeleteBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONArray reposName = request.dataRepositoryList();
        JSONArray mergeList = new JSONArray();
        if (reposName.length() == 1 && reposName.getString(0).equalsIgnoreCase("all")) {
            for (Map.Entry<String, DataRepository> entry : dataRepositoryMap.entrySet()) {
                DataRepository dataRepository = entry.getValue();
                if (dataRepository.repositoryType() != DRType.AUDIT_LOG) continue;
                JSONArray jComputedResp = dataRepository.fetchToDeleteBlocksMeta(request).getJSONArray("dr_to_delete_blocks_meta");
                for (int ai = 0; ai < jComputedResp.length(); ++ai) {
                    mergeList.put((Object)jComputedResp.getJSONObject(ai));
                }
            }
        } else {
            for (int i = 0; i < reposName.length(); ++i) {
                DataRepository dataRepository = DataRepositoryManager.getDataRepository(reposName.getString(i));
                if (dataRepository.repositoryType() != DRType.AUDIT_LOG) continue;
                JSONArray jComputedResp = dataRepository.fetchToDeleteBlocksMeta(request).getJSONArray("dr_to_delete_blocks_meta");
                for (int ai = 0; ai < jComputedResp.length(); ++ai) {
                    mergeList.put((Object)jComputedResp.getJSONObject(ai));
                }
            }
        }
        return new JSONObject().put("dr_to_delete_blocks_meta", (Object)mergeList);
    }

    public static JSONArray fetchDeletedBlocksMeta(JSONArray notifications) {
        for (Map.Entry<String, DataRepository> entry : dataRepositoryMap.entrySet()) {
            JSONArray deletedBlocks;
            DataRepository dataRepository = entry.getValue();
            if (!(dataRepository instanceof AuditLogDR) || (deletedBlocks = ((AuditLogDR)dataRepository).getDeletedBlocksList()) == null || deletedBlocks.length() <= 0) continue;
            for (int i = 0; i < deletedBlocks.length(); ++i) {
                notifications.put((Object)deletedBlocks.getJSONObject(i));
            }
            ((AuditLogDR)dataRepository).resetDeletedBlocksList();
        }
        return notifications;
    }

    public static JSONObject fetchArchivePageInfo(DataRepositoryActionRequest request) throws Exception {
        JSONArray reposName = request.dataRepositoryList();
        JSONObject infoObj = new JSONObject();
        for (int i = 0; i < reposName.length(); ++i) {
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(reposName.getString(i));
            JSONObject jcomputedResponse = new JSONObject();
            jcomputedResponse.put("dr_live_disk_size", dataRepository.fetchLiveBlocksSize());
            jcomputedResponse.put("dr_cold_disk_size", dataRepository.fetchColdBlocksDiskSize());
            jcomputedResponse.put("dr_frozen_disk_size", dataRepository.fetchFrozenBlocksDiskSize());
            jcomputedResponse.put("dr_disk_size", dataRepository.getMainBlocksDiskSizeOlderThan(dataRepository.mainBlockRetentionDays()));
            infoObj.put(reposName.getString(i), (Object)jcomputedResponse);
        }
        return new JSONObject().put("dr_archive_page_info", (Object)infoObj);
    }

    public static JSONObject syncSchedulerInterval(DataRepositoryActionRequest request) throws Exception {
        boolean res;
        JSONObject jResponse = new JSONObject();
        int hourOfTheDay = request.archiveSchedulerInterval();
        File file = SchedulerType.COMMON_ROUTINE.jobsFile();
        String jsonString = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
        JSONObject scheduleList = new JSONObject(jsonString);
        JSONArray scheduleArray = scheduleList.getJSONArray("schedule");
        for (int i = 0; i < scheduleArray.length(); ++i) {
            JSONObject archiveJob = scheduleArray.getJSONObject(i);
            JSONObject trigger = archiveJob.getJSONObject("trigger");
            String triggerName = trigger.getString("name");
            if (!triggerName.equalsIgnoreCase("ArchiveJobTrigger")) continue;
            JSONObject updatedCron = trigger.getJSONObject("cron").put("cronExpression", (Object)("0 0 " + hourOfTheDay + " ? * * *"));
            trigger.put("cron", (Object)updatedCron);
            archiveJob.put("trigger", (Object)trigger);
            scheduleArray.put(i, (Object)archiveJob);
            scheduleList.put("schedule", (Object)scheduleArray);
            Files.write(Paths.get(file.getAbsolutePath(), new String[0]), scheduleList.toString(4).getBytes(), new OpenOption[0]);
            break;
        }
        jResponse.put("error_code", (res = XNodeManager.rescheduleScheduler("0 0 " + hourOfTheDay + " ? * * *")) ? 0 : -1);
        return jResponse;
    }

    public static JSONObject fetchDeletedBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONArray repoNames = request.dataRepositoryList();
        JSONArray mergeList = new JSONArray();
        for (int i = 0; i < repoNames.length(); ++i) {
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoNames.getString(i));
            JSONArray jComputedResp = dataRepository.fetchDeletedBlocksMeta(request).getJSONArray("dr_deleted_blocks_meta");
            for (int ai = 0; ai < jComputedResp.length(); ++ai) {
                mergeList.put((Object)jComputedResp.getJSONObject(ai));
            }
        }
        return new JSONObject().put("dr_deleted_blocks_meta", (Object)mergeList);
    }

    public static JSONObject updateDRMetaInfo(DataRepositoryActionRequest request) throws Exception {
        boolean value = true;
        JSONObject jResponse = new JSONObject();
        for (Map.Entry<String, DataRepository> entry : dataRepositoryMap.entrySet()) {
            DataRepository dataRepository = entry.getValue();
            if (!dataRepository.containerName().equalsIgnoreCase("audit-log") || dataRepository.updateDRMetaInfo(request).getBoolean("update_success")) continue;
            value = false;
        }
        return jResponse.put("update_success", value);
    }

    private static boolean checkArchiveFolderPermission(String archivePath) {
        try {
            File file = new File(archivePath + File.separator + System.currentTimeMillis() + "_adap.txt");
            if (file.createNewFile()) {
                file.delete();
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static JSONObject addDRMetaCol(DataRepositoryActionRequest request) throws Exception {
        boolean value = true;
        JSONObject jResponse = new JSONObject();
        for (Map.Entry<String, DataRepository> entry : dataRepositoryMap.entrySet()) {
            DataRepository dataRepository = entry.getValue();
            if (!dataRepository.containerName().equalsIgnoreCase("audit-log") || dataRepository.addDRMetaCol(request).optBoolean("add_success", false)) continue;
            value = false;
        }
        return jResponse.put("add_success", value);
    }

    static {
        currentArchiveLocation = null;
        data_repo_lock = new Object();
        isArchiveRunning = false;
    }
}

