/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.commons.utils.DEService;
import com.manageengine.dataengine.commons.utils.HealthState;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataRepositoryService
extends DEService {
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    protected boolean doStart() throws Exception {
        boolean status = false;
        try {
            status = DataRepositoryManager.initDataRepositoryManager();
            if (status) {
                this.setHealth(HealthState.GREEN);
            }
        }
        catch (Throwable e) {
            this.setHealth(HealthState.RED);
            LOGGER.error("EXCEPTION : Unable to start DataRepository service : " + e.getMessage());
            throw e;
        }
        return status;
    }

    protected boolean doStop() {
        boolean status = DataRepositoryManager.stopDataRepositories();
        this.setHealth(HealthState.RED);
        LOGGER.info("STOPPING DataRepositoryService, isStopped : " + status);
        return status;
    }

    protected boolean doClose() {
        boolean status = DataRepositoryManager.closeDataRepositories();
        this.setHealth(HealthState.RED);
        LOGGER.info("CLOSING DataRepositoryService, isClosed : " + status);
        return status;
    }

    protected boolean doFail() {
        this.setHealth(HealthState.RED);
        return true;
    }
}

