/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.commons.datarepository.XNodeDRConfFile;
import com.manageengine.dataengine.commons.utils.ConsoleOut;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryActionRequest;
import com.manageengine.dataengine.xnode.datarepository.GenericDRBlock;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import java.io.File;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.apache.lucene.store.AlreadyClosedException;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenericDR
extends DataRepository {
    private HashMap<String, GenericDRBlock> hotBlockMap;
    private HashMap<String, GenericDRBlock> coldBlockMap;
    private HashMap<String, GenericDRBlock> coldToHotBlockMap;
    private BlockingQueue<GenericDRBlock> hotBlockQueue;
    public final Object dr_lock = new Object();
    private volatile boolean shutdown = false;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> schedulerFuture;
    private int hotIndexErrCount = 0;
    private int blockingQueueTimeout = (Integer)Environment.XNODE_DE_RESTART_BLOCKING_QUEUE_TIMEOUT.value();
    private int commitFailureThreshold = (Integer)Environment.XNODE_DE_RESTART_COMMIT_FAILURE_THRESHOLD.value();
    private int commitFailureCount = 0;
    private boolean restartedAlready = false;
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    public GenericDR(XNodeDRConfFile.DataRepositoryBean drBean) throws Exception {
        super(drBean);
        this.initBlocksMetaFile();
        this.loadMainBlocksFromMetaFile();
        this.initHotBlocks();
        if (this.hotBlockRefreshInterval() != 0) {
            this.schedulerFuture = this.scheduler.scheduleWithFixedDelay(new HotIndexCommitter(), 0L, this.hotBlockRefreshInterval(), TimeUnit.SECONDS);
        }
    }

    @Override
    public GenericDR update(XNodeDRConfFile.DataRepositoryBean drBean) throws Exception {
        super.update(drBean);
        if (this.schedulerFuture != null) {
            this.schedulerFuture.cancel(false);
        }
        if (this.hotBlockRefreshInterval() != 0) {
            this.schedulerFuture = this.scheduler.scheduleWithFixedDelay(new HotIndexCommitter(), 0L, this.hotBlockRefreshInterval(), TimeUnit.SECONDS);
        }
        return this;
    }

    private void initBlocksMetaFile() throws Exception {
        try (Connection connection = DBManager.getStoreConnection();){
            if (!this.persistenceHandler().checkIfMetaFileExists(connection, MetaFileType.MAIN)) {
                LOGGER.info("CREATING Main-MetaInfo table for DataRepository '" + this.repositoryName() + "'");
                this.persistenceHandler().createMetaFile(connection, MetaFileType.MAIN);
            } else {
                LOGGER.info("Main-MetaInfo table for DataRepository '" + this.repositoryName() + "' already exists!");
            }
        }
    }

    private void initHotBlocks() throws Exception {
        int i;
        int diff;
        LOGGER.info("VALIDATING Hot-Blocks for DataRepository '" + this.repositoryName() + "', [Allowed Hot-Blocks count : " + this.hotBlockCount() + "] [Current Hot-Blocks count : " + this.hotBlockMap.size() + "]");
        if (this.hotBlockMap.size() < this.hotBlockCount()) {
            diff = this.hotBlockCount() - this.hotBlockMap.size();
            for (i = 0; i < diff; ++i) {
                this.createHotBlock();
            }
        } else if (this.hotBlockMap.size() > this.hotBlockCount()) {
            diff = this.hotBlockMap.size() - this.hotBlockCount();
            for (i = 0; i < diff; ++i) {
                this.moveHotBlockToCold(this.hotBlockMap.values().iterator().next());
            }
        }
        this.hotBlockQueue = new LinkedBlockingDeque<GenericDRBlock>(this.hotBlockCount());
        for (GenericDRBlock drBlock : this.hotBlockMap.values()) {
            this.hotBlockQueue.put(drBlock);
        }
    }

    private void loadMainBlocksFromMetaFile() throws Exception {
        this.hotBlockMap = new HashMap();
        this.coldBlockMap = new HashMap();
        this.coldToHotBlockMap = new HashMap();
        int errCount = 0;
        int batchFetchCount = 500;
        int fetchedCount = -1;
        int offset = 0;
        LOGGER.info("LOADING Main-Blocks for DataRepository '" + this.repositoryName() + "'");
        try (Connection storeCon = DBManager.getStoreConnection();){
            while (fetchedCount != 0) {
                JSONArray resultBlockList = this.persistenceHandler().readFromMetaFile(storeCon, MetaFileType.MAIN, offset, batchFetchCount);
                fetchedCount = resultBlockList.length();
                offset += batchFetchCount;
                for (int i = 0; i < fetchedCount; ++i) {
                    GenericDRBlock drBlock = null;
                    try {
                        drBlock = this.buildDRBlock(resultBlockList.getJSONObject(i));
                        if (drBlock != null && drBlock.currentBlockStateAction().toString().equalsIgnoreCase(GenericDRBlock.State.HOT.toString())) {
                            if (drBlock.isFull()) {
                                this.moveHotBlockToCold(drBlock);
                                continue;
                            }
                            this.hotBlockMap.put(drBlock.blockName(), drBlock);
                            continue;
                        }
                        if (drBlock != null && drBlock.currentBlockStateAction().toString().equalsIgnoreCase(GenericDRBlock.State.COLD.toString())) {
                            this.coldBlockMap.put(drBlock.blockName(), drBlock);
                            continue;
                        }
                        if (drBlock == null || !drBlock.currentBlockStateAction().toString().equalsIgnoreCase(GenericDRBlock.State.COLD__TO_HOT.toString())) continue;
                        this.coldToHotBlockMap.put(drBlock.blockName(), drBlock);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("EXCEPTION while loading Main-Block : " + (drBlock == null ? null : drBlock.blockName()) + " :: " + e.getMessage());
                        e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
                        ++errCount;
                    }
                }
            }
        }
        LOGGER.info("SUMMARY of Main-Blocks for DataRepository '" + this.repositoryName() + "' [Hot Blocks : " + this.hotBlockMap.size() + "] [Cold Blocks : " + this.coldBlockMap.size() + "] ColdToHot Blocks : " + this.coldToHotBlockMap.size() + "] [Error Blocks : " + errCount + "]");
    }

    protected GenericDRBlock buildDRBlock(JSONObject blockObj) throws Exception {
        GenericDRBlock block = null;
        String blockName = blockObj.getString("block_name");
        if (blockName != null) {
            int blockId = blockObj.getInt("block_id");
            String dataRepositoryName = blockObj.getString("datarepository_name");
            Long creationTime = blockObj.getLong("creation_time");
            String state = blockObj.getString("state");
            String status = blockObj.optString("status");
            int version = blockObj.getInt("version");
            String zipPassword = blockObj.optString("zip_password");
            Boolean isMerged = blockObj.optBoolean("is_merged");
            if (blockName == null || dataRepositoryName == null || creationTime == null || state == null) {
                throw new IllegalStateException("EXCEPTION while reading block meta file, either of blockName|dataRepositoryName|creationTime|state parameter's value is null!");
            }
            if (status == null || status.isEmpty()) {
                status = "-";
            }
            if (!this.repositoryName().equalsIgnoreCase(dataRepositoryName)) {
                throw new IllegalStateException("EXCEPTION while reading block meta file, dataRepositoryName doesn't match! Name in MetaFile : " + dataRepositoryName + ", Processing Name : " + this.repositoryName());
            }
            if (!state.startsWith(GenericDRBlock.State.HOT.toString()) && !state.startsWith(GenericDRBlock.State.COLD.toString())) {
                throw new IllegalStateException("EXCEPTION while reading block meta file, block " + blockName + " should be either in HOT or COLD or COLD__TO_HOT state, but current state - " + state + "!");
            }
            if (state.equalsIgnoreCase(GenericDRBlock.State.HOT.toString())) {
                block = GenericDRBlock.loadHotBlock(this, blockName, version, status, creationTime, blockId);
                block.encryptedZipPassword(zipPassword);
            } else {
                Long startTime = blockObj.optLong("range_from");
                Long endTime = blockObj.optLong("range_to");
                Integer docCount = blockObj.optInt("doc_count");
                Long size = blockObj.optLong("size");
                Long rawSize = blockObj.optLong("raw_size");
                block = GenericDRBlock.loadBlock(this, blockName, version, state, status, creationTime, startTime, endTime, docCount, size, rawSize, blockId);
                block.encryptedZipPassword(zipPassword);
                block.isMerged(isMerged);
            }
        }
        return block;
    }

    private void printAndRestart() {
        try {
            if (!this.restartedAlready) {
                Environment.updateDERestartStatus();
                ConsoleOut.println((String)"HOT-INDEX-CLOSED");
                this.restartedAlready = true;
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    private GenericDRBlock getHotBlockFromQueue() throws InterruptedException {
        GenericDRBlock drBlock = this.hotBlockQueue.poll(this.blockingQueueTimeout, TimeUnit.SECONDS);
        if (drBlock == null) {
            ++this.commitFailureCount;
            if (this.commitFailureCount > this.commitFailureThreshold) {
                LOGGER.error("TimeOut in Blocking Queue - Unable to commit. Failed for last " + this.commitFailureCount + " times. Going to Restart");
                this.printAndRestart();
            }
            return null;
        }
        this.commitFailureCount = 0;
        return drBlock;
    }

    private void commitHotBlocks() throws Exception {
        GenericDRBlock drBlock = this.getHotBlockFromQueue();
        if (drBlock == null) {
            return;
        }
        try {
            drBlock.commitIndex();
            this.hotIndexErrCount = 0;
        }
        catch (AlreadyClosedException ae) {
            ++this.hotIndexErrCount;
            LOGGER.error("HOT-INDEX-CLOSED : DRBlock '" + drBlock.blockName() + "' is closed! ErrCount : " + this.hotIndexErrCount);
            if (this.hotIndexErrCount > 100) {
                ae.printStackTrace();
                this.printAndRestart();
            }
        }
        finally {
            this.hotBlockQueue.put(drBlock);
        }
    }

    private GenericDRBlock createHotBlock() throws Exception {
        GenericDRBlock drBlock;
        if (this.coldToHotBlockMap.size() > 0) {
            drBlock = this.coldToHotBlockMap.remove(this.coldToHotBlockMap.keySet().iterator().next());
            drBlock.changeStateTo(GenericDRBlock.State.HOT);
            LOGGER.info("CHANGED STATE of DataRepository '" + this.repositoryName() + "' - Block '" + drBlock.blockName() + "' from COLD__TO_HOT to HOT");
        } else {
            Long currentTime = System.currentTimeMillis();
            String blockName = this.blockPrefix() + "_" + currentTime;
            drBlock = GenericDRBlock.createHotBlock(this, blockName, currentTime, 0);
            LOGGER.info("CREATED Hot-Block '" + drBlock.blockName() + "' for DataRepository '" + this.repositoryName() + "'");
        }
        this.hotBlockMap.put(drBlock.blockName(), drBlock);
        return drBlock;
    }

    private void moveHotBlockToCold(GenericDRBlock drBlock) throws Exception {
        drBlock.changeStateTo(GenericDRBlock.State.COLD);
        this.hotBlockMap.remove(drBlock.blockName());
        this.coldBlockMap.put(drBlock.blockName(), drBlock);
        LOGGER.info("CHANGED STATE of DataRepository '" + this.repositoryName() + "' - Block '" + drBlock.blockName() + "' from HOT to COLD");
    }

    @Override
    public ArrayList<DRBlock> getBlocksFromList(JSONArray blockNameList) {
        LOGGER.info("# Going to get Indices From Request");
        ArrayList<DRBlock> refDRBlockList = new ArrayList<DRBlock>();
        int totalIndcices = this.coldBlockMap.size() + this.coldToHotBlockMap.size() + this.hotBlockMap.size();
        int selectedIndcices = 0;
        HashMap<String, GenericDRBlock> blockMap = new HashMap<String, GenericDRBlock>(this.coldBlockMap);
        blockMap.putAll(this.coldToHotBlockMap);
        blockMap.putAll(this.hotBlockMap);
        for (DRBlock dRBlock : blockMap.values()) {
            String blockName = dRBlock.blockName();
            boolean flag = false;
            for (int i = 0; i < blockNameList.length(); ++i) {
                if (!blockNameList.getString(i).equalsIgnoreCase(blockName)) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            refDRBlockList.add(dRBlock);
            ++selectedIndcices;
        }
        LOGGER.info("[Selected Indices : " + selectedIndcices + "/" + totalIndcices + "]");
        return refDRBlockList;
    }

    @Override
    public ArrayList<DRBlock> getBlocksInRange(Long rangeFrom, Long rangeTo) throws Exception {
        LOGGER.info("# Going to get Indices in range : " + rangeFrom + " - " + rangeTo);
        ArrayList<DRBlock> refDRBlockList = new ArrayList<DRBlock>();
        int totalIndcices = this.coldBlockMap.size() + this.coldToHotBlockMap.size() + this.hotBlockMap.size();
        int selectedIndcices = 0;
        HashMap<String, GenericDRBlock> blockMap = new HashMap<String, GenericDRBlock>(this.coldBlockMap);
        blockMap.putAll(this.coldToHotBlockMap);
        for (DRBlock dRBlock : blockMap.values()) {
            Long blockRangeFrom = dRBlock.rangeFrom();
            Long blockRangeTo = dRBlock.rangeTo();
            if (rangeFrom == null || rangeTo == null || blockRangeFrom == null || blockRangeTo == null || !(blockRangeFrom >= rangeFrom && blockRangeTo <= rangeTo || blockRangeFrom <= rangeFrom && blockRangeTo >= rangeTo || blockRangeFrom >= rangeFrom && blockRangeFrom <= rangeTo) && (blockRangeTo < rangeFrom || blockRangeTo > rangeTo)) continue;
            refDRBlockList.add(dRBlock);
            ++selectedIndcices;
        }
        blockMap = new HashMap<String, GenericDRBlock>(this.hotBlockMap);
        for (DRBlock dRBlock : blockMap.values()) {
            refDRBlockList.add(dRBlock);
            ++selectedIndcices;
        }
        LOGGER.info("[Selected Indices : " + selectedIndcices + "/" + totalIndcices + "]");
        return refDRBlockList;
    }

    @Override
    public long getMainBlocksDiskSizeOlderThan(int noDays) throws Exception {
        long totalSize = 0L;
        for (GenericDRBlock drBlock : this.coldBlockMap.values()) {
            if (!drBlock.isOlderThan(noDays)) continue;
            totalSize += FileUtils.sizeOf((File)new File(drBlock.blockPath()));
        }
        for (GenericDRBlock drBlock : this.coldToHotBlockMap.values()) {
            if (!drBlock.isOlderThan(noDays)) continue;
            totalSize += FileUtils.sizeOf((File)new File(drBlock.blockPath()));
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject addData(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        if (!this.isStopping()) {
            GenericDRBlock hotBlock = this.hotBlockQueue.take();
            Object object = hotBlock.index_lock;
            synchronized (object) {
                try {
                    jResponse = request.dataFilePath() != null ? hotBlock.addDataToIndex(request.dataFilePath(), request.fileEncoding(), request.splitBy()) : hotBlock.addDataToIndex(request.bulkData());
                }
                catch (AlreadyClosedException ae) {
                    LOGGER.error("HOT-INDEX-CLOSED : DRBlock '" + hotBlock.blockName() + "' is closed!");
                    ae.printStackTrace();
                    this.printAndRestart();
                }
                finally {
                    if (hotBlock.isFull()) {
                        this.moveHotBlockToCold(hotBlock);
                        this.hotBlockQueue.put(this.createHotBlock());
                    } else {
                        this.hotBlockQueue.put(hotBlock);
                    }
                }
            }
        }
        throw new Exception("DataEngine XNode is shutting down!");
        return jResponse;
    }

    @Override
    public JSONObject updateData(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("indexUpdateData not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject deleteData(DataRepositoryActionRequest request) throws Exception {
        LOGGER.info("Delete Query : " + request.query());
        JSONObject jResponse = new JSONObject();
        if (!this.isStopping()) {
            HashMap<String, GenericDRBlock> tempBlockMap = new HashMap<String, GenericDRBlock>();
            Object object = this.dr_lock;
            synchronized (object) {
                for (GenericDRBlock genericDRBlock : this.hotBlockMap.values()) {
                    tempBlockMap.put(genericDRBlock.blockName(), genericDRBlock);
                }
                for (GenericDRBlock genericDRBlock : this.coldToHotBlockMap.values()) {
                    tempBlockMap.put(genericDRBlock.blockName(), genericDRBlock);
                }
                for (GenericDRBlock genericDRBlock : this.coldBlockMap.values()) {
                    tempBlockMap.put(genericDRBlock.blockName(), genericDRBlock);
                }
            }
            for (GenericDRBlock drBlock3 : tempBlockMap.values()) {
                Object object2 = drBlock3.index_lock;
                synchronized (object2) {
                    drBlock3.deleteDataFromIndex(request.query());
                }
            }
            object = this.dr_lock;
            synchronized (object) {
                Iterator<Map.Entry<String, GenericDRBlock>> coldBlockIter = this.coldBlockMap.entrySet().iterator();
                while (coldBlockIter.hasNext()) {
                    GenericDRBlock genericDRBlock = coldBlockIter.next().getValue();
                    Object object3 = genericDRBlock.index_lock;
                    synchronized (object3) {
                        if (!genericDRBlock.isFull()) {
                            genericDRBlock.changeStateTo(GenericDRBlock.State.COLD__TO_HOT);
                            this.coldToHotBlockMap.put(genericDRBlock.blockName(), genericDRBlock);
                            coldBlockIter.remove();
                        }
                    }
                }
            }
        }
        throw new Exception("DataEngine XNode is shutting down!");
        jResponse.put("error_code", 0);
        jResponse.put("error_count", 0);
        return jResponse;
    }

    @Override
    public JSONObject syncBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("syncBlocksMeta not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    @Override
    public void archiveOldBlocks() throws Exception {
        throw new UnsupportedOperationException("archiveOldBlocks not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    @Override
    public JSONObject loadArchiveBlocks(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("loadArchiveBlocks not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    @Override
    public JSONObject unloadArchiveBlocks(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("unloadArchiveBlocks not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    @Override
    public JSONObject addMigrationData(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("addMigrationData not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    @Override
    public JSONObject validateMigrationData(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("validateMigrationData not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop() throws Exception {
        Object object;
        File repoFile = new File(this.defaultMainBlocksLocation());
        for (GenericDRBlock drBlock : this.hotBlockMap.values()) {
            object = drBlock.index_lock;
            synchronized (object) {
                drBlock.currentBlockStateAction().closeIndexWriter();
            }
        }
        for (GenericDRBlock drBlock : this.coldToHotBlockMap.values()) {
            object = drBlock.index_lock;
            synchronized (object) {
                drBlock.currentBlockStateAction().closeIndexWriter();
            }
        }
        for (GenericDRBlock drBlock : this.coldBlockMap.values()) {
            object = drBlock.index_lock;
            synchronized (object) {
                drBlock.currentBlockStateAction().closeIndexWriter();
            }
        }
        FileUtils.deleteQuietly((File)repoFile);
        if (repoFile.exists()) {
            LOGGER.info("DELETE DataRepository :: FAILED to delete dir '" + this.defaultMainBlocksLocation() + "'!");
        } else {
            LOGGER.info("DELETE DataRepository :: deleted dir '" + this.defaultMainBlocksLocation() + "'!");
        }
        try (Connection connection = DBManager.getStoreConnection();){
            this.persistenceHandler().dropMetaFile(connection, MetaFileType.MAIN);
        }
        this.persistenceHandler().deleteMetaFile(MetaFileType.MAIN);
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        LOGGER.info("DROPPED DataRepository '" + this.repositoryName() + "'");
        return true;
    }

    @Override
    public void doStop() {
        this.shutdown = true;
    }

    @Override
    public boolean doClose() {
        boolean isSuccess = true;
        try {
            this.scheduler.shutdown();
            this.commitHotBlocks();
        }
        catch (Exception e) {
            isSuccess = false;
            e.printStackTrace();
        }
        return isSuccess;
    }

    @Override
    public boolean isStopping() {
        return this.shutdown;
    }

    @Override
    public JSONObject fetchToDeleteBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("fetchToDeleteBlocksMeta not supported for Generic Repository '" + this.repositoryName() + "'!");
    }

    private final class HotIndexCommitter
    implements Runnable {
        private HotIndexCommitter() {
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setName("HotIndexCommitter_" + GenericDR.this.repositoryName());
                GenericDR.this.commitHotBlocks();
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.error("EXCEPTION HotIndexCommitter : " + e.getMessage());
            }
        }
    }
}

