/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DRBlockState;
import com.manageengine.dataengine.xnode.datarepository.DRBlockStateFacade;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.LuceneIndexHandler;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchService;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.SetOnce;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.json.JSONObject;

public class GenericDRBlock
extends DRBlock {
    private final SetOnce<DRBlockStateFacade> stateFacade = new SetOnce();
    private volatile IndexWriter mainIndexWriter;
    public final Object index_lock = new Object();
    public final Object index_reader_lock = new Object();
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");
    private final DRBlockState hot = new DRBlockState("HOT"){

        @Override
        protected void init(DRBlockState oldState) throws Exception {
            GenericDRBlock.this.mainIndexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", GenericDRBlock.this.dataRepository().getAnalyzerWrapper(), GenericDRBlock.this.dataRepository().getIndexSortObj());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != GenericDRBlock.this.cold && newState != GenericDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
            int currentDocCount = 0;
            try {
                IndexWriter indexWriter = this.indexWriter();
                int n = currentDocCount = indexWriter == null ? 0 : indexWriter.numDocs();
                if (indexWriter != null) {
                    indexWriter.forceMerge(1, true);
                }
            }
            finally {
                this.closeIndexWriter();
            }
            GenericDRBlock.this.isMerged(SearchService.getSegmentCount(GenericDRBlock.this) == 1);
            JSONObject jRes = SearchService.getMinMaxLongField(GenericDRBlock.this.dataRepository().schema().getRangeField(), GenericDRBlock.this);
            GenericDRBlock.this.rangeFrom(jRes.getLong("min") == -1L ? 0L : jRes.getLong("min"));
            GenericDRBlock.this.rangeTo(jRes.getLong("max") == -1L ? 0L : jRes.getLong("max"));
            GenericDRBlock.this.docCount(currentDocCount);
            GenericDRBlock.this.size(FileUtils.sizeOf((File)new File(this.blockPath())));
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            GenericDRBlock.this.updateToMetaFile(MetaFileType.MAIN);
        }

        @Override
        protected IndexWriter indexWriter() throws Exception {
            return GenericDRBlock.this.mainIndexWriter;
        }

        @Override
        protected void commitIndexWriter() throws Exception {
            if (GenericDRBlock.this.mainIndexWriter != null && GenericDRBlock.this.mainIndexWriter.isOpen() && GenericDRBlock.this.mainIndexWriter.hasUncommittedChanges()) {
                LOGGER.debug("COMMITING HOT Block - '" + GenericDRBlock.this.blockName() + "'!");
                GenericDRBlock.this.mainIndexWriter.commit();
            }
        }

        @Override
        protected void closeIndexWriter() throws Exception {
            if (GenericDRBlock.this.mainIndexWriter != null) {
                GenericDRBlock.this.mainIndexWriter.commit();
                GenericDRBlock.this.mainIndexWriter.close();
                GenericDRBlock.this.mainIndexWriter.getDirectory().close();
                GenericDRBlock.this.mainIndexWriter = null;
            }
        }

        @Override
        protected int docCount() throws Exception {
            return (int)SearchService.getDocCount(GenericDRBlock.this);
        }

        @Override
        protected String blockPath() {
            return GenericDRBlock.this.dataRepository().defaultMainBlocksLocation() + File.separator + GenericDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState cold = new DRBlockState("COLD"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != GenericDRBlock.this.cold__to_hot && newState != GenericDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
            JSONObject jRes = SearchService.getMinMaxLongField(GenericDRBlock.this.dataRepository().schema().getRangeField(), GenericDRBlock.this);
            int currentDocCount = (int)SearchService.getDocCount(GenericDRBlock.this);
            GenericDRBlock.this.rangeFrom(jRes.getLong("min") == -1L ? 0L : jRes.getLong("min"));
            GenericDRBlock.this.rangeTo(jRes.getLong("max") == -1L ? 0L : jRes.getLong("max"));
            GenericDRBlock.this.docCount(currentDocCount);
            GenericDRBlock.this.size(FileUtils.sizeOf((File)new File(this.blockPath())));
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            GenericDRBlock.this.updateToMetaFile(MetaFileType.MAIN);
        }

        @Override
        protected IndexWriter indexWriter() throws Exception {
            GenericDRBlock.this.mainIndexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", GenericDRBlock.this.dataRepository().getAnalyzerWrapper(), GenericDRBlock.this.dataRepository().getIndexSortObj());
            return GenericDRBlock.this.mainIndexWriter;
        }

        @Override
        protected void commitIndexWriter() throws Exception {
            if (GenericDRBlock.this.mainIndexWriter != null && GenericDRBlock.this.mainIndexWriter.hasUncommittedChanges()) {
                GenericDRBlock.this.mainIndexWriter.commit();
            }
        }

        @Override
        protected void closeIndexWriter() throws Exception {
            if (GenericDRBlock.this.mainIndexWriter != null) {
                GenericDRBlock.this.mainIndexWriter.commit();
                GenericDRBlock.this.mainIndexWriter.close();
                GenericDRBlock.this.mainIndexWriter.getDirectory().close();
                GenericDRBlock.this.mainIndexWriter = null;
            }
        }

        @Override
        protected int docCount() throws Exception {
            return (int)SearchService.getDocCount(GenericDRBlock.this);
        }

        @Override
        protected String blockPath() {
            return GenericDRBlock.this.dataRepository().defaultMainBlocksLocation() + File.separator + GenericDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState cold__to_hot = new DRBlockState("COLD__TO_HOT"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != GenericDRBlock.this.hot && newState != GenericDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
            JSONObject jRes = SearchService.getMinMaxLongField(GenericDRBlock.this.dataRepository().schema().getRangeField(), GenericDRBlock.this);
            int currentDocCount = (int)SearchService.getDocCount(GenericDRBlock.this);
            GenericDRBlock.this.rangeFrom(jRes.getLong("min") == -1L ? 0L : jRes.getLong("min"));
            GenericDRBlock.this.rangeTo(jRes.getLong("max") == -1L ? 0L : jRes.getLong("max"));
            GenericDRBlock.this.docCount(currentDocCount);
            GenericDRBlock.this.size(FileUtils.sizeOf((File)new File(this.blockPath())));
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            GenericDRBlock.this.updateToMetaFile(MetaFileType.MAIN);
        }

        @Override
        protected IndexWriter indexWriter() throws Exception {
            GenericDRBlock.this.mainIndexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", GenericDRBlock.this.dataRepository().getAnalyzerWrapper(), GenericDRBlock.this.dataRepository().getIndexSortObj());
            return GenericDRBlock.this.mainIndexWriter;
        }

        @Override
        protected void commitIndexWriter() throws Exception {
            if (GenericDRBlock.this.mainIndexWriter != null && GenericDRBlock.this.mainIndexWriter.hasUncommittedChanges()) {
                GenericDRBlock.this.mainIndexWriter.commit();
            }
        }

        @Override
        protected void closeIndexWriter() throws Exception {
            if (GenericDRBlock.this.mainIndexWriter != null) {
                GenericDRBlock.this.mainIndexWriter.commit();
                GenericDRBlock.this.mainIndexWriter.close();
                GenericDRBlock.this.mainIndexWriter.getDirectory().close();
                GenericDRBlock.this.mainIndexWriter = null;
            }
        }

        @Override
        protected int docCount() throws Exception {
            return (int)SearchService.getDocCount(GenericDRBlock.this);
        }

        @Override
        protected String blockPath() {
            return GenericDRBlock.this.dataRepository().defaultMainBlocksLocation() + File.separator + GenericDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState error = new DRBlockState("ERROR"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
        }

        @Override
        protected String blockPath() {
            return null;
        }
    };

    @Override
    protected DRBlockState blockState(DRBlock.State state) {
        switch ((State)state) {
            case HOT: {
                return this.hot;
            }
            case COLD: {
                return this.cold;
            }
            case COLD__TO_HOT: {
                return this.cold__to_hot;
            }
            case ERROR: {
                return this.error;
            }
        }
        return null;
    }

    private GenericDRBlock(DataRepository dataRepository, String blockName, int version, State state, String status, Long creationTime, int metaIndex, boolean isNew) throws Exception {
        super(dataRepository, blockName, version, status, creationTime, metaIndex, isNew);
        if (blockName == null || dataRepository == null || creationTime == null) {
            throw new NullPointerException("Trying to initailize DRBlock with blockName|dataRepository|creationTime's value as null!");
        }
        this.stateFacade.set((Object)new DRBlockStateFacade(this.blockState(state)));
        if (isNew) {
            try (Connection connection = DBManager.getStoreConnection();){
                MetaFileType metaFileType = isNew ? MetaFileType.MAIN : MetaFileType.ARCHIVE;
                this.dataRepository().persistenceHandler().addToMetaFile(connection, this, metaFileType);
            }
        }
        this.updateStateFile();
    }

    public static GenericDRBlock createHotBlock(DataRepository dataRepository, String blockName, Long creationTime, int metaIndex) throws Exception {
        GenericDRBlock block = new GenericDRBlock(dataRepository, blockName, 10, State.HOT, "-", creationTime, metaIndex, true);
        try {
            block.commitIndex();
        }
        catch (AlreadyClosedException ae) {
            LOGGER.error("HOT-INDEX-CLOSED : DRBlock '" + block.blockName() + "' is closed! ");
            throw ae;
        }
        return block;
    }

    public static GenericDRBlock loadHotBlock(DataRepository dataRepository, String blockName, int version, String status, Long creationTime, int metaIndex) throws Exception {
        GenericDRBlock block = new GenericDRBlock(dataRepository, blockName, version, State.HOT, status, creationTime, metaIndex, false);
        return block;
    }

    public static GenericDRBlock loadBlock(DataRepository dataRepository, String blockName, int version, String stateStr, String status, Long creationTime, Long startTime, Long endTime, Integer docCount, Long size, Long rawSize, int metaIndex) throws Exception {
        State state = State.get(stateStr);
        if (state == null) {
            throw new IllegalStateException("EXCEPTION while Loading DRBlock, " + blockName + " not in expected state! current state - " + state);
        }
        if (startTime == null || endTime == null || docCount == null || size == null || rawSize == null || startTime == -1L || endTime == -1L || docCount == -1 || size == -1L || rawSize == -1L) {
            throw new NullPointerException("Trying to LOAD DRBlock with startTime|endTime|docCount|size|rawSize's value as null!");
        }
        GenericDRBlock block = new GenericDRBlock(dataRepository, blockName, version, state, status, creationTime, metaIndex, false);
        block.rangeFrom(startTime);
        block.rangeTo(endTime);
        block.docCount(docCount);
        block.size(size);
        block.rawSize(rawSize);
        return block;
    }

    @Override
    public DRBlockState currentBlockStateAction() {
        return ((DRBlockStateFacade)this.stateFacade.get()).state();
    }

    @Override
    public DRBlockState currentBlockStateFacade() {
        return (DRBlockState)this.stateFacade.get();
    }

    @Override
    public boolean isOlderThan(int noDays) throws Exception {
        if (this.currentBlockStateAction() != this.cold) {
            return false;
        }
        DateTime nowDate = DateTime.now();
        DateTime blockEndTime = new DateTime(this.rangeTo() * 1000L);
        int dayDiff = Days.daysBetween((ReadableInstant)blockEndTime, (ReadableInstant)nowDate).getDays();
        return dayDiff >= noDays;
    }

    @Override
    public void updateStateFile() throws Exception {
        File[] matchingFiles = new File(this.blockPath()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("block.state");
            }
        });
        if (matchingFiles != null && (this.currentBlockStateAction().toString().startsWith(this.hot.toString()) || this.currentBlockStateAction().toString().startsWith(this.cold.toString()))) {
            for (File file : matchingFiles) {
                file.delete();
            }
            new File(this.blockPath() + File.separator + "block.state." + this.currentBlockStateAction().toString().toLowerCase()).createNewFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteDataFromIndex(Query query) throws Exception {
        JSONObject jResponse = new JSONObject();
        try {
            IndexWriter indexWriter = this.currentBlockStateAction().indexWriter();
            indexWriter.deleteDocuments(new Query[]{query});
            indexWriter.commit();
        }
        finally {
            if (!this.currentBlockStateAction().toString().startsWith(this.hot.toString())) {
                this.currentBlockStateAction().closeIndexWriter();
            }
        }
        jResponse.put("error_code", 0);
        jResponse.put("error_count", 0);
        return jResponse;
    }

    public static enum State implements DRBlock.State
    {
        HOT("HOT"),
        COLD("COLD"),
        COLD__TO_HOT("COLD__TO_HOT"),
        ERROR("ERROR");

        private String stateText;

        private State(String stateText) {
            this.stateText = stateText;
        }

        public String toString() {
            return this.stateText;
        }

        public static State get(String stateText) {
            for (State stateType : State.values()) {
                if (!stateType.stateText.equalsIgnoreCase(stateText)) continue;
                return stateType;
            }
            return null;
        }
    }
}

