/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.facet.taxonomy.writercache.LruTaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneIndexHandler {
    private static final int MAX_NO_OF_CACHED_QUERIES = 256;
    private static final long MAX_RAM_BYTES = 0x1400000L;
    public static HashMap<DRBlock, IndexReader> drBlockIRMap = new HashMap();
    public static HashMap<DRBlock, AtomicInteger> drBlockIRRefCountMap = new HashMap();
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    public static Directory getIndexDirectory(String indexPath) throws IOException {
        return FSDirectory.open((Path)Paths.get(indexPath, new String[0]));
    }

    public static IndexWriter getIndexWriter(String indexPath, Analyzer analyzer) throws IOException {
        return LuceneIndexHandler.getIndexWriter(indexPath, analyzer, null);
    }

    public static IndexWriter getIndexWriter(String indexPath, Analyzer analyzer, Sort indexSort) throws IOException {
        IndexWriter indexWriter = null;
        FSDirectory dir = FSDirectory.open((Path)Paths.get(indexPath, new String[0]));
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        iwc.setRAMBufferSizeMB(10.0);
        if (indexSort != null) {
            iwc.setIndexSort(indexSort);
        }
        indexWriter = new IndexWriter((Directory)dir, iwc);
        return indexWriter;
    }

    public static IndexWriter getIndexWriterIfExist(String indexPath, Analyzer analyzer) throws IOException {
        IndexWriter indexWriter = null;
        FSDirectory dir = FSDirectory.open((Path)Paths.get(indexPath, new String[0]));
        if (DirectoryReader.indexExists((Directory)dir)) {
            IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            iwc.setRAMBufferSizeMB(10.0);
            indexWriter = new IndexWriter((Directory)dir, iwc);
        }
        return indexWriter;
    }

    public static IndexSearcher getIndexSearcher(DRBlock ... drBlocks) throws IOException {
        return LuceneIndexHandler.getIndexSearcher(Arrays.asList(drBlocks));
    }

    public static IndexSearcher getIndexSearcher(List<DRBlock> drBlocks) throws IOException {
        IndexSearcher indexSearcher = null;
        IndexReader multiReader = LuceneIndexHandler.getIndexReader(drBlocks);
        if (multiReader != null) {
            indexSearcher = new IndexSearcher(multiReader);
            indexSearcher.setQueryCache((QueryCache)new LRUQueryCache(256, 0x1400000L));
            indexSearcher.setQueryCachingPolicy((QueryCachingPolicy)new UsageTrackingQueryCachingPolicy());
        }
        return indexSearcher;
    }

    public static void releaseIndexSearcher(IndexSearcher indexSearcher, DRBlock ... drBlocks) throws IOException {
        LuceneIndexHandler.releaseIndexSearcher(indexSearcher, Arrays.asList(drBlocks));
    }

    public static void releaseIndexSearcher(IndexSearcher indexSearcher, List<DRBlock> drBlocks) throws IOException {
        for (DRBlock dRBlock : drBlocks) {
            LuceneIndexHandler.releaseIndexReader(dRBlock);
        }
    }

    private static IndexReader getIndexReader(String indexPath) throws IOException {
        DirectoryReader indexReader = null;
        FSDirectory directory = FSDirectory.open((Path)Paths.get(indexPath, new String[0]));
        if (DirectoryReader.indexExists((Directory)directory)) {
            indexReader = DirectoryReader.open((Directory)directory);
        }
        return indexReader;
    }

    public static IndexReader getIndexReader(DRBlock ... refDRBlockList) throws IOException {
        return LuceneIndexHandler.getIndexReader(Arrays.asList(refDRBlockList));
    }

    public static IndexReader getIndexReader(List<DRBlock> refDRBlockList) throws IOException {
        IndexReader[] readers = null;
        ArrayList<IndexReader> indexReaderList = new ArrayList<IndexReader>();
        for (DRBlock dRBlock : refDRBlockList) {
            IndexReader indexReader = LuceneIndexHandler.acquireIndexReader(dRBlock);
            if (indexReader == null) continue;
            indexReaderList.add(indexReader);
        }
        int i = 0;
        if (indexReaderList.size() > 0) {
            readers = new IndexReader[indexReaderList.size()];
            for (IndexReader indexReader : indexReaderList) {
                readers[i++] = indexReader;
            }
        }
        if (readers == null) {
            return null;
        }
        return new MultiReader(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexReader acquireIndexReader(DRBlock drBlock) throws IOException {
        IndexReader indexReader = null;
        Object object = drBlock.index_reader_lock;
        synchronized (object) {
            indexReader = drBlockIRMap.get(drBlock);
            if (indexReader == null || !indexReader.tryIncRef()) {
                indexReader = LuceneIndexHandler.getIndexReader(drBlock.blockPath() + "luc-index");
                drBlockIRMap.put(drBlock, indexReader);
                LOGGER.trace("LUCENE : New index reader, DRBlock : " + drBlock.blockName() + ", indexReader : " + indexReader);
            }
            LOGGER.trace("LUCENE : IndexReader ACQUIRE : DRBlock : " + drBlock.blockName() + ", RefCount : " + (indexReader == null ? null : Integer.valueOf(indexReader.getRefCount())));
        }
        return indexReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseIndexReader(DRBlock drBlock) throws IOException {
        Object object = drBlock.index_reader_lock;
        synchronized (object) {
            IndexReader indexReader = drBlockIRMap.get(drBlock);
            if (indexReader == null || indexReader.getRefCount() == 0) {
                LOGGER.error("EXCEPTION : Trying to release a non-referenced IndexReader, DRBlock : " + drBlock.blockName() + ", indexReader : " + (indexReader == null ? "null" : "0"));
            } else {
                indexReader.decRef();
                LOGGER.trace("LUCENE : IndexReader RELEASE : DRBlock : " + drBlock.blockName() + ", RefCount : " + indexReader.getRefCount());
                if (indexReader.getRefCount() == 0) {
                    indexReader.close();
                    indexReader = null;
                    drBlockIRMap.remove(drBlock);
                }
            }
        }
    }

    public static int getIndexReaderRefCount(DRBlock drBlock) throws IOException {
        IndexReader indexReader = drBlockIRMap.get(drBlock);
        return indexReader == null ? 0 : indexReader.getRefCount();
    }

    public static void logIndexReaderRefCount(DRBlock drBlock) throws IOException {
        IndexReader indexReader = drBlockIRMap.get(drBlock);
        LOGGER.info("LUCENE : IndexReader REF-COUNT : DRBlock : " + drBlock.blockName() + ", RefCount : " + (indexReader == null ? "null" : Integer.valueOf(indexReader.getRefCount())));
    }

    private static TaxonomyReader getTaxoReader(String indexPath) throws IOException {
        DirectoryTaxonomyReader taxoReader = null;
        FSDirectory dir = FSDirectory.open((Path)Paths.get(indexPath, new String[0]));
        if (DirectoryReader.indexExists((Directory)dir)) {
            taxoReader = new DirectoryTaxonomyReader((Directory)dir);
        }
        return taxoReader;
    }

    private static DirectoryTaxonomyWriter getTaxoWriter(String indexPath) throws IOException {
        FSDirectory dir = FSDirectory.open((Path)Paths.get(indexPath, new String[0]));
        LruTaxonomyWriterCache cache = new LruTaxonomyWriterCache(1000);
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter((Directory)dir, IndexWriterConfig.OpenMode.CREATE_OR_APPEND, (TaxonomyWriterCache)cache);
        return taxoWriter;
    }
}

