/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search;

import com.manageengine.dataengine.xnode.datarepository.search.QuerySearchResult;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.SearchPhase;
import com.manageengine.dataengine.xnode.datarepository.search.TimeFilteredCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationPhase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;

public class QueryPhase
implements SearchPhase {
    private final AggregationPhase aggregationPhase = new AggregationPhase();
    private static final Logger LOGGER = LogManager.getLogger((String)"ActionTrace");

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext searchContext) throws IOException {
        this.executeSearch(searchContext);
        this.aggregationPhase.execute(searchContext);
    }

    public void executeSearch(SearchContext searchContext) throws IOException {
        if (searchContext.indexSearcherList() == null || searchContext.indexSearcherList().size() == 0) {
            LOGGER.warn("WARNING : No IndexReader found for this query request!");
            return;
        }
        if (searchContext.aggregations().aggregator() == null) {
            if (!searchContext.useMultiReader()) {
                this.searchAndMerge(searchContext);
            } else if (searchContext.size() <= 3000 || searchContext.searchAfterScoreDoc() == null) {
                if (searchContext.size() > 3000) {
                    LOGGER.error("EXCEPTION : Query has resultCount > 3000 but searchAfter is set to null! Querying using normal method!!");
                }
                this.search(searchContext);
            } else {
                this.searchAfter(searchContext);
            }
        } else {
            LOGGER.info("Going to search using customized collector");
            List<IndexSearcher> searcherList = searchContext.indexSearcherList();
            for (IndexSearcher searcher : searcherList) {
                searcher.search(searchContext.query(), searchContext.queryCollector());
            }
        }
    }

    private void search(SearchContext searchContext) throws IOException {
        IndexSearcher searcher = searchContext.indexSearcherList().get(0);
        int batchSize = 1000000;
        TopDocs topDocs = null;
        ScoreDoc afterScore = null;
        ScoreDoc[] scoreHits = null;
        int scoreLen = 0;
        int resultCount = batchSize;
        int resultFromIndex = searchContext.offset();
        int resultToIndex = searchContext.offset() + searchContext.size() - 1;
        QuerySearchResult searchResult = searchContext.queryResult();
        boolean lastBatch = false;
        for (int index = 0; index <= resultToIndex && !lastBatch; index += batchSize) {
            if (index <= resultFromIndex && resultFromIndex < index + batchSize) {
                resultCount = resultToIndex - index + 1;
                lastBatch = true;
            } else {
                resultCount = batchSize;
            }
            if (searchContext.businessHour() != null && (searchContext.businessHour() == 1 || searchContext.businessHour() == 2)) {
                TimeFilteredCollector collector = new TimeFilteredCollector(searchContext.timeField(), searchContext.businessHourFrom(), searchContext.businessHourTo(), searchContext.businessDays(), searchContext.businessHour(), searchContext.timeZoneId(), searchContext.sortBy(), resultCount, afterScore);
                searcher.search(searchContext.query(), (Collector)collector);
                topDocs = collector.collector().topDocs();
            } else {
                topDocs = searchContext.sortBy() == null ? searcher.searchAfter(afterScore, searchContext.query(), resultCount) : searcher.searchAfter(afterScore, searchContext.query(), resultCount, searchContext.sortBy());
            }
            if (topDocs == null || (scoreLen = (scoreHits = topDocs.scoreDocs).length) <= 0) continue;
            afterScore = scoreHits[scoreLen - 1];
            searchResult.searchAfter(afterScore.toString());
        }
        if (topDocs != null) {
            ArrayList<Document> topDocList = new ArrayList<Document>();
            int start = resultFromIndex % batchSize;
            int end = resultCount - 1;
            if (scoreLen - 1 < end) {
                end = scoreLen - 1;
            }
            for (int i = start; i <= end; ++i) {
                topDocList.add(searcher.doc(scoreHits[i].doc));
            }
            searchResult.topDocs(topDocList);
            searchResult.totalHits(topDocs.totalHits);
            searchResult.indexCount(searchContext.indexCount());
        }
    }

    private void searchAfter(SearchContext searchContext) throws IOException {
        IndexSearcher searcher = searchContext.indexSearcherList().get(0);
        TopDocs topDocs = null;
        ScoreDoc[] scoreHits = null;
        int scoreLen = 0;
        int resultCount = searchContext.size();
        if (searchContext.businessHour() != null && (searchContext.businessHour() == 1 || searchContext.businessHour() == 2)) {
            TimeFilteredCollector collector = new TimeFilteredCollector(searchContext.timeField(), searchContext.businessHourFrom(), searchContext.businessHourTo(), searchContext.businessDays(), searchContext.businessHour(), searchContext.timeZoneId(), searchContext.sortBy(), resultCount, searchContext.searchAfterScoreDoc());
            searcher.search(searchContext.query(), (Collector)collector);
            topDocs = collector.collector().topDocs();
        } else {
            topDocs = searchContext.sortBy() == null ? searcher.searchAfter(searchContext.searchAfterScoreDoc(), searchContext.query(), resultCount) : searcher.searchAfter(searchContext.searchAfterScoreDoc(), searchContext.query(), resultCount, searchContext.sortBy());
        }
        QuerySearchResult searchResult = searchContext.queryResult();
        if (topDocs != null) {
            scoreHits = topDocs.scoreDocs;
            scoreLen = scoreHits.length;
            if (scoreLen > 0) {
                ScoreDoc afterScore = scoreHits[scoreLen - 1];
                searchResult.searchAfter(afterScore.toString());
            }
            ArrayList<Document> topDocList = new ArrayList<Document>();
            int start = 0;
            int end = scoreLen < resultCount ? scoreLen - 1 : resultCount - 1;
            for (int i = start; i <= end; ++i) {
                topDocList.add(searcher.doc(scoreHits[i].doc));
            }
            searchResult.topDocs(topDocList);
            searchResult.totalHits(topDocs.totalHits);
            searchResult.indexCount(searchContext.indexCount());
        }
    }

    private void searchAndMerge(SearchContext searchContext) throws IOException {
        LOGGER.info("Search using TopDocs.merge, index count : " + searchContext.indexCount());
        Object topDocs = null;
        ScoreDoc[] scoreHits = null;
        int scoreLen = 0;
        int index = 0;
        int resultOffset = searchContext.offset();
        int resultCount = searchContext.size();
        int indexCount = searchContext.indexCount();
        long startTime = System.currentTimeMillis();
        QuerySearchResult searchResult = searchContext.queryResult();
        List<IndexSearcher> indexSearcherList = searchContext.indexSearcherList();
        Object[] topDocsList = null;
        topDocsList = searchContext.sortBy() == null ? new TopDocs[indexCount] : new TopFieldDocs[indexCount];
        for (IndexSearcher indexSearcher : indexSearcherList) {
            topDocsList[index] = searchContext.sortBy() == null ? indexSearcher.search(searchContext.query(), resultOffset + resultCount) : indexSearcher.search(searchContext.query(), resultOffset + resultCount, searchContext.sortBy());
            ++index;
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("Total search time : " + (endTime - startTime));
        startTime = System.currentTimeMillis();
        topDocs = searchContext.sortBy() == null ? TopDocs.merge((int)resultOffset, (int)resultCount, (TopDocs[])topDocsList, (boolean)true) : TopDocs.merge((Sort)searchContext.sortBy(), (int)resultOffset, (int)resultCount, (TopFieldDocs[])((TopFieldDocs[])topDocsList), (boolean)true);
        endTime = System.currentTimeMillis();
        LOGGER.info("Total merge time : " + (endTime - startTime));
        startTime = System.currentTimeMillis();
        if (topDocs != null) {
            scoreHits = topDocs.scoreDocs;
            scoreLen = scoreHits.length;
            ArrayList<Document> topDocList = new ArrayList<Document>();
            int start = 0;
            int end = scoreLen < resultCount ? scoreLen - 1 : resultCount - 1;
            for (int i = start; i <= end; ++i) {
                topDocList.add(indexSearcherList.get(scoreHits[i].shardIndex).doc(scoreHits[i].doc));
            }
            searchResult.topDocs(topDocList);
            searchResult.totalHits(topDocs.totalHits);
            searchResult.indexCount(searchContext.indexCount());
        }
        endTime = System.currentTimeMillis();
        LOGGER.info("Total result preparation time : " + (endTime - startTime));
    }
}

