/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search;

import com.manageengine.dataengine.xnode.connector.global.transport.TransportResponse;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QuerySearchResult
extends TransportResponse {
    private int offset;
    private int size;
    private long totalHits = 0L;
    private List<Document> topDocs = null;
    private Integer indexCount = 0;
    private String searchAfter = null;
    private AggregationResult aggregations = null;
    private boolean searchTimedOut = false;
    private Boolean terminatedEarly = null;
    private SearchContext searchContext;
    private static final Logger LOGGER = LogManager.getLogger((String)"ActionTrace");

    QuerySearchResult(long requestId, String actionType, SearchContext searchContext) {
        super(requestId, actionType);
        this.searchContext = searchContext;
    }

    public int offset() {
        return this.offset;
    }

    public void offset(int offset) {
        this.offset = offset;
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        this.size = size;
    }

    public long totalHits() {
        return this.totalHits;
    }

    public void totalHits(long totalHits) {
        this.totalHits = totalHits;
    }

    public List<Document> topDocs() {
        return this.topDocs;
    }

    public void topDocs(List<Document> topDocs) {
        this.topDocs = topDocs;
    }

    public AggregationResult aggregations() {
        return this.aggregations;
    }

    public void aggregations(AggregationResult aggregations) {
        this.aggregations = aggregations;
    }

    public boolean searchTimedOut() {
        return this.searchTimedOut;
    }

    public void searchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public void terminatedEarly(Boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
    }

    public Integer indexCount() {
        return this.indexCount;
    }

    public void indexCount(Integer indexCount) {
        this.indexCount = indexCount;
    }

    public String searchAfter() {
        return this.searchAfter;
    }

    public void searchAfter(String searchAfter) {
        this.searchAfter = searchAfter;
    }

    @Override
    public JSONObject castToJSON() throws JSONException {
        LOGGER.info("Going to process search result");
        JSONObject jResult = new JSONObject();
        List<Document> docList = this.topDocs();
        JSONArray jResultArr = new JSONArray();
        if (docList != null) {
            List<String> colList = this.searchContext.selectFields();
            for (Document doc : docList) {
                JSONArray jColValueArr = new JSONArray();
                for (String colName : colList) {
                    jColValueArr.put((Object)doc.get(colName));
                }
                jResultArr.put((Object)jColValueArr);
            }
        }
        jResult.put("search_result", (Object)jResultArr);
        jResult.put("total_hits", this.totalHits());
        jResult.put("index_count", (Object)this.indexCount());
        jResult.put("search_after", (Object)this.searchAfter());
        if (this.aggregations() != null) {
            LOGGER.info("Going to process aggregation result");
            jResult.put("aggr_result", (Object)this.aggregations().toJSON());
        }
        LOGGER.info("Processed search result");
        return jResult;
    }
}

