/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search;

import com.manageengine.dataengine.xnode.datarepository.search.QuerySearchResult;
import com.manageengine.dataengine.xnode.datarepository.search.SearchRequest;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;

public class SearchContext {
    private final long id;
    private QuerySearchResult queryResult = null;
    private Integer offset = 0;
    private Integer size = 10;
    private Query query;
    private Sort sortBy;
    private ScoreDoc searchAfterScoreDoc = null;
    private List<String> selectFields = null;
    private Integer businessHour = null;
    private Integer businessHourFrom = null;
    private Integer businessHourTo = null;
    private List<Integer> businessDays = null;
    private String timeZoneId = null;
    private String timeField = null;
    private Collector queryCollector;
    private volatile long keepAlive;
    private final long originNanoTime = System.nanoTime();
    private volatile long lastAccessTime = -1L;
    private Integer indexCount = 0;
    private boolean useMultiReader;
    private List<IndexSearcher> indexSearcherList = null;
    private Aggregation aggregations = new Aggregation();

    private SearchContext(SearchRequest request) {
        this.id = request.requestId();
        this.queryResult = new QuerySearchResult(request.requestId(), request.actionType(), this);
    }

    public static SearchContext build(SearchRequest request) {
        return new SearchContext(request);
    }

    public List<IndexSearcher> indexSearcherList() {
        return this.indexSearcherList;
    }

    public void indexSearcherList(List<IndexSearcher> indexSearcherList) {
        this.indexSearcherList = indexSearcherList;
    }

    public long id() {
        return this.id;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public void queryResult(QuerySearchResult queryResult) {
        this.queryResult = queryResult;
    }

    public Integer offset() {
        return this.offset;
    }

    public void offset(Integer offset) {
        if (offset == null) {
            offset = 0;
        }
        this.offset = offset;
    }

    public Integer indexCount() {
        return this.indexCount;
    }

    public void indexCount(Integer indexCount) {
        this.indexCount = indexCount;
    }

    public boolean useMultiReader() {
        return this.useMultiReader;
    }

    public void useMultiReader(boolean useMultiReader) {
        this.useMultiReader = useMultiReader;
    }

    public Integer size() {
        return this.size;
    }

    public void size(Integer size) {
        if (size == null) {
            size = 10;
        }
        this.size = size;
    }

    public Query query() {
        return this.query;
    }

    public void query(Query query) {
        this.query = query;
    }

    public Sort sortBy() {
        return this.sortBy;
    }

    public void sortBy(Sort sortBy) {
        this.sortBy = sortBy;
    }

    public List<String> selectFields() {
        return this.selectFields;
    }

    public void selectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    public Integer businessHour() {
        return this.businessHour;
    }

    public void businessHour(Integer businessHour) {
        this.businessHour = businessHour;
    }

    public Integer businessHourFrom() {
        return this.businessHourFrom;
    }

    public void businessHourFrom(Integer businessHourFrom) {
        this.businessHourFrom = businessHourFrom;
    }

    public Integer businessHourTo() {
        return this.businessHourTo;
    }

    public void businessHourTo(Integer businessHourTo) {
        this.businessHourTo = businessHourTo;
    }

    public List<Integer> businessDays() {
        return this.businessDays;
    }

    public void businessDays(List<Integer> businessDays) {
        this.businessDays = businessDays;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    public void timeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public String timeField() {
        return this.timeField;
    }

    public void timeField(String timeField) {
        this.timeField = timeField;
    }

    public Collector queryCollector() {
        return this.queryCollector;
    }

    public void queryCollector(Collector queryCollector) {
        this.queryCollector = queryCollector;
    }

    public long keepAlive() {
        return this.keepAlive;
    }

    public void keepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void lastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Aggregation aggregations() {
        return this.aggregations;
    }

    public void aggregations(Aggregation aggregations) {
        this.aggregations = aggregations;
    }

    public long originNanoTime() {
        return this.originNanoTime;
    }

    public ScoreDoc searchAfterScoreDoc() {
        return this.searchAfterScoreDoc;
    }

    public void searchAfterScoreDoc(ScoreDoc searchAfterScoreDoc) {
        this.searchAfterScoreDoc = searchAfterScoreDoc;
    }

    public class Aggregation {
        private Aggregator aggregator = null;
        private AggregationType aggregationType = AggregationType.NONE;
        private AggregationSortOrder sortOrder = AggregationSortOrder.COUNT_DESC;
        private Integer offset = 0;
        private Integer size = 10;

        public AggregationType aggregationType() {
            return this.aggregationType;
        }

        public void aggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
        }

        public Aggregator aggregator() {
            return this.aggregator;
        }

        public void aggregator(Aggregator aggregator) {
            this.aggregator = aggregator;
        }

        public AggregationSortOrder sortOrder() {
            return this.sortOrder;
        }

        public void sortOrder(AggregationSortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        public Integer offset() {
            return this.offset;
        }

        public void offset(Integer offset) {
            if (offset == null) {
                offset = 0;
            }
            this.offset = offset;
        }

        public Integer size() {
            return this.size;
        }

        public void size(Integer size) {
            if (size == null) {
                size = 10;
            }
            this.size = size;
        }
    }
}

