/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportRequest;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchRequest {
    private final long requestId;
    private final String actionType;
    private String query = null;
    private Long rangeFrom = null;
    private Long rangeTo = null;
    private Integer offset = null;
    private Integer size = null;
    private List<String> sortFields = null;
    private List<String> sortOrders = null;
    private List<DRBlock> refDRBlocks = null;
    private List<String> selectFields = null;
    private String searchAfter = null;
    private Integer businessHour = null;
    private Integer businessHourFrom = null;
    private Integer businessHourTo = null;
    private List<Integer> businessDays = null;
    private String timeZoneId = null;
    private List<DataRepository> dataRepositories = null;
    private Aggregation aggregation = new Aggregation();
    private Integer maxBooleanClauseCount = null;

    private SearchRequest(long requestId, String actionType) {
        this.requestId = requestId;
        this.actionType = actionType;
    }

    public static SearchRequest build(TransportRequest request) throws Exception {
        JSONObject jAggr;
        int businessHour;
        SearchRequest searchRequest = new SearchRequest(request.requestId(), request.actionType());
        if (!request.has("query") || !request.has("dr_name_list")) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters(query|dr_name_list)");
        }
        searchRequest.query(request.getString("query"));
        searchRequest.maxBooleanClauseCount(request.optInt("max_boolean_clause_count"));
        if (request.has("range_from") && request.has("range_to")) {
            searchRequest.rangeFrom(request.getLong("range_from"));
            searchRequest.rangeTo(request.getLong("range_to"));
        }
        JSONArray jDrInstanceList = request.getJSONArray("dr_name_list");
        int instanceCount = jDrInstanceList.length();
        ArrayList<DRBlock> refDRBlockList = new ArrayList<DRBlock>();
        ArrayList<DataRepository> drList = new ArrayList<DataRepository>();
        if (request.has("dr_block_name_list") && request.getJSONArray("dr_block_name_list").length() > 0) {
            JSONArray jDrBlockInstanceList = request.getJSONArray("dr_block_name_list");
            for (int i = 0; i < instanceCount; ++i) {
                DataRepository dataRepository = DataRepositoryManager.getDataRepository(jDrInstanceList.getString(i));
                refDRBlockList.addAll(dataRepository.getBlocksFromList(jDrBlockInstanceList));
                drList.add(dataRepository);
            }
        } else {
            for (int i = 0; i < instanceCount; ++i) {
                DataRepository dataRepository = DataRepositoryManager.getDataRepository(jDrInstanceList.getString(i));
                refDRBlockList.addAll(dataRepository.getBlocksInRange(searchRequest.rangeFrom(), searchRequest.rangeTo()));
                drList.add(dataRepository);
            }
        }
        searchRequest.refDRBlocks(refDRBlockList);
        searchRequest.dataRepositories(drList);
        if (request.has("select_fields")) {
            JSONArray jSelectFieldList = request.getJSONArray("select_fields");
            ArrayList<String> selectFieldList = new ArrayList<String>();
            for (int i = 0; i < jSelectFieldList.length(); ++i) {
                selectFieldList.add(jSelectFieldList.getString(i));
            }
            searchRequest.selectFields(SearchRequest.convertAliasToActualColName(selectFieldList, searchRequest.dataRepositories()));
        } else {
            DataRepository repo = (DataRepository)drList.get(0);
            searchRequest.selectFields(SearchRequest.convertAliasToActualColName(repo.schema().getIndexFieldNames(), searchRequest.dataRepositories()));
        }
        if (request.has("time_zone_id")) {
            searchRequest.timeZoneId(request.getString("time_zone_id"));
        }
        if (request.has("business_hour") && ((businessHour = request.getInt("business_hour")) == 1 || businessHour == 2)) {
            searchRequest.businessHour(businessHour);
            searchRequest.businessHourFrom(request.getInt("business_hour_from"));
            searchRequest.businessHourTo(request.getInt("business_hour_to"));
            JSONArray jDayList = request.getJSONArray("business_days");
            ArrayList<Integer> dayList = new ArrayList<Integer>();
            for (int i = 0; i < jDayList.length(); ++i) {
                dayList.add(jDayList.getInt(i));
            }
            searchRequest.businessDays(dayList);
        }
        if (request.has("offset") && request.has("size")) {
            searchRequest.offset(request.getInt("offset"));
            searchRequest.size(request.getInt("size"));
        }
        if (request.has("sort_fields")) {
            JSONArray jSortColList = request.getJSONArray("sort_fields");
            ArrayList<String> sortColList = new ArrayList<String>();
            for (int i = 0; i < jSortColList.length(); ++i) {
                sortColList.add(jSortColList.getString(i));
            }
            JSONArray jSortOrderList = request.getJSONArray("sort_orders");
            ArrayList<String> sortOrderList = new ArrayList<String>();
            for (int i = 0; i < jSortOrderList.length(); ++i) {
                sortOrderList.add(jSortOrderList.getString(i));
            }
            searchRequest.sortFields(SearchRequest.convertAliasToActualColName(sortColList, searchRequest.dataRepositories()));
            searchRequest.sortOrders(sortOrderList);
        }
        if (request.has("search_after")) {
            searchRequest.searchAfter(request.getString("search_after"));
        }
        if (request.has("aggr") && (jAggr = request.getJSONObject("aggr")).length() > 0) {
            String aggrKey = (String)jAggr.keys().next();
            if (aggrKey.equals("min")) {
                SearchRequest.buildMinAggregation(searchRequest, jAggr);
            } else if (aggrKey.equals("max")) {
                SearchRequest.buildMaxAggregation(searchRequest, jAggr);
            } else if (aggrKey.equals("sum")) {
                SearchRequest.buildSumAggregation(searchRequest, jAggr);
            } else if (aggrKey.equals("avg")) {
                SearchRequest.buildAvgAggregation(searchRequest, jAggr);
            } else if (aggrKey.equals("stats")) {
                SearchRequest.buildStatsAggregation(searchRequest, jAggr);
            } else if (aggrKey.equals("date_histogram")) {
                SearchRequest.buildDateHistogramAggregation(searchRequest, jAggr);
            } else if (aggrKey.equals("terms_count")) {
                SearchRequest.buildTermsAggregation(searchRequest, jAggr, "terms_count");
            } else if (aggrKey.equals("terms_stats")) {
                SearchRequest.buildTermsAggregation(searchRequest, jAggr, "terms_stats");
            } else if (aggrKey.equals("terms_date_histogram")) {
                SearchRequest.buildTermsAggregation(searchRequest, jAggr, "terms_date_histogram");
            } else if (aggrKey.equals("terms_summary")) {
                SearchRequest.buildTermsAggregation(searchRequest, jAggr, "terms_summary");
            } else if (aggrKey.equals("terms_summary_stats")) {
                SearchRequest.buildTermsAggregation(searchRequest, jAggr, "terms_summary_stats");
            }
        }
        return searchRequest;
    }

    private static void buildMinAggregation(SearchRequest searchRequest, JSONObject jAggr) throws Exception {
        JSONObject jMinAggr = jAggr.getJSONObject("min");
        if (!jMinAggr.has("field")) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(field)");
        }
        searchRequest.aggregation().aggregationType(AggregationType.MIN_AGGREGATION);
        searchRequest.aggregation().fields(SearchRequest.convertAliasToActualColName(jMinAggr.getString("field"), searchRequest.dataRepositories()));
    }

    private static void buildMaxAggregation(SearchRequest searchRequest, JSONObject jAggr) throws Exception {
        JSONObject jMaxAggr = jAggr.getJSONObject("max");
        if (!jMaxAggr.has("field")) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(field)");
        }
        searchRequest.aggregation().aggregationType(AggregationType.MAX_AGGREGATION);
        searchRequest.aggregation().fields(SearchRequest.convertAliasToActualColName(jMaxAggr.getString("field"), searchRequest.dataRepositories()));
    }

    private static void buildSumAggregation(SearchRequest searchRequest, JSONObject jAggr) throws Exception {
        JSONObject jSumAggr = jAggr.getJSONObject("sum");
        if (!jSumAggr.has("field")) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(field)");
        }
        searchRequest.aggregation().aggregationType(AggregationType.SUM_AGGREGATION);
        searchRequest.aggregation().fields(SearchRequest.convertAliasToActualColName(jSumAggr.getString("field"), searchRequest.dataRepositories()));
    }

    private static void buildAvgAggregation(SearchRequest searchRequest, JSONObject jAggr) throws Exception {
        JSONObject jAvgAggr = jAggr.getJSONObject("avg");
        if (!jAvgAggr.has("field")) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(field)");
        }
        searchRequest.aggregation().aggregationType(AggregationType.AVG_AGGREGATION);
        searchRequest.aggregation().fields(SearchRequest.convertAliasToActualColName(jAvgAggr.getString("field"), searchRequest.dataRepositories()));
    }

    private static void buildStatsAggregation(SearchRequest searchRequest, JSONObject jAggr) throws Exception {
        int statsFieldsLen;
        JSONObject jStatsAggr = jAggr.getJSONObject("stats");
        if (!jStatsAggr.has("stats_fields")) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(stats_fields)");
        }
        searchRequest.aggregation().aggregationType(AggregationType.STATS_AGGREGATION);
        ArrayList<String> statsFieldsList = new ArrayList<String>();
        ArrayList<String> statsTypesStrList = new ArrayList<String>();
        ArrayList<StatsType> statsTypesList = new ArrayList<StatsType>();
        ArrayList<DRFieldDataType> statsFieldsDataType = new ArrayList<DRFieldDataType>();
        if (jStatsAggr.has("stats_fields")) {
            JSONArray jstatsFields = jStatsAggr.getJSONArray("stats_fields");
            statsFieldsLen = jstatsFields.length();
            for (int i = 0; i < statsFieldsLen; ++i) {
                statsFieldsList.add(jstatsFields.getString(i));
            }
            JSONArray jstatsTypes = jStatsAggr.getJSONArray("stats_types");
            for (int i = 0; i < statsFieldsLen; ++i) {
                statsTypesStrList.add(jstatsTypes.getString(i));
            }
        } else {
            statsFieldsLen = 1;
            statsFieldsList.add(jStatsAggr.getString("stats_field"));
            statsTypesStrList.add(jStatsAggr.getString("stats_type"));
        }
        searchRequest.aggregation().statsFieldArr(SearchRequest.convertAliasToActualColName(statsFieldsList, searchRequest.dataRepositories()));
        for (int i = 0; i < statsFieldsLen; ++i) {
            if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("MIN")) {
                statsTypesList.add(StatsType.MIN);
            } else if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("MAX")) {
                statsTypesList.add(StatsType.MAX);
            } else if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("SUM")) {
                statsTypesList.add(StatsType.SUM);
            } else if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("AVG")) {
                statsTypesList.add(StatsType.AVG);
            }
            statsFieldsDataType.add(DataRepositoryManager.getFieldType((String)searchRequest.aggregation().statsFieldArr.get(i), searchRequest.dataRepositories()));
        }
        searchRequest.aggregation().statsFieldsDataType(statsFieldsDataType);
        searchRequest.aggregation().statsTypeArr(statsTypesList);
    }

    private static void buildDateHistogramAggregation(SearchRequest searchRequest, JSONObject jAggr) throws Exception {
        JSONObject jDateAggr = jAggr.getJSONObject("date_histogram");
        if (!jDateAggr.has("time_interval")) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(time_interval)");
        }
        searchRequest.aggregation().aggregationType(AggregationType.DATE_HISTOGRAM_AGGREGATION);
        searchRequest.aggregation().timeInterval(jDateAggr.getString("time_interval"));
        if (jDateAggr.has("time_field")) {
            searchRequest.aggregation().timeField(SearchRequest.convertAliasToActualColName(jDateAggr.getString("time_field"), searchRequest.dataRepositories()));
        }
    }

    private static void buildTermsAggregation(SearchRequest searchRequest, JSONObject jAggr, String termKey) throws Exception {
        JSONObject jTermsAggr = jAggr.getJSONObject(termKey);
        if (!jTermsAggr.has("fields") && jTermsAggr.getJSONArray("fields").length() > 0) {
            throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(fields)");
        }
        JSONArray jFields = jTermsAggr.getJSONArray("fields");
        int fieldsLen = jFields.length();
        DRFieldDataType firstFieldDataType = DataRepositoryManager.getFieldType(jFields.getString(0), searchRequest.dataRepositories());
        if (firstFieldDataType == null) {
            throw new Exception("Meta info for field '" + jFields.getString(0) + "' not found!");
        }
        boolean isFirstFieldNumeric = firstFieldDataType.isNumeric();
        boolean hasFirstFieldFloatingPoint = firstFieldDataType.hasFloatingPoint();
        boolean isFirstPrimeFieldNumeric = false;
        boolean hasFirstPrimesFieldFloatingPoint = false;
        ArrayList<String> fieldsList = new ArrayList<String>();
        for (int i = 0; i < fieldsLen; ++i) {
            fieldsList.add(jFields.getString(i));
        }
        searchRequest.aggregation().fields(SearchRequest.convertAliasToActualColName(fieldsList, searchRequest.dataRepositories()));
        if (jTermsAggr.has("prime_fields")) {
            JSONArray jPrimeFields = jTermsAggr.getJSONArray("prime_fields");
            ArrayList<String> primFieldsList = new ArrayList<String>();
            int primFieldsLen = jPrimeFields.length();
            for (int i = 0; i < primFieldsLen; ++i) {
                primFieldsList.add(jPrimeFields.getString(i));
            }
            if (primFieldsLen > 0) {
                searchRequest.aggregation().primFields(SearchRequest.convertAliasToActualColName(primFieldsList, searchRequest.dataRepositories()));
                DRFieldDataType firstPrimeFieldDataType = DataRepositoryManager.getFieldType(jPrimeFields.getString(0), searchRequest.dataRepositories());
                isFirstPrimeFieldNumeric = firstPrimeFieldDataType.isNumeric();
                hasFirstPrimesFieldFloatingPoint = firstFieldDataType.hasFloatingPoint();
            }
        }
        if (jTermsAggr.has("sort_field") && jTermsAggr.has("sort_order")) {
            String sortField = jTermsAggr.getString("sort_field");
            String sortOrder = jTermsAggr.getString("sort_order");
            if (sortField.equals("_count")) {
                if (sortOrder.equalsIgnoreCase("asc")) {
                    searchRequest.aggregation().sortOrder(AggregationSortOrder.COUNT_ASC);
                } else {
                    searchRequest.aggregation().sortOrder(AggregationSortOrder.COUNT_DESC);
                }
            } else if (sortField.equals("_stat")) {
                if (sortOrder.equalsIgnoreCase("asc")) {
                    searchRequest.aggregation().sortOrder(AggregationSortOrder.STATS_ASC);
                } else {
                    searchRequest.aggregation().sortOrder(AggregationSortOrder.STATS_DESC);
                }
            } else if (sortOrder.equalsIgnoreCase("asc")) {
                searchRequest.aggregation().sortOrder(AggregationSortOrder.TERM_ASC);
            } else {
                searchRequest.aggregation().sortOrder(AggregationSortOrder.TERM_DESC);
            }
        }
        if (jTermsAggr.has("offset")) {
            searchRequest.aggregation().offset(jTermsAggr.getInt("offset"));
        }
        if (jTermsAggr.has("size")) {
            searchRequest.aggregation().size(jTermsAggr.getInt("size"));
        }
        if (jTermsAggr.has("filter_bucket_count")) {
            searchRequest.aggregation().filterBucketCount(jTermsAggr.getInt("filter_bucket_count"));
        }
        if (jTermsAggr.has("filter_min_bucket_count")) {
            searchRequest.aggregation().filterMinBucketCount(jTermsAggr.getInt("filter_min_bucket_count"));
        }
        if (jTermsAggr.has("filter_max_bucket_count")) {
            searchRequest.aggregation().filterMaxBucketCount(jTermsAggr.getInt("filter_max_bucket_count"));
        }
        if (jTermsAggr.has("filter_doc_count")) {
            searchRequest.aggregation().filterDocCount(jTermsAggr.getInt("filter_doc_count"));
        }
        if (jTermsAggr.has("filter_min_doc_count")) {
            searchRequest.aggregation().filterMinDocCount(jTermsAggr.getInt("filter_min_doc_count"));
        }
        if (jTermsAggr.has("filter_max_doc_count")) {
            searchRequest.aggregation().filterMaxDocCount(jTermsAggr.getInt("filter_max_doc_count"));
        }
        if (termKey.equalsIgnoreCase("terms_count")) {
            if (fieldsLen > 1) {
                searchRequest.aggregation().aggregationType(AggregationType.MULTI_STRING_TERMS_AGGREGATION);
            } else if (isFirstFieldNumeric && hasFirstFieldFloatingPoint) {
                searchRequest.aggregation().aggregationType(AggregationType.DOUBLE_TERMS_AGGREGATION);
            } else if (isFirstFieldNumeric) {
                searchRequest.aggregation().aggregationType(AggregationType.LONG_TERMS_AGGREGATION);
            } else {
                searchRequest.aggregation().aggregationType(AggregationType.STRING_TERMS_AGGREGATION);
            }
        } else if (termKey.equalsIgnoreCase("terms_stats")) {
            int statsFieldsLen;
            if (!(jTermsAggr.has("stats_field") && jTermsAggr.has("stats_type") || jTermsAggr.has("stats_fields") && jTermsAggr.has("stats_types"))) {
                throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(stats_field|stats_type)");
            }
            ArrayList<String> statsFieldsList = new ArrayList<String>();
            ArrayList<String> statsTypesStrList = new ArrayList<String>();
            ArrayList<StatsType> statsTypesList = new ArrayList<StatsType>();
            ArrayList<DRFieldDataType> statsFieldsDataType = new ArrayList<DRFieldDataType>();
            if (jTermsAggr.has("stats_fields")) {
                JSONArray jstatsFields = jTermsAggr.getJSONArray("stats_fields");
                statsFieldsLen = jstatsFields.length();
                for (int i = 0; i < statsFieldsLen; ++i) {
                    statsFieldsList.add(jstatsFields.getString(i));
                }
                JSONArray jstatsTypes = jTermsAggr.getJSONArray("stats_types");
                for (int i = 0; i < statsFieldsLen; ++i) {
                    statsTypesStrList.add(jstatsTypes.getString(i));
                }
            } else {
                statsFieldsLen = 1;
                statsFieldsList.add(jTermsAggr.getString("stats_field"));
                statsTypesStrList.add(jTermsAggr.getString("stats_type"));
            }
            searchRequest.aggregation().statsFieldArr(SearchRequest.convertAliasToActualColName(statsFieldsList, searchRequest.dataRepositories()));
            for (int i = 0; i < statsFieldsLen; ++i) {
                if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("MIN")) {
                    statsTypesList.add(StatsType.MIN);
                } else if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("MAX")) {
                    statsTypesList.add(StatsType.MAX);
                } else if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("SUM")) {
                    statsTypesList.add(StatsType.SUM);
                } else if (((String)statsTypesStrList.get(i)).equalsIgnoreCase("AVG")) {
                    statsTypesList.add(StatsType.AVG);
                }
                statsFieldsDataType.add(DataRepositoryManager.getFieldType((String)searchRequest.aggregation().statsFieldArr.get(i), searchRequest.dataRepositories()));
            }
            searchRequest.aggregation().statsFieldsDataType(statsFieldsDataType);
            searchRequest.aggregation().statsTypeArr(statsTypesList);
            if (fieldsLen > 1) {
                searchRequest.aggregation().aggregationType(AggregationType.MULTI_STRING_TERMS_STATS_AGGREGATION);
            } else if (isFirstFieldNumeric && hasFirstFieldFloatingPoint) {
                searchRequest.aggregation().aggregationType(AggregationType.DOUBLE_TERMS_STATS_AGGREGATION);
            } else if (isFirstFieldNumeric) {
                searchRequest.aggregation().aggregationType(AggregationType.LONG_TERMS_STATS_AGGREGATION);
            } else {
                searchRequest.aggregation().aggregationType(AggregationType.STRING_TERMS_STATS_AGGREGATION);
            }
        } else if (termKey.equalsIgnoreCase("terms_date_histogram")) {
            if (!jTermsAggr.has("time_interval")) {
                throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(time_interval)");
            }
            searchRequest.aggregation().timeInterval(jTermsAggr.getString("time_interval"));
            if (jTermsAggr.has("time_field")) {
                searchRequest.aggregation().timeField(SearchRequest.convertAliasToActualColName(jTermsAggr.getString("time_field"), searchRequest.dataRepositories()));
            }
            if (fieldsLen > 1) {
                searchRequest.aggregation().aggregationType(AggregationType.MULTI_STRING_TERMS_DATE_HISTOGRAM_AGGREGATION);
            } else if (isFirstFieldNumeric && hasFirstFieldFloatingPoint) {
                searchRequest.aggregation().aggregationType(AggregationType.DOUBLE_TERMS_DATE_HISTOGRAM_AGGREGATION);
            } else if (isFirstFieldNumeric) {
                searchRequest.aggregation().aggregationType(AggregationType.LONG_TERMS_DATE_HISTOGRAM_AGGREGATION);
            } else {
                searchRequest.aggregation().aggregationType(AggregationType.STRING_TERMS_DATE_HISTOGRAM_AGGREGATION);
            }
        } else if (termKey.equalsIgnoreCase("terms_summary")) {
            if (searchRequest.aggregation().primFields().size() > 1) {
                searchRequest.aggregation().aggregationType(AggregationType.MULTI_STRING_TERMS_SUMMARY_AGGREGATION);
            } else if (isFirstPrimeFieldNumeric && hasFirstPrimesFieldFloatingPoint) {
                searchRequest.aggregation().aggregationType(AggregationType.DOUBLE_TERMS_SUMMARY_AGGREGATION);
            } else if (isFirstPrimeFieldNumeric) {
                searchRequest.aggregation().aggregationType(AggregationType.LONG_TERMS_SUMMARY_AGGREGATION);
            } else {
                searchRequest.aggregation().aggregationType(AggregationType.STRING_TERMS_SUMMARY_AGGREGATION);
            }
        } else if (termKey.equalsIgnoreCase("terms_summary_stats")) {
            if (!(jTermsAggr.has("stats_field") && jTermsAggr.has("stats_type") || jTermsAggr.has("stats_fields") && jTermsAggr.has("stats_types"))) {
                throw new Exception("Error while processing search-request, missing some mandatory request parameters for aggregation(stats_field|stats_type)");
            }
            if (jTermsAggr.has("stats_fields")) {
                JSONArray jstatsFields = jTermsAggr.getJSONArray("stats_fields");
                ArrayList<String> statsFieldsList = new ArrayList<String>();
                ArrayList<StatsType> statsTypeList = new ArrayList<StatsType>();
                int statsFieldsLen = jstatsFields.length();
                for (int i = 0; i < statsFieldsLen; ++i) {
                    statsFieldsList.add(jstatsFields.getString(i));
                }
                searchRequest.aggregation().statsFieldArr(SearchRequest.convertAliasToActualColName(statsFieldsList, searchRequest.dataRepositories()));
                jstatsFields = jTermsAggr.getJSONArray("stats_types");
                ArrayList<DRFieldDataType> statsFieldsDataType = new ArrayList<DRFieldDataType>();
                for (int i = 0; i < statsFieldsLen; ++i) {
                    if (jstatsFields.getString(i).equalsIgnoreCase("MIN")) {
                        statsTypeList.add(StatsType.MIN);
                    } else if (jstatsFields.getString(i).equalsIgnoreCase("MAX")) {
                        statsTypeList.add(StatsType.MAX);
                    } else if (jstatsFields.getString(i).equalsIgnoreCase("SUM")) {
                        statsTypeList.add(StatsType.SUM);
                    } else if (jstatsFields.getString(i).equalsIgnoreCase("AVG")) {
                        statsTypeList.add(StatsType.AVG);
                    }
                    statsFieldsDataType.add(DataRepositoryManager.getFieldType((String)searchRequest.aggregation().statsFieldArr.get(i), searchRequest.dataRepositories()));
                }
                searchRequest.aggregation().statsTypeArr(statsTypeList);
                searchRequest.aggregation().statsFieldsDataType(statsFieldsDataType);
            } else {
                searchRequest.aggregation().statsField(SearchRequest.convertAliasToActualColName(jTermsAggr.getString("stats_field"), searchRequest.dataRepositories()));
                searchRequest.aggregation().statsType(jTermsAggr.getString("stats_type"));
                searchRequest.aggregation().statsFieldDataType(DataRepositoryManager.getFieldType(searchRequest.aggregation().statsField(), searchRequest.dataRepositories()));
            }
            searchRequest.aggregation().aggregationType(AggregationType.MULTI_STRING_TERMS_SUMMARY_STATS_AGGREGATION);
        }
    }

    public static String convertAliasToActualColName(String colName, List<DataRepository> drList) {
        DataRepository dataRepo;
        DRIndexField drIndexField = null;
        Iterator<DataRepository> iterator = drList.iterator();
        while (iterator.hasNext() && (drIndexField = (dataRepo = iterator.next()).getIndexField(colName)) == null) {
        }
        if (drIndexField == null) {
            throw new NoSuchElementException("IndexField for " + colName + " not found!");
        }
        return drIndexField.getFieldName();
    }

    public static ArrayList<String> convertAliasToActualColName(List<String> colList, List<DataRepository> drList) {
        ArrayList<String> newCols = new ArrayList<String>();
        for (String colName : colList) {
            try {
                newCols.add(SearchRequest.convertAliasToActualColName(colName, drList));
            }
            catch (Exception e) {
                newCols.add(colName);
                e.printStackTrace();
            }
        }
        return newCols;
    }

    public static JSONArray convertAliasToActualColName(JSONArray colList, List<DataRepository> drList) throws Exception {
        JSONArray newCols = new JSONArray();
        String colName = null;
        for (int i = 0; i < colList.length(); ++i) {
            try {
                colName = colList.getString(i);
                newCols.put((Object)SearchRequest.convertAliasToActualColName(colName, drList));
                continue;
            }
            catch (Exception e) {
                newCols.put((Object)colName);
                e.printStackTrace();
            }
        }
        return newCols;
    }

    public long requestId() {
        return this.requestId;
    }

    public String actionType() {
        return this.actionType;
    }

    public Long rangeFrom() {
        return this.rangeFrom;
    }

    private void rangeFrom(Long rangeFrom) {
        this.rangeFrom = rangeFrom;
    }

    public Long rangeTo() {
        return this.rangeTo;
    }

    private void rangeTo(Long rangeTo) {
        this.rangeTo = rangeTo;
    }

    public Integer offset() {
        return this.offset;
    }

    private void offset(Integer offset) {
        this.offset = offset;
    }

    public Integer size() {
        return this.size;
    }

    private void size(Integer size) {
        this.size = size;
    }

    public String query() {
        return this.query;
    }

    private void query(String query) {
        this.query = query;
    }

    public List<String> sortFields() {
        return this.sortFields;
    }

    private void sortFields(List<String> sortFields) {
        this.sortFields = sortFields;
    }

    public List<String> sortOrders() {
        return this.sortOrders;
    }

    private void sortOrders(List<String> sortOrders) {
        this.sortOrders = sortOrders;
    }

    public List<String> selectFields() {
        return this.selectFields;
    }

    private void selectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    public List<DRBlock> refDRBlocks() {
        return this.refDRBlocks;
    }

    private void refDRBlocks(DRBlock ... refDRBlockList) {
        this.refDRBlocks = Arrays.asList(refDRBlockList);
    }

    private void refDRBlocks(List<DRBlock> refDRBlockList) {
        this.refDRBlocks = refDRBlockList;
    }

    public List<DataRepository> dataRepositories() {
        return this.dataRepositories;
    }

    private void dataRepositories(List<DataRepository> dataRepositories) {
        this.dataRepositories = dataRepositories;
    }

    public Aggregation aggregation() {
        return this.aggregation;
    }

    private void aggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
    }

    public String searchAfter() {
        return this.searchAfter;
    }

    private void searchAfter(String searchAfter) {
        this.searchAfter = searchAfter;
    }

    public Integer businessHour() {
        return this.businessHour;
    }

    private void businessHour(Integer businessHour) {
        this.businessHour = businessHour;
    }

    public Integer businessHourFrom() {
        return this.businessHourFrom;
    }

    private void businessHourFrom(Integer businessHourFrom) {
        this.businessHourFrom = businessHourFrom;
    }

    public Integer businessHourTo() {
        return this.businessHourTo;
    }

    private void businessHourTo(Integer businessHourTo) {
        this.businessHourTo = businessHourTo;
    }

    public List<Integer> businessDays() {
        return this.businessDays;
    }

    private void businessDays(List<Integer> businessDays) {
        this.businessDays = businessDays;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    private void timeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public void maxBooleanClauseCount(Integer maxBooleanClauseCount) {
        this.maxBooleanClauseCount = maxBooleanClauseCount;
    }

    public Integer maxBooleanClauseCount() {
        return this.maxBooleanClauseCount;
    }

    public class Aggregation {
        private AggregationType aggregationType = AggregationType.NONE;
        private List<String> fields;
        private List<String> primFields;
        private AggregationSortOrder sortOrder = AggregationSortOrder.COUNT_DESC;
        private String statsField = null;
        private List<String> statsFieldArr = null;
        private DRFieldDataType statsFieldDataType = null;
        private List<DRFieldDataType> statsFieldsDataType = null;
        private String timeField = null;
        private String statsType = null;
        private List<StatsType> statsTypeArr = null;
        private String timeInterval;
        private Integer offset = 0;
        private Integer size = 10;
        private Integer filterBucketCount = null;
        private Integer filterMaxBucketCount = null;
        private Integer filterMinBucketCount = null;
        private Integer filterDocCount = null;
        private Integer filterMaxDocCount = null;
        private Integer filterMinDocCount = null;

        public AggregationType aggregationType() {
            return this.aggregationType;
        }

        public void aggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
        }

        public List<String> fields() {
            return this.fields;
        }

        public void fields(String ... fields) {
            this.fields = Arrays.asList(fields);
        }

        public void fields(List<String> fields) {
            this.fields = fields;
        }

        public List<String> primFields() {
            return this.primFields;
        }

        public void primFields(List<String> primFields) {
            this.primFields = primFields;
        }

        public String statsField() {
            return this.statsField;
        }

        public void statsField(String statsField) {
            this.statsField = statsField;
        }

        public void statsFieldArr(List<String> statsFieldArr) {
            this.statsFieldArr = statsFieldArr;
        }

        public List<String> statsFieldArr() {
            return this.statsFieldArr;
        }

        public void statsTypeArr(List<StatsType> statsTypeArr) {
            this.statsTypeArr = statsTypeArr;
        }

        public List<StatsType> statsTypeArr() {
            return this.statsTypeArr;
        }

        public DRFieldDataType statsFieldDataType() {
            return this.statsFieldDataType;
        }

        public void statsFieldDataType(DRFieldDataType statsFieldDataType) {
            this.statsFieldDataType = statsFieldDataType;
        }

        public List<DRFieldDataType> statsFieldsDataType() {
            return this.statsFieldsDataType;
        }

        public void statsFieldsDataType(ArrayList<DRFieldDataType> statsFieldsDataType) {
            this.statsFieldsDataType = statsFieldsDataType;
        }

        public String timeField() {
            return this.timeField;
        }

        public void timeField(String timeField) {
            this.timeField = timeField;
        }

        public String statsType() {
            return this.statsType;
        }

        public void statsType(String statsType) {
            this.statsType = statsType;
        }

        public String timeInterval() {
            return this.timeInterval;
        }

        public void timeInterval(String timeInterval) {
            this.timeInterval = timeInterval;
        }

        public AggregationSortOrder sortOrder() {
            return this.sortOrder;
        }

        public void sortOrder(AggregationSortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        public Integer offset() {
            return this.offset;
        }

        public void offset(Integer offset) {
            if (offset == null) {
                offset = 0;
            }
            this.offset = offset;
        }

        public Integer size() {
            return this.size;
        }

        public void size(Integer size) {
            if (size == null) {
                size = 10;
            }
            this.size = size;
        }

        public Integer filterBucketCount() {
            return this.filterBucketCount;
        }

        public void filterBucketCount(Integer filterBucketCount) {
            this.filterBucketCount = filterBucketCount;
        }

        public Integer filterMinBucketCount() {
            return this.filterMinBucketCount;
        }

        public void filterMinBucketCount(Integer filterMinBucketCount) {
            this.filterMinBucketCount = filterMinBucketCount;
        }

        public Integer filterMaxBucketCount() {
            return this.filterMaxBucketCount;
        }

        public void filterMaxBucketCount(Integer filterMaxBucketCount) {
            this.filterMaxBucketCount = filterMaxBucketCount;
        }

        public Integer filterDocCount() {
            return this.filterDocCount;
        }

        public void filterDocCount(Integer filterDocCount) {
            this.filterDocCount = filterDocCount;
        }

        public Integer filterMinDocCount() {
            return this.filterMinDocCount;
        }

        public void filterMinDocCount(Integer filterMinDocCount) {
            this.filterMinDocCount = filterMinDocCount;
        }

        public Integer filterMaxDocCount() {
            return this.filterMaxDocCount;
        }

        public void filterMaxDocCount(Integer filterMaxDocCount) {
            this.filterMaxDocCount = filterMaxDocCount;
        }
    }
}

