/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.file.GzipUtil;
import com.manageengine.dataengine.commons.utils.DateTimeUnit;
import com.manageengine.dataengine.xnode.bootstrap.XNodeManager;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportResponse;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DRQueryParser;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.datarepository.LuceneIndexHandler;
import com.manageengine.dataengine.xnode.datarepository.search.QueryPhase;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.SearchPhase;
import com.manageengine.dataengine.xnode.datarepository.search.SearchRequest;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram.DateHistogramAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.DoubleTermsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.DoubleTermsHistogramAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.DoubleTermsStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.DoubleTermsSummaryAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.GlobalOrdinalsStringTermsDHAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.GlobalOrdinalsStringTermsStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.GlobalOrdinalsStringTermsSummaryAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTermsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTermsHistogramAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTermsStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTermsSummaryAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.MultiStringTermsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.MultiStringTermsDHAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.MultiStringTermsStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.MultiStringTermsSummaryAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.MultiStringTermsSummaryStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.SortedDVOrdinalsFieldData;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics.AvgAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics.MaxAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics.MinAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics.StatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics.SumAggregator;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.BytesRef;
import org.joda.time.DateTimeZone;
import org.json.JSONObject;

public class SearchService {
    private SearchPhase searchPhase;
    public static final String TIME_FIELD = "TIME_GENERATED";
    public static final int MAX_MULTIREADER_DOC_COUNT = 2000000000;
    private static final int DEFAULT_MAX_BOOLEAN_CLAUSE_COUNT = BooleanQuery.getMaxClauseCount();
    private static final Logger LOGGER = LogManager.getLogger((String)"ActionTrace");
    private static final Logger XNODE_LOGGER = LogManager.getLogger((String)"Xnode");

    public TransportResponse executeSearch(SearchRequest searchRequest) throws Exception {
        SearchContext searchContext = null;
        try {
            if (searchRequest.maxBooleanClauseCount() != 0) {
                BooleanQuery.setMaxClauseCount((int)searchRequest.maxBooleanClauseCount());
            }
            searchContext = SearchContext.build(searchRequest);
            this.buildSearchContext(searchContext, searchRequest);
            this.searchPhase = new QueryPhase();
            this.searchPhase.execute(searchContext);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (searchRequest.maxBooleanClauseCount() != 0) {
                BooleanQuery.setMaxClauseCount((int)DEFAULT_MAX_BOOLEAN_CLAUSE_COUNT);
            }
            if (searchContext != null && searchContext.indexSearcherList() != null) {
                LuceneIndexHandler.releaseIndexSearcher(null, searchRequest.refDRBlocks());
                searchContext.indexSearcherList(null);
            }
        }
        return searchContext.queryResult();
    }

    private void buildSearchContext(SearchContext searchContext, SearchRequest searchRequest) throws Exception {
        DRQueryParser parser = new DRQueryParser(null, DataRepositoryManager.getAnalyzerWrapper(searchRequest.dataRepositories()), searchRequest.dataRepositories());
        Query searchQuery = parser.parse(searchRequest.query());
        LOGGER.info("Search Query : " + searchQuery);
        searchContext.query(searchQuery);
        searchContext.selectFields(searchRequest.selectFields());
        searchContext.sortBy(this.getSortBy(searchRequest.sortFields(), searchRequest.sortOrders(), searchRequest.dataRepositories()));
        searchContext.offset(searchRequest.offset());
        searchContext.size(searchRequest.size());
        searchContext.indexCount(searchRequest.refDRBlocks().size());
        searchContext.useMultiReader(this.canUseMultiReader(searchRequest.refDRBlocks()));
        searchContext.searchAfterScoreDoc(this.getSearchAfterScoreDoc(searchRequest.searchAfter(), searchRequest.sortFields(), searchRequest.dataRepositories()));
        searchContext.timeZoneId(searchRequest.timeZoneId());
        searchContext.businessHour(searchRequest.businessHour());
        searchContext.businessHourFrom(searchRequest.businessHourFrom());
        searchContext.businessHourTo(searchRequest.businessHourTo());
        searchContext.businessDays(searchRequest.businessDays());
        searchContext.timeField(TIME_FIELD);
        if (searchContext.useMultiReader()) {
            IndexSearcher indexSearcher = LuceneIndexHandler.getIndexSearcher(searchRequest.refDRBlocks());
            if (indexSearcher != null) {
                searchContext.indexSearcherList(Collections.singletonList(indexSearcher));
            }
        } else {
            ArrayList<IndexSearcher> indexSearcherList = new ArrayList<IndexSearcher>();
            for (DRBlock drBlock : searchRequest.refDRBlocks()) {
                indexSearcherList.add(LuceneIndexHandler.getIndexSearcher(drBlock));
            }
            searchContext.indexSearcherList(indexSearcherList);
        }
        SearchRequest.Aggregation aggregationReq = searchRequest.aggregation();
        this.changeAggregateTypeForMergeSearch(searchContext, aggregationReq);
        if (aggregationReq.aggregationType() == AggregationType.MIN_AGGREGATION || aggregationReq.aggregationType() == AggregationType.MAX_AGGREGATION || aggregationReq.aggregationType() == AggregationType.SUM_AGGREGATION || aggregationReq.aggregationType() == AggregationType.AVG_AGGREGATION || aggregationReq.aggregationType() == AggregationType.STATS_AGGREGATION) {
            this.buildStatsAggregationContext(searchContext, aggregationReq);
        } else if (aggregationReq.aggregationType() == AggregationType.DATE_HISTOGRAM_AGGREGATION) {
            this.buildDateHistogramAggregationContext(searchContext, aggregationReq, searchRequest.timeZoneId());
        } else if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.STRING_TERMS_STATS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.LONG_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.LONG_TERMS_STATS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_STATS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_STATS_AGGREGATION) {
            this.buildTermsAggregationContext(searchContext, aggregationReq);
        } else if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_DATE_HISTOGRAM_AGGREGATION || aggregationReq.aggregationType() == AggregationType.LONG_TERMS_DATE_HISTOGRAM_AGGREGATION || aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_DATE_HISTOGRAM_AGGREGATION || aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_DATE_HISTOGRAM_AGGREGATION) {
            this.buildTermsDateHistogramAggregationContext(searchContext, aggregationReq, searchRequest.timeZoneId());
        } else if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_SUMMARY_AGGREGATION || aggregationReq.aggregationType() == AggregationType.LONG_TERMS_SUMMARY_AGGREGATION || aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_SUMMARY_AGGREGATION || aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_SUMMARY_AGGREGATION) {
            this.buildTermsSummaryAggregationContext(searchContext, aggregationReq);
        } else if (aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_SUMMARY_STATS_AGGREGATION) {
            this.buildTermsSummaryStatsAggregationContext(searchContext, aggregationReq);
        }
        searchContext.aggregations().aggregationType(aggregationReq.aggregationType());
    }

    public static JSONObject getMinMaxLongField(String field, DRBlock ... refDRBlockList) throws Exception {
        return SearchService.getMinMaxLongField(field, Arrays.asList(refDRBlockList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getMinMaxLongField(String field, List<DRBlock> refDRBlockList) throws Exception {
        IndexSearcher searcher = null;
        JSONObject jsonResult = new JSONObject();
        Sort sortBy = null;
        TopFieldDocs topDocs = null;
        ScoreDoc[] hits = null;
        jsonResult.put("max", -1);
        jsonResult.put("min", -1);
        try {
            searcher = LuceneIndexHandler.getIndexSearcher(refDRBlockList);
            if (searcher != null) {
                String minVal;
                String maxVal;
                sortBy = new Sort();
                sortBy.setSort((SortField)new SortedNumericSortField(field, SortField.Type.LONG, true));
                topDocs = searcher.search((Query)new MatchAllDocsQuery(), 1, sortBy);
                if (topDocs != null && (hits = topDocs.scoreDocs).length > 0 && (maxVal = searcher.doc(hits[0].doc).get(field)) != null) {
                    jsonResult.put("max", (Object)maxVal);
                }
                sortBy = new Sort();
                sortBy.setSort((SortField)new SortedNumericSortField(field, SortField.Type.LONG, false));
                topDocs = searcher.search((Query)new MatchAllDocsQuery(), 1, sortBy);
                if (topDocs != null && (hits = topDocs.scoreDocs).length > 0 && (minVal = searcher.doc(hits[0].doc).get(field)) != null) {
                    jsonResult.put("min", (Object)minVal);
                }
                if (jsonResult.getLong("max") == -1L || jsonResult.getLong("min") == -1L) {
                    XNODE_LOGGER.warn("MinMax -1 : IndexPath : " + searcher.getIndexReader().toString() + " :: field : " + field + " :: searcher : " + searcher);
                }
            }
        }
        finally {
            if (searcher != null) {
                LuceneIndexHandler.releaseIndexSearcher(searcher, refDRBlockList);
                searcher = null;
            }
        }
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDocCount(DRBlock ... refDRBlockList) throws Exception {
        long totalRecords = 0L;
        IndexSearcher searcher = null;
        try {
            searcher = LuceneIndexHandler.getIndexSearcher(refDRBlockList);
            if (searcher == null) {
                for (DRBlock drBlock : refDRBlockList) {
                    XNODE_LOGGER.warn("Trying to access null index! : IndexPath : " + drBlock.blockPath());
                }
                totalRecords = -1L;
            } else {
                TopDocs topDocs = searcher.search((Query)new MatchAllDocsQuery(), 1);
                if (topDocs != null) {
                    totalRecords = topDocs.totalHits;
                }
            }
        }
        finally {
            if (searcher != null) {
                LuceneIndexHandler.releaseIndexSearcher(searcher, refDRBlockList);
                searcher = null;
            }
        }
        return totalRecords;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getSegmentCount(DRBlock drBlock) throws Exception {
        int totalSegments = 0;
        IndexSearcher searcher = null;
        try {
            searcher = LuceneIndexHandler.getIndexSearcher(drBlock);
            totalSegments = searcher.getIndexReader().leaves().size();
            if (searcher == null) return totalSegments;
        }
        catch (Throwable throwable) {
            if (searcher == null) throw throwable;
            LuceneIndexHandler.releaseIndexSearcher(searcher, drBlock);
            searcher = null;
            throw throwable;
        }
        LuceneIndexHandler.releaseIndexSearcher(searcher, drBlock);
        return totalSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIndexToRawFile(DRBlock drBlock, String destRawFile) throws Exception {
        IndexSearcher indexSearcher;
        block13: {
            long totalRecords = 0L;
            indexSearcher = null;
            GzipUtil.GzipCsvWriteHandle gzipCsvWriteHandle = null;
            File archiveDir = new File(drBlock.dataRepository().currentFrozenBlocksLocation());
            if (!archiveDir.exists()) {
                archiveDir.mkdirs();
            }
            if (new File(destRawFile).exists()) {
                new File(destRawFile).delete();
            }
            try {
                ArrayList<DRIndexField> fieldList = drBlock.dataRepository().getIndexFields();
                gzipCsvWriteHandle = new GzipUtil().getGzipCsvWriteHandle(destRawFile, "UTF-8", '\t');
                indexSearcher = LuceneIndexHandler.getIndexSearcher(drBlock);
                Sort sortBy = new Sort();
                SortedNumericSortField sortField = new SortedNumericSortField(drBlock.dataRepository().schema().getRangeField(), SortField.Type.LONG, false);
                sortBy.setSort((SortField)sortField);
                int batchCount = 10000;
                int batchNo = 1;
                boolean hasMore = true;
                ScoreDoc afterScoreDoc = null;
                while (hasMore) {
                    if (XNodeManager.isShutdownInitialized()) {
                        throw new Exception("Interrupting Operation!!  - ShutDown Request Received");
                    }
                    TopDocs topDocs = indexSearcher.searchAfter(afterScoreDoc, (Query)new MatchAllDocsQuery(), batchCount, sortBy);
                    if (topDocs != null) {
                        ScoreDoc[] scoreHits = topDocs.scoreDocs;
                        totalRecords = topDocs.totalHits;
                        int currentfetchCount = scoreHits.length;
                        for (int i = 0; i < currentfetchCount; ++i) {
                            Document doc = indexSearcher.doc(scoreHits[i].doc);
                            String[] lineData = new String[fieldList.size()];
                            int index = 0;
                            for (DRIndexField indexField : fieldList) {
                                lineData[index++] = doc.get(indexField.getFieldName());
                            }
                            gzipCsvWriteHandle.writeNext(lineData);
                        }
                        afterScoreDoc = scoreHits[scoreHits.length - 1];
                    }
                    if (totalRecords <= (long)(batchNo * batchCount)) {
                        hasMore = false;
                        continue;
                    }
                    ++batchNo;
                }
                if (gzipCsvWriteHandle == null) break block13;
            }
            catch (Throwable throwable) {
                if (gzipCsvWriteHandle != null) {
                    gzipCsvWriteHandle.close();
                }
                if (indexSearcher != null) {
                    LuceneIndexHandler.releaseIndexSearcher(indexSearcher, drBlock);
                    indexSearcher = null;
                }
                throw throwable;
            }
            gzipCsvWriteHandle.close();
        }
        if (indexSearcher != null) {
            LuceneIndexHandler.releaseIndexSearcher(indexSearcher, drBlock);
            indexSearcher = null;
        }
    }

    public static long query(Query query, Sort sortBy, DRBlock ... refDRBlockList) throws Exception {
        long totalRecords = 0L;
        TopDocs topDocs = LuceneIndexHandler.getIndexSearcher(refDRBlockList).search((Query)new MatchAllDocsQuery(), 1);
        if (topDocs != null) {
            totalRecords = topDocs.totalHits;
        }
        return totalRecords;
    }

    private Sort getSortBy(List<String> sortFieldList, List<String> sortOrderList, List<DataRepository> drList) {
        Sort sortBy = null;
        if (sortFieldList != null && sortOrderList != null && sortFieldList.size() > 0) {
            sortBy = new Sort();
            int i = 0;
            SortField[] sortFields = new SortField[sortFieldList.size()];
            for (String sortField : sortFieldList) {
                DRFieldDataType drFieldDataType = DRFieldDataType.get((String)drList.get(0).getIndexField(sortField).getDataType());
                sortFields[i] = drFieldDataType.sortField(sortField, sortOrderList.get(i).equalsIgnoreCase("desc"));
                ++i;
            }
            sortBy.setSort(sortFields);
        }
        return sortBy;
    }

    private ScoreDoc getSearchAfterScoreDoc(String searchAfterStr, List<String> sortFieldList, List<DataRepository> drList) throws ParseException {
        if (searchAfterStr == null || searchAfterStr.isEmpty()) {
            return null;
        }
        ScoreDoc afterScoreDoc = null;
        String[] searchAfterStrArr = searchAfterStr.split(" ");
        int afterScoreDocId = Integer.parseInt(searchAfterStrArr[0].split("=")[1]);
        Float afterScoreValue = Float.valueOf(Float.parseFloat(searchAfterStrArr[1].split("=")[1]));
        int afterScoreShardIndex = Integer.parseInt(searchAfterStrArr[2].split("=")[1]);
        if (sortFieldList != null && sortFieldList.size() > 0) {
            String afterScoreFieldsStr = searchAfterStr.replaceAll(".*fields=", "");
            afterScoreFieldsStr = afterScoreFieldsStr.substring(1, afterScoreFieldsStr.length() - 1);
            String[] afterScoreFieldsStrArr = afterScoreFieldsStr.split(",");
            Object[] afterScoreFieldsArr = new Object[afterScoreFieldsStrArr.length];
            if (sortFieldList.size() != afterScoreFieldsStrArr.length) {
                throw new IllegalStateException("EXCEPTION while parsing AfterScoreDoc! sort fields length and no of values in after score sort fields doesn't match");
            }
            int i = 0;
            for (String sortField : sortFieldList) {
                DRFieldDataType drFieldDataType = DRFieldDataType.get((String)drList.get(0).getIndexField(sortField).getDataType());
                afterScoreFieldsArr[i] = afterScoreFieldsStrArr[i] == null || afterScoreFieldsStrArr[i].trim().equals("null") ? null : (drFieldDataType == DRFieldDataType.KEYWORD || drFieldDataType == DRFieldDataType.TEXT ? this.toBytesRef(afterScoreFieldsStrArr[i].trim()) : (drFieldDataType == DRFieldDataType.INTEGER ? Integer.valueOf(Integer.parseInt(afterScoreFieldsStrArr[i].trim())) : (drFieldDataType == DRFieldDataType.LONG ? Long.valueOf(Long.parseLong(afterScoreFieldsStrArr[i].trim())) : (drFieldDataType == DRFieldDataType.FLOAT ? Float.valueOf(Float.parseFloat(afterScoreFieldsStrArr[i].trim())) : (drFieldDataType == DRFieldDataType.DOUBLE ? Double.valueOf(Double.parseDouble(afterScoreFieldsStrArr[i].trim())) : (drFieldDataType == DRFieldDataType.BOOLEAN ? Boolean.valueOf(Boolean.getBoolean(afterScoreFieldsStrArr[i].trim())) : (drFieldDataType == DRFieldDataType.BYTE ? Byte.valueOf(Byte.parseByte(afterScoreFieldsStrArr[i].trim())) : afterScoreFieldsStrArr[i].trim())))))));
                ++i;
            }
            afterScoreDoc = new FieldDoc(afterScoreDocId, afterScoreValue.floatValue(), afterScoreFieldsArr, afterScoreShardIndex);
        } else {
            afterScoreDoc = new ScoreDoc(afterScoreDocId, afterScoreValue.floatValue(), afterScoreShardIndex);
        }
        return afterScoreDoc;
    }

    private void changeAggregateTypeForMergeSearch(SearchContext searchContext, SearchRequest.Aggregation aggregationReq) {
        AggregationType oldType;
        if (!searchContext.useMultiReader() && (oldType = aggregationReq.aggregationType()) != null && oldType != AggregationType.NONE) {
            if (oldType == AggregationType.STRING_TERMS_AGGREGATION) {
                aggregationReq.aggregationType(AggregationType.MULTI_STRING_TERMS_AGGREGATION);
            } else if (oldType == AggregationType.STRING_TERMS_STATS_AGGREGATION) {
                aggregationReq.aggregationType(AggregationType.MULTI_STRING_TERMS_STATS_AGGREGATION);
            } else if (oldType == AggregationType.STRING_TERMS_DATE_HISTOGRAM_AGGREGATION) {
                aggregationReq.aggregationType(AggregationType.MULTI_STRING_TERMS_DATE_HISTOGRAM_AGGREGATION);
            } else if (oldType == AggregationType.STRING_TERMS_SUMMARY_AGGREGATION) {
                aggregationReq.aggregationType(AggregationType.MULTI_STRING_TERMS_SUMMARY_AGGREGATION);
            }
            LOGGER.info("Changing aggregate type from " + (Object)((Object)oldType) + " to " + (Object)((Object)aggregationReq.aggregationType()));
        }
    }

    private void buildStatsAggregationContext(SearchContext searchContext, SearchRequest.Aggregation aggregationReq) throws Exception {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        Aggregator aggr = null;
        if (aggregationReq.aggregationType() == AggregationType.STATS_AGGREGATION) {
            ArrayList<ValuesSource.Numeric> statsValuesSource = new ArrayList<ValuesSource.Numeric>();
            List<String> statsFields = aggregationReq.statsFieldArr();
            for (int i = 0; i < statsFields.size(); ++i) {
                statsValuesSource.add(new ValuesSource.Numeric.FieldData(statsFields.get(i)));
            }
            metaData.put("stats_field_data_type", aggregationReq.statsFieldsDataType());
            aggr = new StatsAggregator(statsValuesSource, aggregationReq.statsTypeArr(), searchContext, metaData);
        } else {
            ValuesSource.Numeric.FieldData valuesSource = new ValuesSource.Numeric.FieldData(aggregationReq.fields().get(0));
            if (aggregationReq.aggregationType() == AggregationType.MIN_AGGREGATION) {
                aggr = new MinAggregator(valuesSource, searchContext, metaData);
            } else if (aggregationReq.aggregationType() == AggregationType.MAX_AGGREGATION) {
                aggr = new MaxAggregator(valuesSource, searchContext, metaData);
            } else if (aggregationReq.aggregationType() == AggregationType.SUM_AGGREGATION) {
                aggr = new SumAggregator(valuesSource, searchContext, metaData);
            } else if (aggregationReq.aggregationType() == AggregationType.AVG_AGGREGATION) {
                aggr = new AvgAggregator(valuesSource, searchContext, metaData);
            }
        }
        searchContext.aggregations().aggregator(aggr);
        searchContext.queryCollector(aggr);
    }

    private void buildDateHistogramAggregationContext(SearchContext searchContext, SearchRequest.Aggregation aggregationReq, String timeZoneId) throws Exception {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        ValuesSource.Numeric.FieldData valuesSource = aggregationReq.timeField() == null || aggregationReq.timeField().isEmpty() ? new ValuesSource.Numeric.FieldData(TIME_FIELD) : new ValuesSource.Numeric.FieldData(aggregationReq.timeField());
        DateHistogramAggregator aggr = new DateHistogramAggregator(valuesSource, searchContext, DateTimeUnit.get((String)aggregationReq.timeInterval()), DateTimeZone.forID((String)timeZoneId), metaData);
        searchContext.aggregations().aggregator(aggr);
        searchContext.queryCollector(aggr);
    }

    private void buildTermsAggregationContext(SearchContext searchContext, SearchRequest.Aggregation aggregationReq) throws Exception {
        searchContext.aggregations().offset(aggregationReq.offset());
        searchContext.aggregations().size(aggregationReq.size());
        searchContext.aggregations().sortOrder(aggregationReq.sortOrder());
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        Aggregator aggr = null;
        if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.STRING_TERMS_STATS_AGGREGATION) {
            SortedDVOrdinalsFieldData fieldData = new SortedDVOrdinalsFieldData("", aggregationReq.fields().get(0));
            ValuesSource.Bytes.WithOrdinals.FieldData valuesSource = new ValuesSource.Bytes.WithOrdinals.FieldData(fieldData);
            if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_AGGREGATION) {
                aggr = new GlobalOrdinalsStringTermsAggregator(valuesSource, searchContext, metaData);
            } else if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_STATS_AGGREGATION && aggregationReq.statsType() == null) {
                ArrayList<ValuesSource.Numeric> statsValuesSource = new ArrayList<ValuesSource.Numeric>();
                List<String> statsFields = aggregationReq.statsFieldArr();
                for (int i = 0; i < statsFields.size(); ++i) {
                    statsValuesSource.add(new ValuesSource.Numeric.FieldData(statsFields.get(i)));
                }
                metaData.put("stats_field_data_type", aggregationReq.statsFieldsDataType());
                aggr = new GlobalOrdinalsStringTermsStatsAggregator(valuesSource, statsValuesSource, aggregationReq.statsTypeArr(), searchContext, metaData);
            }
        } else if (aggregationReq.aggregationType() == AggregationType.LONG_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.LONG_TERMS_STATS_AGGREGATION) {
            ValuesSource.Numeric.FieldData valuesSource = new ValuesSource.Numeric.FieldData(aggregationReq.fields().get(0));
            if (aggregationReq.aggregationType() == AggregationType.LONG_TERMS_AGGREGATION) {
                aggr = new LongTermsAggregator(valuesSource, searchContext, metaData);
            } else if (aggregationReq.aggregationType() == AggregationType.LONG_TERMS_STATS_AGGREGATION && aggregationReq.statsType() == null) {
                ArrayList<ValuesSource.Numeric> statsValuesSource = new ArrayList<ValuesSource.Numeric>();
                List<String> statsFields = aggregationReq.statsFieldArr();
                for (int i = 0; i < statsFields.size(); ++i) {
                    statsValuesSource.add(new ValuesSource.Numeric.FieldData(statsFields.get(i)));
                }
                metaData.put("stats_field_data_type", aggregationReq.statsFieldsDataType());
                aggr = new LongTermsStatsAggregator(valuesSource, statsValuesSource, aggregationReq.statsTypeArr(), searchContext, metaData);
            }
        } else if (aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_STATS_AGGREGATION) {
            ValuesSource.Numeric.FieldData valuesSource = new ValuesSource.Numeric.FieldData(aggregationReq.fields().get(0));
            if (aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_AGGREGATION) {
                aggr = new DoubleTermsAggregator(valuesSource, searchContext, metaData);
            } else if (aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_STATS_AGGREGATION && aggregationReq.statsType() == null) {
                ArrayList<ValuesSource.Numeric> statsValuesSource = new ArrayList<ValuesSource.Numeric>();
                List<String> statsFields = aggregationReq.statsFieldArr();
                for (int i = 0; i < statsFields.size(); ++i) {
                    statsValuesSource.add(new ValuesSource.Numeric.FieldData(statsFields.get(i)));
                }
                metaData.put("stats_field_data_type", aggregationReq.statsFieldsDataType());
                aggr = new DoubleTermsStatsAggregator(valuesSource, statsValuesSource, aggregationReq.statsTypeArr(), searchContext, metaData);
            }
        } else if (aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_AGGREGATION || aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_STATS_AGGREGATION) {
            ValuesSource.Bytes.MultiFieldData valuesSource = new ValuesSource.Bytes.MultiFieldData(aggregationReq.fields());
            if (aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_AGGREGATION) {
                aggr = new MultiStringTermsAggregator(valuesSource, searchContext, metaData);
            } else if (aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_STATS_AGGREGATION && aggregationReq.statsType() == null) {
                ArrayList<ValuesSource.Numeric> statsValuesSource = new ArrayList<ValuesSource.Numeric>();
                List<String> statsFields = aggregationReq.statsFieldArr();
                for (int i = 0; i < statsFields.size(); ++i) {
                    statsValuesSource.add(new ValuesSource.Numeric.FieldData(statsFields.get(i)));
                }
                metaData.put("stats_field_data_type", aggregationReq.statsFieldsDataType());
                aggr = new MultiStringTermsStatsAggregator(valuesSource, statsValuesSource, aggregationReq.statsTypeArr(), searchContext, metaData);
            }
        } else {
            throw new Exception("Aggregation type not handled!  : " + (Object)((Object)aggregationReq.aggregationType()));
        }
        searchContext.aggregations().aggregator(aggr);
        searchContext.queryCollector(aggr);
    }

    private void buildTermsDateHistogramAggregationContext(SearchContext searchContext, SearchRequest.Aggregation aggregationReq, String timeZoneId) throws Exception {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        ValuesSource.Numeric.FieldData timeValuesSource = aggregationReq.timeField() == null || aggregationReq.timeField().isEmpty() ? new ValuesSource.Numeric.FieldData(TIME_FIELD) : new ValuesSource.Numeric.FieldData(aggregationReq.timeField());
        searchContext.aggregations().offset(aggregationReq.offset());
        searchContext.aggregations().size(aggregationReq.size());
        searchContext.aggregations().sortOrder(aggregationReq.sortOrder());
        Aggregator aggr = null;
        if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_DATE_HISTOGRAM_AGGREGATION) {
            SortedDVOrdinalsFieldData fieldData = new SortedDVOrdinalsFieldData("", aggregationReq.fields().get(0));
            ValuesSource.Bytes.WithOrdinals.FieldData valuesSource = new ValuesSource.Bytes.WithOrdinals.FieldData(fieldData);
            aggr = new GlobalOrdinalsStringTermsDHAggregator(valuesSource, timeValuesSource, searchContext, DateTimeUnit.get((String)aggregationReq.timeInterval()), DateTimeZone.forID((String)timeZoneId), metaData);
        } else if (aggregationReq.aggregationType() == AggregationType.LONG_TERMS_DATE_HISTOGRAM_AGGREGATION) {
            ValuesSource.Numeric.FieldData valuesSource = new ValuesSource.Numeric.FieldData(aggregationReq.fields().get(0));
            aggr = new LongTermsHistogramAggregator(valuesSource, timeValuesSource, searchContext, DateTimeUnit.get((String)aggregationReq.timeInterval()), DateTimeZone.forID((String)timeZoneId), metaData);
        } else if (aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_DATE_HISTOGRAM_AGGREGATION) {
            ValuesSource.Numeric.FieldData valuesSource = new ValuesSource.Numeric.FieldData(aggregationReq.fields().get(0));
            aggr = new DoubleTermsHistogramAggregator(valuesSource, timeValuesSource, searchContext, DateTimeUnit.get((String)aggregationReq.timeInterval()), DateTimeZone.forID((String)timeZoneId), metaData);
        } else if (aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_DATE_HISTOGRAM_AGGREGATION) {
            ValuesSource.Bytes.MultiFieldData valuesSource = new ValuesSource.Bytes.MultiFieldData(aggregationReq.fields());
            aggr = new MultiStringTermsDHAggregator(valuesSource, timeValuesSource, searchContext, DateTimeUnit.get((String)aggregationReq.timeInterval()), DateTimeZone.forID((String)timeZoneId), metaData);
        } else {
            throw new Exception("Aggregation type not handled!  : " + (Object)((Object)aggregationReq.aggregationType()));
        }
        searchContext.aggregations().aggregator(aggr);
        searchContext.queryCollector(aggr);
    }

    private void buildTermsSummaryStatsAggregationContext(SearchContext searchContext, SearchRequest.Aggregation aggregationReq) throws Exception {
        ValuesSource.Bytes.MultiFieldData secValuesSource = new ValuesSource.Bytes.MultiFieldData(aggregationReq.fields());
        searchContext.aggregations().offset(aggregationReq.offset());
        searchContext.aggregations().size(aggregationReq.size());
        searchContext.aggregations().sortOrder(aggregationReq.sortOrder());
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        MultiStringTermsSummaryStatsAggregator aggr = null;
        if (aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_SUMMARY_STATS_AGGREGATION) {
            List<String> primFields = aggregationReq.primFields();
            ValuesSource.Bytes.MultiFieldData primValuesSource = new ValuesSource.Bytes.MultiFieldData(primFields);
            secValuesSource = new ValuesSource.Bytes.MultiFieldData(aggregationReq.fields());
            ArrayList<ValuesSource.Numeric> statsValuesSource = new ArrayList<ValuesSource.Numeric>();
            List<String> statsFields = aggregationReq.statsFieldArr();
            for (int i = 0; i < statsFields.size(); ++i) {
                statsValuesSource.add(new ValuesSource.Numeric.FieldData(statsFields.get(i)));
            }
            metaData.put("stats_field_data_type", aggregationReq.statsFieldsDataType());
            if (aggregationReq.filterBucketCount() != null) {
                metaData.put("filter_bucket_count", aggregationReq.filterBucketCount());
            }
            if (aggregationReq.filterMinBucketCount() != null) {
                metaData.put("filter_min_bucket_count", aggregationReq.filterMinBucketCount());
            }
            if (aggregationReq.filterMaxBucketCount() != null) {
                metaData.put("filter_max_bucket_count", aggregationReq.filterMaxBucketCount());
            }
            if (aggregationReq.filterDocCount() != null) {
                metaData.put("filter_doc_count", aggregationReq.filterDocCount());
            }
            if (aggregationReq.filterMinDocCount() != null) {
                metaData.put("filter_min_doc_count", aggregationReq.filterMinDocCount());
            }
            if (aggregationReq.filterMaxDocCount() != null) {
                metaData.put("filter_max_doc_count", aggregationReq.filterMaxDocCount());
            }
            aggr = new MultiStringTermsSummaryStatsAggregator(primValuesSource, secValuesSource, statsValuesSource, aggregationReq.statsTypeArr(), searchContext, metaData);
            searchContext.aggregations().aggregator(aggr);
            searchContext.queryCollector(aggr);
        }
    }

    private void buildTermsSummaryAggregationContext(SearchContext searchContext, SearchRequest.Aggregation aggregationReq) throws Exception {
        ValuesSource.Bytes.MultiFieldData secValuesSource = new ValuesSource.Bytes.MultiFieldData(aggregationReq.fields());
        searchContext.aggregations().offset(aggregationReq.offset());
        searchContext.aggregations().size(aggregationReq.size());
        searchContext.aggregations().sortOrder(aggregationReq.sortOrder());
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        Aggregator aggr = null;
        if (aggregationReq.aggregationType() == AggregationType.MULTI_STRING_TERMS_SUMMARY_AGGREGATION) {
            List<String> primFields = aggregationReq.primFields();
            ValuesSource.Bytes.MultiFieldData primValuesSource = new ValuesSource.Bytes.MultiFieldData(primFields);
            secValuesSource = new ValuesSource.Bytes.MultiFieldData(aggregationReq.fields());
            aggr = new MultiStringTermsSummaryAggregator(primValuesSource, secValuesSource, searchContext, metaData);
        } else if (aggregationReq.aggregationType() == AggregationType.STRING_TERMS_SUMMARY_AGGREGATION) {
            SortedDVOrdinalsFieldData fieldData = new SortedDVOrdinalsFieldData("", aggregationReq.fields().get(0));
            ValuesSource.Bytes.WithOrdinals.FieldData primValuesSource = new ValuesSource.Bytes.WithOrdinals.FieldData(fieldData);
            aggr = new GlobalOrdinalsStringTermsSummaryAggregator(primValuesSource, secValuesSource, searchContext, metaData);
        } else if (aggregationReq.aggregationType() == AggregationType.LONG_TERMS_SUMMARY_AGGREGATION) {
            ValuesSource.Numeric.FieldData primValuesSource = new ValuesSource.Numeric.FieldData(aggregationReq.fields().get(0));
            aggr = new LongTermsSummaryAggregator(primValuesSource, secValuesSource, searchContext, metaData);
        } else if (aggregationReq.aggregationType() == AggregationType.DOUBLE_TERMS_SUMMARY_AGGREGATION) {
            ValuesSource.Numeric.FieldData primValuesSource = new ValuesSource.Numeric.FieldData(aggregationReq.fields().get(0));
            aggr = new DoubleTermsSummaryAggregator(primValuesSource, secValuesSource, searchContext, metaData);
        } else {
            throw new Exception("Aggregation type not handled!  : " + (Object)((Object)aggregationReq.aggregationType()));
        }
        searchContext.aggregations().aggregator(aggr);
        searchContext.queryCollector(aggr);
    }

    private BytesRef toBytesRef(String str) throws ParseException {
        if (str.startsWith("[")) {
            str = str.substring(1, str.length() - 1);
            String[] arr = str.split(" ");
            byte[] byt = new byte[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                byt[i] = (byte)(Integer.parseInt(arr[i], 16) & 0xFF);
            }
            return new BytesRef(byt);
        }
        throw new ParseException("Cannot convert " + str + " to BytesRef!", 0);
    }

    private boolean canUseMultiReader(List<DRBlock> drBlocks) {
        int maxSize = 1990000000;
        int totalDocCount = 0;
        for (DRBlock drBlock : drBlocks) {
            if ((totalDocCount += drBlock.docCount().intValue()) < maxSize) continue;
            LOGGER.info("Approx total DocCount(" + totalDocCount + ") for search exceeds max size(" + maxSize + ")");
            return false;
        }
        LOGGER.info("Total DocCount for search : " + totalDocCount);
        return true;
    }
}

