/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimeFilteredCollector
implements Collector {
    private String filterField;
    private int startHour;
    private int endHour;
    private byte dayOfWeekByte;
    private int businessHourType;
    private String timeZone;
    private TopDocsCollector collector;
    final byte[] dayPositionBits = new byte[]{0, 1, 2, 4, 8, 16, 32, 64};

    public TimeFilteredCollector(String filterField, int startHour, int endHour, List<Integer> dayOfWeekList, int businessHourType, String timeZone, Sort sort, int numHits, ScoreDoc after) {
        this.filterField = filterField;
        this.startHour = startHour;
        this.endHour = endHour;
        this.timeZone = timeZone;
        this.businessHourType = businessHourType;
        this.collector = sort == null ? TopScoreDocCollector.create((int)numHits, (ScoreDoc)after) : TopFieldCollector.create((Sort)sort, (int)numHits, (FieldDoc)((FieldDoc)after), (boolean)true, (boolean)false, (boolean)false, (boolean)true);
        this.dayOfWeekByte = 0;
        for (int i = 0; i < dayOfWeekList.size(); ++i) {
            this.dayOfWeekByte = (byte)(this.dayOfWeekByte | this.dayPositionBits[dayOfWeekList.get(i)]);
        }
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
        final LeafCollector topLevelLeafCollector = this.collector.getLeafCollector(context);
        return new LeafCollector(){

            public void collect(int doc) throws IOException {
                if (values.advanceExact(doc)) {
                    long value = values.nextValue();
                    DateTime dateTime = new DateTime(value * 1000L, DateTimeZone.forID((String)TimeFilteredCollector.this.timeZone));
                    int evtHour = dateTime.getHourOfDay();
                    int evtDay = dateTime.getDayOfWeek();
                    if (TimeFilteredCollector.this.businessHourType == 1 && TimeFilteredCollector.this.startHour <= evtHour && evtHour < TimeFilteredCollector.this.endHour && (TimeFilteredCollector.this.dayOfWeekByte & TimeFilteredCollector.this.dayPositionBits[evtDay]) == TimeFilteredCollector.this.dayPositionBits[evtDay]) {
                        topLevelLeafCollector.collect(doc);
                    } else if (TimeFilteredCollector.this.businessHourType == 2 && (evtHour < TimeFilteredCollector.this.startHour || evtHour >= TimeFilteredCollector.this.endHour || (TimeFilteredCollector.this.dayOfWeekByte & TimeFilteredCollector.this.dayPositionBits[evtDay]) != TimeFilteredCollector.this.dayPositionBits[evtDay])) {
                        topLevelLeafCollector.collect(doc);
                    }
                }
            }

            public void setScorer(Scorer scorer) throws IOException {
                topLevelLeafCollector.setScorer(scorer);
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    public TopDocsCollector collector() {
        return this.collector;
    }
}

