/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import java.util.Comparator;

public class AggregationSortOrder {
    private static final byte COUNT_DESC_ID = 1;
    private static final byte COUNT_ASC_ID = 2;
    private static final byte TERM_DESC_ID = 3;
    private static final byte TERM_ASC_ID = 4;
    private static final byte STATS_DESC_ID = 5;
    private static final byte STATS_ASC_ID = 6;
    public static final AggregationSortOrder COUNT_DESC = new AggregationSortOrder(1, "_count", false, new Comparator<BucketAggregation.Bucket>(){

        @Override
        public int compare(BucketAggregation.Bucket o1, BucketAggregation.Bucket o2) {
            return Long.compare(o2.getDocCount(), o1.getDocCount());
        }
    });
    public static final AggregationSortOrder COUNT_ASC = new AggregationSortOrder(2, "_count", true, new Comparator<BucketAggregation.Bucket>(){

        @Override
        public int compare(BucketAggregation.Bucket o1, BucketAggregation.Bucket o2) {
            return Long.compare(o1.getDocCount(), o2.getDocCount());
        }
    });
    public static final AggregationSortOrder TERM_DESC = new AggregationSortOrder(3, "_term", false, new Comparator<BucketAggregation.Bucket>(){

        @Override
        public int compare(BucketAggregation.Bucket o1, BucketAggregation.Bucket o2) {
            return o2.compare(o1);
        }
    });
    public static final AggregationSortOrder TERM_ASC = new AggregationSortOrder(4, "_term", true, new Comparator<BucketAggregation.Bucket>(){

        @Override
        public int compare(BucketAggregation.Bucket o1, BucketAggregation.Bucket o2) {
            return o1.compare(o2);
        }
    });
    public static final AggregationSortOrder STATS_DESC = new AggregationSortOrder(5, "_stat", false, new Comparator<BucketAggregation.Bucket>(){

        @Override
        public int compare(BucketAggregation.Bucket o1, BucketAggregation.Bucket o2) {
            return Double.compare(o2.getStatsArr().get(0), o1.getStatsArr().get(0));
        }
    });
    public static final AggregationSortOrder STATS_ASC = new AggregationSortOrder(6, "_stat", true, new Comparator<BucketAggregation.Bucket>(){

        @Override
        public int compare(BucketAggregation.Bucket o1, BucketAggregation.Bucket o2) {
            return Double.compare(o1.getStatsArr().get(0), o2.getStatsArr().get(0));
        }
    });
    final byte id;
    final String key;
    final boolean asc;
    protected final Comparator<BucketAggregation.Bucket> comparator;

    AggregationSortOrder(byte id, String key, boolean asc, Comparator<BucketAggregation.Bucket> comparator) {
        this.id = id;
        this.key = key;
        this.asc = asc;
        this.comparator = comparator;
    }

    byte id() {
        return this.id;
    }

    public Comparator<BucketAggregation.Bucket> comparator(Aggregator aggregator) {
        return this.comparator;
    }

    public static AggregationSortOrder count(boolean asc) {
        return asc ? COUNT_ASC : COUNT_DESC;
    }

    public static AggregationSortOrder term(boolean asc) {
        return asc ? TERM_ASC : TERM_DESC;
    }
}

