/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Collector;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class Aggregator
implements Collector {
    private final long id;
    private final AggregationSortOrder sortOrder;
    private final int offset;
    private final int size;
    private final SearchContext context;
    private final Map<String, Object> metaData;
    protected String filterField;
    protected int startHour;
    protected int endHour;
    protected byte dayOfWeekByte;
    protected Integer businessHourType;
    protected final byte[] dayPositionBits = new byte[]{0, 1, 2, 4, 8, 16, 32, 64};

    public Aggregator(SearchContext context, Map<String, Object> metaData) throws IOException {
        this.id = context.id();
        this.sortOrder = context.aggregations().sortOrder();
        this.offset = context.aggregations().offset();
        this.size = context.aggregations().size();
        this.context = context;
        HashMap hashMap = this.metaData = metaData == null ? new HashMap() : metaData;
        if (context.businessHour() != null && (context.businessHour() == 1 || context.businessHour() == 2)) {
            this.filterField = context.timeField();
            this.businessHourType = context.businessHour();
            this.startHour = context.businessHourFrom();
            this.endHour = context.businessHourTo();
            this.dayOfWeekByte = 0;
            for (int i = 0; i < context.businessDays().size(); ++i) {
                this.dayOfWeekByte = (byte)(this.dayOfWeekByte | this.dayPositionBits[context.businessDays().get(i)]);
            }
        }
    }

    public long id() {
        return this.id;
    }

    public AggregationSortOrder sortOrder() {
        return this.sortOrder;
    }

    public int offset() {
        return this.offset;
    }

    public int size() {
        return this.size;
    }

    public SearchContext searchContext() {
        return this.context;
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public void metaData(String key, Object value) {
        this.metaData.put(key, value);
    }

    public AggregationType aggregationType() {
        return this.context.aggregations().aggregationType();
    }

    public boolean isValidTime(SortedNumericDocValues filterDocValues, int doc) throws IOException {
        if (filterDocValues.advanceExact(doc)) {
            long timeValue = filterDocValues.nextValue();
            DateTime dateTime = new DateTime(timeValue * 1000L, DateTimeZone.forID((String)this.searchContext().timeZoneId()));
            int evtHour = dateTime.getHourOfDay();
            int evtDay = dateTime.getDayOfWeek();
            return this.businessHourType == 1 && this.startHour <= evtHour && evtHour < this.endHour && (this.dayOfWeekByte & this.dayPositionBits[evtDay]) == this.dayPositionBits[evtDay] || this.businessHourType == 2 && (evtHour < this.startHour || evtHour >= this.endHour || (this.dayOfWeekByte & this.dayPositionBits[evtDay]) != this.dayPositionBits[evtDay]);
        }
        return false;
    }

    public abstract AggregationResult buildAggregation() throws IOException;
}

