/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import java.math.BigDecimal;
import org.json.JSONException;
import org.json.JSONObject;

public class DoubleValueResult
extends AggregationResult {
    private double[] values;

    public DoubleValueResult(long id, AggregationType aggregationType, double ... values) {
        super(id, aggregationType);
        this.values = values;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jAggrResult = new JSONObject();
        if (this.aggregationType() == AggregationType.STATS_AGGREGATION && this.values.length == 4) {
            jAggrResult.put(AggregationType.MIN_AGGREGATION.toString(), (Object)BigDecimal.valueOf(this.values[0]).toPlainString());
            jAggrResult.put(AggregationType.MAX_AGGREGATION.toString(), (Object)BigDecimal.valueOf(this.values[1]).toPlainString());
            jAggrResult.put(AggregationType.SUM_AGGREGATION.toString(), (Object)BigDecimal.valueOf(this.values[2]).toPlainString());
            jAggrResult.put(AggregationType.AVG_AGGREGATION.toString(), (Object)BigDecimal.valueOf(this.values[3]).toPlainString());
        } else {
            jAggrResult.put(this.aggregationType().toString(), (Object)BigDecimal.valueOf(this.values[0]).toPlainString());
        }
        return jAggrResult;
    }
}

