/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import java.io.IOException;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

public class GlobalOrdinalMapping
extends SortedDocValues {
    private final SortedDocValues values;
    private final OrdinalMap ordinalMap;
    private final LongValues mapping;
    private final SortedDocValues[] bytesValues;

    public GlobalOrdinalMapping(OrdinalMap ordinalMap, SortedDocValues[] bytesValues, int segmentIndex) {
        this.values = bytesValues[segmentIndex];
        this.bytesValues = bytesValues;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    public int getValueCount() {
        return (int)this.ordinalMap.getValueCount();
    }

    public final long getGlobalOrd(long segmentOrd) {
        return this.mapping.get(segmentOrd);
    }

    public BytesRef lookupOrd(int globalOrd) throws IOException {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd((long)globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber((long)globalOrd);
        return this.bytesValues[readerIndex].lookupOrd((int)segmentOrd);
    }

    public int ordValue() throws IOException {
        long ord = this.getGlobalOrd(this.values.ordValue());
        if (ord > Integer.MAX_VALUE) {
            throw new ClassCastException("EXCEPTION : Cannot cast long value " + ord + " to integer as size exceeds!");
        }
        return (int)ord;
    }

    public boolean advanceExact(int docID) throws IOException {
        return this.values.advanceExact(docID);
    }

    public int docID() {
        return this.values.docID();
    }

    public int nextDoc() throws IOException {
        return this.values.nextDoc();
    }

    public int advance(int docID) throws IOException {
        return this.values.advance(docID);
    }

    public long cost() {
        return this.values.cost();
    }
}

