/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.GlobalOrdinalsFieldData;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.OrdinalsFieldData;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;

public class GlobalOrdinalsBuilder {
    private static final Logger LOGGER = LogManager.getLogger((String)"ActionTrace");

    public static GlobalOrdinalsFieldData build(IndexReader indexReader, OrdinalsFieldData indexFieldData) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTimeNS = System.nanoTime();
        LOGGER.info("GlobalOrdinalsBuilder :: indexReader " + indexReader.leaves().size());
        SortedDocValues[] subs = new SortedDocValues[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            subs[i] = indexFieldData.getOrdinalsValues(((LeafReaderContext)indexReader.leaves().get(i)).reader());
        }
        OrdinalMap ordinalMap = OrdinalMap.build(null, (SortedDocValues[])subs, (float)0.25f);
        long memorySizeInBytes = ordinalMap.ramBytesUsed();
        LOGGER.info("GlobalOrdinalsBuilder :: MEM " + memorySizeInBytes);
        return new GlobalOrdinalsFieldData(indexFieldData.getFieldName(), subs, ordinalMap, memorySizeInBytes);
    }
}

