/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;

public class LeafDocLookup
implements Map {
    private final Map<String, MultiFieldDocValues.FieldDocValues> localCacheFieldData = new HashMap<String, MultiFieldDocValues.FieldDocValues>(4);
    private final LeafReaderContext context;
    private static final Logger LOGGER = LogManager.getLogger((String)"ActionTrace");

    public LeafDocLookup(LeafReaderContext context) {
        this.context = context;
    }

    public Object get(Object key) {
        FieldInfo fieldInfo;
        String fieldName = key.toString();
        MultiFieldDocValues.FieldDocValues docValues = this.localCacheFieldData.get(fieldName);
        if (docValues == null && (fieldInfo = this.context.reader().getFieldInfos().fieldInfo(fieldName)) != null) {
            DocValuesType docValuesType = fieldInfo.getDocValuesType();
            try {
                if (DocValuesType.SORTED == docValuesType) {
                    docValues = new MultiFieldDocValues.FieldDocValues.Strings(DocValues.getSorted((LeafReader)this.context.reader(), (String)fieldName));
                } else if (DocValuesType.SORTED_NUMERIC == docValuesType) {
                    docValues = new MultiFieldDocValues.FieldDocValues.Longs(DocValues.getSortedNumeric((LeafReader)this.context.reader(), (String)fieldName));
                }
            }
            catch (IOException e) {
                e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
            }
            this.localCacheFieldData.put(fieldName, docValues);
        }
        return docValues;
    }

    @Override
    public boolean containsKey(Object key) {
        String fieldName = key.toString();
        MultiFieldDocValues.FieldDocValues docValues = this.localCacheFieldData.get(fieldName);
        return docValues != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }
}

