/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiStatsResult
extends AggregationResult {
    private List<StatsType> statsType;
    private long totalHitCount = 0L;
    private ArrayList<Double> statsArrBucket;
    private Map<String, Object> metaData;
    ArrayList<DRFieldDataType> statFieldsDataType;

    public MultiStatsResult(long id, AggregationType aggregationType, ArrayList<Double> statsArrBucket, List<StatsType> statsTypes, long totalHitCount, Map<String, Object> metaData) {
        super(id, aggregationType);
        this.statsArrBucket = statsArrBucket;
        this.statsType = statsTypes;
        this.totalHitCount = totalHitCount;
        this.metaData = metaData;
        this.statFieldsDataType = (ArrayList)this.metaData.get("stats_field_data_type");
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jAggrResult = new JSONObject();
        JSONArray jColValueArr = new JSONArray();
        boolean statsFieldHasFloatingPoint = false;
        for (int i = 0; i < this.statsType.size(); ++i) {
            statsFieldHasFloatingPoint = this.statFieldsDataType.get(i).hasFloatingPoint();
            if (this.statsType.get(i) == StatsType.AVG) {
                jColValueArr.put((Object)(statsFieldHasFloatingPoint ? BigDecimal.valueOf(this.statsArrBucket.get(i) / (double)this.totalHitCount).toPlainString() : BigDecimal.valueOf(this.statsArrBucket.get(i) / (double)this.totalHitCount).setScale(0).toPlainString()));
                continue;
            }
            jColValueArr.put((Object)(statsFieldHasFloatingPoint ? BigDecimal.valueOf(this.statsArrBucket.get(i)).toPlainString() : BigDecimal.valueOf(this.statsArrBucket.get(i)).setScale(0).toPlainString()));
        }
        jAggrResult.put("stats", (Object)jColValueArr);
        jAggrResult.put("total_hits", this.totalHitCount);
        return jAggrResult;
    }
}

