/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.LeafDocLookup;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.GlobalOrdinalsFieldData;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.OrdinalsFieldData;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.IndexSearcher;

public abstract class ValuesSource {

    public static abstract class Numeric
    extends ValuesSource {
        public abstract FieldDocValues longValues(LeafReaderContext var1) throws IOException;

        public abstract FieldDocValues doubleValues(LeafReaderContext var1) throws IOException;

        public static class FieldData
        extends Numeric {
            private String field;

            public FieldData(String field) {
                this.field = field;
            }

            @Override
            public FieldDocValues longValues(LeafReaderContext context) throws IOException {
                return FieldDocValues.longValues(context, this.field);
            }

            @Override
            public FieldDocValues doubleValues(LeafReaderContext context) throws IOException {
                return FieldDocValues.doubleValues(context, this.field);
            }
        }
    }

    public static abstract class Bytes
    extends ValuesSource {

        public static class MultiFieldData
        extends Bytes {
            private List<String> fieldList;
            private LeafDocLookup lookup;
            private MultiFieldDocValues multiFieldDocValues;

            public MultiFieldData(List<String> list) {
                this.fieldList = list;
            }

            public MultiFieldDocValues docValues(LeafReaderContext context) throws IOException {
                this.lookup = new LeafDocLookup(context);
                this.multiFieldDocValues = new MultiFieldDocValues(this.fieldList, this.lookup);
                return this.multiFieldDocValues;
            }
        }

        public static abstract class WithOrdinals
        extends Bytes {
            public abstract SortedDocValues ordinalsValues(LeafReaderContext var1);

            public abstract SortedDocValues globalOrdinalsValues(LeafReaderContext var1) throws IOException;

            public long globalMaxOrd(IndexSearcher indexSearcher) throws IOException {
                IndexReader indexReader = indexSearcher.getIndexReader();
                if (indexReader.leaves().isEmpty()) {
                    return 0L;
                }
                LeafReaderContext atomicReaderContext = (LeafReaderContext)indexReader.leaves().get(0);
                SortedDocValues values = this.globalOrdinalsValues(atomicReaderContext);
                return values.getValueCount();
            }

            public static class FieldData
            extends WithOrdinals {
                protected final OrdinalsFieldData indexFieldData;

                public FieldData(OrdinalsFieldData indexFieldData) {
                    this.indexFieldData = indexFieldData;
                }

                @Override
                public SortedDocValues ordinalsValues(LeafReaderContext context) {
                    return this.indexFieldData.getOrdinalsValues(context.reader());
                }

                @Override
                public SortedDocValues globalOrdinalsValues(LeafReaderContext context) throws IOException {
                    CompositeReaderContext parentReaderContext = context.parent;
                    if (!parentReaderContext.isTopLevel) {
                        parentReaderContext = parentReaderContext.parent;
                    }
                    GlobalOrdinalsFieldData global = this.indexFieldData.loadGlobal((IndexReader)parentReaderContext.reader());
                    return global.getOrdinalsValues(context);
                }
            }
        }
    }
}

