/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BucketAggregation<A, B>
extends AggregationResult {
    public final long otherDocCount;
    protected final List<B> buckets;
    public final long totalBucketCount;
    public final long totalHitCount;
    private final Map<String, Object> metaData;

    public BucketAggregation(long id, AggregationType aggregationType, long totalBucketCount, long totalHitCount, long otherDocCount, List<B> buckets, Map<String, Object> metaData) {
        super(id, aggregationType);
        this.totalBucketCount = totalBucketCount;
        this.totalHitCount = totalHitCount;
        this.otherDocCount = otherDocCount;
        this.buckets = buckets;
        this.metaData = metaData == null ? new HashMap() : metaData;
    }

    public abstract List<B> getBuckets();

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public static abstract class Bucket<B> {
        public long bucketOrd;
        public long docCount;
        public ArrayList<Double> statsArr;

        public long getDocCount() {
            return this.docCount;
        }

        public ArrayList<Double> getStatsArr() {
            return this.statsArr;
        }

        public abstract int compare(B var1);
    }
}

