/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public abstract class BucketsAggregator
extends Aggregator {
    private ArrayList<Long> bucketDocCountList = new ArrayList();
    private long nullBucketDocCount = 0L;

    public BucketsAggregator(SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
    }

    public final int getBucketCount() {
        return this.nullBucketDocCount == 0L ? this.bucketDocCountList.size() : this.bucketDocCountList.size() + 1;
    }

    public final void growBucket(int maxBucketOrd) {
        for (int i = this.bucketDocCountList.size(); i < maxBucketOrd; ++i) {
            this.bucketDocCountList.add(i, 0L);
        }
    }

    public final void collectBucket(int bucketOrd) throws IOException {
        this.growBucket(bucketOrd + 1);
        this.collectExistingBucket(bucketOrd);
    }

    public final void collectExistingBucket(int bucketOrd) throws IOException {
        this.bucketDocCountList.set(bucketOrd, this.bucketDocCountList.get(bucketOrd) + 1L);
    }

    public final void collectNullBucket() throws IOException {
        ++this.nullBucketDocCount;
    }

    public final long getBucketDocCount(int bucketOrd) {
        if (bucketOrd >= this.bucketDocCountList.size()) {
            return 0L;
        }
        if (bucketOrd == -1) {
            return this.nullBucketDocCount;
        }
        return this.bucketDocCountList.get(bucketOrd);
    }

    public final long getNullBucketDocCount() {
        return this.nullBucketDocCount;
    }
}

