/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTimeField;

public abstract class BucketsHistogramAggregator
extends BucketsAggregator {
    private ArrayList<HashMap<Long, Long>> histogramBucketList = new ArrayList();
    private HashMap<Long, Long> nullHistogramBucket = new HashMap();

    public BucketsHistogramAggregator(SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
    }

    public final void growHistogramBucket(int maxBucketOrd) {
        this.growBucket(maxBucketOrd);
        for (int i = this.histogramBucketList.size(); i < maxBucketOrd; ++i) {
            this.histogramBucketList.add(i, new HashMap());
        }
    }

    public final int getHistogramBucketCount() {
        return this.getNullBucketDocCount() == 0L ? this.histogramBucketList.size() : this.histogramBucketList.size() + 1;
    }

    public final HashMap<Long, Long> getHistogramBucket(int bucketOrd) {
        if (bucketOrd == -1) {
            return this.nullHistogramBucket;
        }
        return this.histogramBucketList.get(bucketOrd);
    }

    public final HashMap<Long, Long> getNullHistogramBucket() {
        return this.nullHistogramBucket;
    }

    public void collectExistingHistogramBucket(int bucketOrd, DateTimeField dateTimeField, Long dateTimeValue) throws IOException {
        this.collectExistingBucket(bucketOrd);
        if (dateTimeValue != null) {
            if (bucketOrd >= this.histogramBucketList.size()) {
                throw new IOException("Accessing histogram bucket beyond size! bucketOrd : " + bucketOrd + ", histogramBucketList.size() : " + this.histogramBucketList.size());
            }
            long roundedValue = dateTimeField.roundFloor(dateTimeValue * 1000L);
            HashMap<Long, Long> existMap = this.histogramBucketList.get(bucketOrd);
            if (existMap.containsKey(roundedValue)) {
                existMap.put(roundedValue, existMap.get(roundedValue) + 1L);
            } else {
                existMap.put(roundedValue, 1L);
            }
        }
    }

    public void collectHistogramBucket(int bucketOrd, DateTimeField dateTimeField, Long dateTimeValue) throws IOException {
        this.growHistogramBucket(bucketOrd + 1);
        this.collectExistingHistogramBucket(bucketOrd, dateTimeField, dateTimeValue);
    }

    public void collectNullHistogramBucket(DateTimeField dateTimeField, Long dateTimeValue) throws IOException {
        this.collectNullBucket();
        if (dateTimeValue != null) {
            long roundedValue = dateTimeField.roundFloor(dateTimeValue * 1000L);
            if (this.nullHistogramBucket.containsKey(roundedValue)) {
                this.nullHistogramBucket.put(roundedValue, this.nullHistogramBucket.get(roundedValue) + 1L);
            } else {
                this.nullHistogramBucket.put(roundedValue, 1L);
            }
        }
    }
}

