/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsGenericAggregator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTimeField;

public abstract class BucketsHistogramGenericAggregator<T>
extends BucketsGenericAggregator<T> {
    private HashMap<T, HashMap<Long, Long>> histogramBucketMap = new HashMap();

    public BucketsHistogramGenericAggregator(SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
    }

    public final int getHistogramBucketCount() {
        return this.histogramBucketMap.size();
    }

    public final HashMap<Long, Long> getHistogramBucket(T bucketOrd) {
        return this.histogramBucketMap.get(bucketOrd);
    }

    public void collectHistogramBucket(T bucketOrd, DateTimeField dateTimeField, Long dateTimeValue) throws IOException {
        this.collectBucket(bucketOrd);
        if (this.histogramBucketMap.containsKey(bucketOrd) && dateTimeValue != null) {
            long roundedValue = dateTimeField.roundFloor(dateTimeValue * 1000L);
            HashMap<Long, Long> existMap = this.histogramBucketMap.get(bucketOrd);
            if (existMap.containsKey(roundedValue)) {
                existMap.put(roundedValue, existMap.get(roundedValue) + 1L);
            } else {
                existMap.put(roundedValue, 1L);
            }
        } else if (!this.histogramBucketMap.containsKey(bucketOrd)) {
            if (dateTimeValue == null) {
                this.histogramBucketMap.put(bucketOrd, new HashMap());
            } else {
                long roundedValue = dateTimeField.roundFloor(dateTimeValue * 1000L);
                HashMap<Long, Long> newMap = new HashMap<Long, Long>();
                newMap.put(roundedValue, 1L);
                this.histogramBucketMap.put(bucketOrd, newMap);
            }
        }
    }
}

