/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public abstract class BucketsStatsAggregator
extends BucketsAggregator {
    private ArrayList<ArrayList<Double>> statsArrBucketList = new ArrayList();
    private ArrayList<Double> nullStatsArrBucket = new ArrayList();
    private int statsFieldCount = 0;

    public BucketsStatsAggregator(SearchContext context, Map<String, Object> metaData, int statsFieldCount) throws IOException {
        super(context, metaData);
        this.statsFieldCount = statsFieldCount;
        for (int i = 0; i < this.statsFieldCount; ++i) {
            this.statsArrBucketList.add(i, new ArrayList());
            this.nullStatsArrBucket.add(i, 0.0);
        }
    }

    public final int getStatsBucketCount(int statsFieldIndex) {
        return this.getNullBucketDocCount() == 0L ? this.statsArrBucketList.get(statsFieldIndex).size() : this.statsArrBucketList.get(statsFieldIndex).size() + 1;
    }

    public final void growStatsBucket(int statsFieldIndex, int maxBucketOrd, StatsType statsType) {
        this.growBucket(maxBucketOrd);
        if (statsType == StatsType.MIN) {
            for (int i = this.statsArrBucketList.get(statsFieldIndex).size(); i < maxBucketOrd; ++i) {
                this.statsArrBucketList.get(statsFieldIndex).add(i, Double.POSITIVE_INFINITY);
                this.nullStatsArrBucket.set(statsFieldIndex, Double.POSITIVE_INFINITY);
            }
        } else if (statsType == StatsType.MAX) {
            for (int i = this.statsArrBucketList.get(statsFieldIndex).size(); i < maxBucketOrd; ++i) {
                this.statsArrBucketList.get(statsFieldIndex).add(i, Double.NEGATIVE_INFINITY);
                this.nullStatsArrBucket.set(statsFieldIndex, Double.NEGATIVE_INFINITY);
            }
        } else {
            for (int i = this.statsArrBucketList.get(statsFieldIndex).size(); i < maxBucketOrd; ++i) {
                this.statsArrBucketList.get(statsFieldIndex).add(i, 0.0);
                this.nullStatsArrBucket.set(statsFieldIndex, 0.0);
            }
        }
    }

    public final void collectStatsBucket(int statsFieldIndex, int bucketOrd, StatsType statsType, Double val) throws IOException {
        this.growStatsBucket(statsFieldIndex, bucketOrd + 1, statsType);
        this.collectExistingStatsBucket(statsFieldIndex, bucketOrd, statsType, val);
    }

    public final void collectExistingStatsBucket(int statsFieldIndex, int bucketOrd, StatsType statsType, Double val) throws IOException {
        this.collectExistingBucket(bucketOrd);
        if (val != null) {
            if (statsType == StatsType.MIN) {
                this.statsArrBucketList.get(statsFieldIndex).set(bucketOrd, Math.min(this.statsArrBucketList.get(statsFieldIndex).get(bucketOrd), val));
            } else if (statsType == StatsType.MAX) {
                this.statsArrBucketList.get(statsFieldIndex).set(bucketOrd, Math.max(this.statsArrBucketList.get(statsFieldIndex).get(bucketOrd), val));
            } else if (statsType == StatsType.SUM) {
                this.statsArrBucketList.get(statsFieldIndex).set(bucketOrd, this.statsArrBucketList.get(statsFieldIndex).get(bucketOrd) + val);
            } else if (statsType == StatsType.AVG) {
                this.statsArrBucketList.get(statsFieldIndex).set(bucketOrd, this.statsArrBucketList.get(statsFieldIndex).get(bucketOrd) + val);
            }
        }
    }

    public final void collectNullStatsBucket(int statsFieldIndex, StatsType statsType, Double val) throws IOException {
        this.collectNullBucket();
        if (val != null) {
            if (statsType == StatsType.MIN) {
                this.nullStatsArrBucket.set(statsFieldIndex, Math.min(this.nullStatsArrBucket.get(statsFieldIndex), val));
            } else if (statsType == StatsType.MAX) {
                this.nullStatsArrBucket.set(statsFieldIndex, Math.max(this.nullStatsArrBucket.get(statsFieldIndex), val));
            } else if (statsType == StatsType.SUM) {
                this.nullStatsArrBucket.set(statsFieldIndex, this.nullStatsArrBucket.get(statsFieldIndex) + val);
            } else if (statsType == StatsType.AVG) {
                this.nullStatsArrBucket.set(statsFieldIndex, this.nullStatsArrBucket.get(statsFieldIndex) + val);
            }
        }
    }

    public final Double getStatsBucketValue(int statsFieldIndex, int bucketOrd, StatsType statsType) {
        if (bucketOrd >= this.statsArrBucketList.get(statsFieldIndex).size()) {
            return null;
        }
        if (bucketOrd == -1) {
            if (statsType == StatsType.AVG) {
                return this.nullStatsArrBucket.get(statsFieldIndex) / (double)(this.getNullBucketDocCount() / (long)this.statsFieldCount);
            }
            return this.nullStatsArrBucket.get(statsFieldIndex);
        }
        if (statsType == StatsType.AVG) {
            return this.statsArrBucketList.get(statsFieldIndex).get(bucketOrd) / (double)(this.getBucketDocCount(bucketOrd) / (long)this.statsFieldCount);
        }
        return this.statsArrBucketList.get(statsFieldIndex).get(bucketOrd);
    }

    public double getNullStatsBucketValue(int statsFieldIndex, StatsType statsType) {
        if (statsType == StatsType.AVG) {
            return this.nullStatsArrBucket.get(statsFieldIndex) / (double)(this.getNullBucketDocCount() / (long)this.statsFieldCount);
        }
        return this.nullStatsArrBucket.get(statsFieldIndex);
    }
}

