/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsGenericAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class BucketsStatsGenericAggregator<T>
extends BucketsGenericAggregator<T> {
    private ArrayList<HashMap<T, Double>> statsArrBucketMap = new ArrayList();
    private int statsFieldCount = 0;

    public BucketsStatsGenericAggregator(SearchContext context, Map<String, Object> metaData, int statsFieldCount) throws IOException {
        super(context, metaData);
        this.statsFieldCount = statsFieldCount;
        for (int i = 0; i < this.statsFieldCount; ++i) {
            this.statsArrBucketMap.add(i, new HashMap());
        }
    }

    public final int getStatsBucketCount(int statsFieldIndex) {
        return this.statsArrBucketMap.get(statsFieldIndex).size();
    }

    public final Double getStatsBucketValue(int statsFieldIndex, T bucketOrd, StatsType statsType) {
        if (statsType == StatsType.AVG) {
            return this.statsArrBucketMap.get(statsFieldIndex).get(bucketOrd) / (double)(this.getBucketDocCount(bucketOrd) / (long)this.statsFieldCount);
        }
        return this.statsArrBucketMap.get(statsFieldIndex).get(bucketOrd);
    }

    public final void collectStatsBucket(int statsFieldIndex, T bucketOrd, Double value, StatsType statsType) throws IOException {
        this.collectBucket(bucketOrd);
        if (this.statsArrBucketMap.get(statsFieldIndex).containsKey(bucketOrd) && value != null) {
            if (statsType == StatsType.MIN) {
                this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, Math.min(this.statsArrBucketMap.get(statsFieldIndex).get(bucketOrd), value));
            } else if (statsType == StatsType.MAX) {
                this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, Math.max(this.statsArrBucketMap.get(statsFieldIndex).get(bucketOrd), value));
            } else if (statsType == StatsType.SUM) {
                this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, this.statsArrBucketMap.get(statsFieldIndex).get(bucketOrd) + value);
            } else if (statsType == StatsType.AVG) {
                this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, this.statsArrBucketMap.get(statsFieldIndex).get(bucketOrd) + value);
            }
        } else if (!this.statsArrBucketMap.get(statsFieldIndex).containsKey(bucketOrd)) {
            if (value == null) {
                if (statsType == StatsType.MIN) {
                    this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, Double.POSITIVE_INFINITY);
                } else if (statsType == StatsType.MAX) {
                    this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, Double.NEGATIVE_INFINITY);
                } else if (statsType == StatsType.SUM) {
                    this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, 0.0);
                } else if (statsType == StatsType.AVG) {
                    this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, 0.0);
                }
            } else {
                this.statsArrBucketMap.get(statsFieldIndex).put(bucketOrd, value);
            }
        }
    }
}

