/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class BucketsSummaryAggregator
extends BucketsAggregator {
    private volatile ArrayList<HashMap<Integer, Integer>> summaryBucketList = new ArrayList();
    private HashMap<Integer, Integer> nullSummaryBucket = new HashMap();

    public BucketsSummaryAggregator(SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
    }

    public final void growSummaryBucket(int maxBucketOrd) {
        this.growBucket(maxBucketOrd);
        for (int i = this.summaryBucketList.size(); i < maxBucketOrd; ++i) {
            this.summaryBucketList.add(i, new HashMap());
        }
    }

    public final int getSummaryBucketCount() {
        return this.getNullBucketDocCount() == 0L ? this.summaryBucketList.size() : this.summaryBucketList.size() + 1;
    }

    public final HashMap<Integer, Integer> getSummaryBucket(int bucketOrd) {
        if (bucketOrd == -1) {
            return this.nullSummaryBucket;
        }
        return this.summaryBucketList.get(bucketOrd);
    }

    public final HashMap<Integer, Integer> getNullSummaryBucket() {
        return this.nullSummaryBucket;
    }

    public void collectSummaryBucket(int primBucketOrd, int otherBucketOrd) throws IOException {
        this.growSummaryBucket(primBucketOrd + 1);
        this.collectExistingSummaryBucket(primBucketOrd, otherBucketOrd);
    }

    public void collectExistingSummaryBucket(int primBucketOrd, int otherBucketOrd) throws IOException {
        this.collectExistingBucket(primBucketOrd);
        if (primBucketOrd >= this.summaryBucketList.size()) {
            throw new IOException("Accessing summary bucket beyond size! bucketOrd : " + primBucketOrd + ", summaryBucketList.size() : " + this.summaryBucketList.size());
        }
        HashMap<Integer, Integer> existMap = this.summaryBucketList.get(primBucketOrd);
        if (existMap.containsKey(otherBucketOrd)) {
            existMap.put(otherBucketOrd, existMap.get(otherBucketOrd) + 1);
        } else {
            existMap.put(otherBucketOrd, 1);
        }
    }

    public void collectNullSummaryBucket(int otherBucketOrd) throws IOException {
        this.collectNullBucket();
        if (this.nullSummaryBucket.containsKey(otherBucketOrd)) {
            this.nullSummaryBucket.put(otherBucketOrd, this.nullSummaryBucket.get(otherBucketOrd) + 1);
        } else {
            this.nullSummaryBucket.put(otherBucketOrd, 1);
        }
    }
}

