/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class BucketsSummaryStatsAggregator
extends BucketsAggregator {
    private volatile ArrayList<HashMap<Integer, ArrayList<Double>>> summaryStatsBucketList = new ArrayList();
    private HashMap<Integer, ArrayList<Double>> nullSummaryStatsBucket = new HashMap();
    private int statsFieldCount = 0;

    public BucketsSummaryStatsAggregator(SearchContext context, Map<String, Object> metaData, int statsFieldCount) throws IOException {
        super(context, metaData);
        this.statsFieldCount = statsFieldCount;
    }

    public final void growSummaryStatsBucket(int maxBucketOrd) {
        this.growBucket(maxBucketOrd);
        for (int i = this.summaryStatsBucketList.size(); i < maxBucketOrd; ++i) {
            this.summaryStatsBucketList.add(i, new HashMap());
        }
    }

    public final int getGroupBucketCount(int primBucketOrd) {
        if (primBucketOrd == -1) {
            return this.nullSummaryStatsBucket.size();
        }
        return this.summaryStatsBucketList.get(primBucketOrd).size();
    }

    public final HashMap<Integer, ArrayList<Double>> getSummaryStatsBucket(int primBucketOrd) {
        if (primBucketOrd >= this.summaryStatsBucketList.size()) {
            return null;
        }
        if (primBucketOrd == -1) {
            return this.nullSummaryStatsBucket;
        }
        return this.summaryStatsBucketList.get(primBucketOrd);
    }

    public void collectSummaryStatsBucket(int primBucketOrd, int otherBucketOrd, int statsFieldIndex, StatsType statsType, Double val) throws IOException {
        this.growSummaryStatsBucket(primBucketOrd + 1);
        this.collectExistingSummaryStatsBucket(primBucketOrd, otherBucketOrd, statsFieldIndex, statsType, val);
    }

    public void collectExistingSummaryStatsBucket(int primBucketOrd, int otherBucketOrd, int statsFieldIndex, StatsType statsType, Double val) throws IOException {
        this.collectExistingBucket(primBucketOrd);
        if (primBucketOrd >= this.summaryStatsBucketList.size()) {
            throw new IOException("Accessing summary bucket beyond size! bucketOrd : " + primBucketOrd + ", summaryStatsBucketList.size() : " + this.summaryStatsBucketList.size());
        }
        if (val != null) {
            ArrayList<Object> statsValueList;
            HashMap<Integer, ArrayList<Double>> existMap = this.summaryStatsBucketList.get(primBucketOrd);
            if (existMap.containsKey(otherBucketOrd)) {
                statsValueList = existMap.get(otherBucketOrd);
                if (statsFieldIndex < statsValueList.size()) {
                    if (statsType == StatsType.MIN) {
                        statsValueList.set(statsFieldIndex, Math.min((Double)statsValueList.get(statsFieldIndex), val));
                    } else if (statsType == StatsType.MAX) {
                        statsValueList.set(statsFieldIndex, Math.max((Double)statsValueList.get(statsFieldIndex), val));
                    } else if (statsType == StatsType.SUM) {
                        statsValueList.set(statsFieldIndex, (Double)statsValueList.get(statsFieldIndex) + val);
                    }
                } else {
                    statsValueList.add(val);
                }
            } else {
                statsValueList = new ArrayList<Double>();
                statsValueList.add(val);
            }
            existMap.put(otherBucketOrd, statsValueList);
        }
    }

    public void collectNullSummaryStatsBucket(int otherBucketOrd, int statsFieldIndex, StatsType statsType, Double val) throws IOException {
        this.collectNullBucket();
        if (val != null) {
            ArrayList<Object> statsValueList;
            HashMap<Integer, ArrayList<Double>> existMap = this.nullSummaryStatsBucket;
            if (existMap.containsKey(otherBucketOrd)) {
                statsValueList = existMap.get(otherBucketOrd);
                if (statsFieldIndex < statsValueList.size()) {
                    if (statsType == StatsType.MIN) {
                        statsValueList.set(statsFieldIndex, Math.min((Double)statsValueList.get(statsFieldIndex), val));
                    } else if (statsType == StatsType.MAX) {
                        statsValueList.set(statsFieldIndex, Math.max((Double)statsValueList.get(statsFieldIndex), val));
                    } else if (statsType == StatsType.SUM) {
                        statsValueList.set(statsFieldIndex, (Double)statsValueList.get(statsFieldIndex) + val);
                    }
                } else {
                    statsValueList.add(val);
                }
            } else {
                statsValueList = new ArrayList<Double>();
                statsValueList.add(val);
            }
            existMap.put(otherBucketOrd, statsValueList);
        }
    }
}

