/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DateHistogram
extends BucketAggregation<DateHistogram, Bucket> {
    public DateHistogram(long id, AggregationType aggregationType, long totalBucketCount, long totalHitCount, long otherDocCount, List<Bucket> buckets, Map<String, Object> metaData) {
        super(id, aggregationType, totalBucketCount, totalHitCount, otherDocCount, buckets, metaData);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        List<Bucket> res = this.getBuckets();
        JSONArray jResultArr = new JSONArray();
        JSONArray jColValueArr = null;
        for (Bucket buck : res) {
            jColValueArr = new JSONArray();
            jColValueArr.put(buck.getKey());
            jColValueArr.put(buck.getDocCount());
            jResultArr.put((Object)jColValueArr);
        }
        JSONObject jAggrResult = new JSONObject();
        jAggrResult.put("date_histogram", (Object)jResultArr);
        jAggrResult.put("total_groups", this.totalBucketCount);
        return jAggrResult;
    }

    public static class Bucket
    extends BucketAggregation.Bucket<Bucket> {
        final Long key;
        final Long docCount;

        public Bucket(Long key, Long docCount) {
            this.key = key;
            this.docCount = docCount;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public int compare(Bucket other) {
            return this.key == null && other.key == null ? 0 : (this.key == null ? -1 : (other.key == null ? 1 : this.key.compareTo(other.key)));
        }
    }
}

