/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram;

import com.manageengine.dataengine.commons.utils.DateTimeUnit;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram.DateHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.CollectionUtil;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;

public class DateHistogramAggregator
extends Aggregator {
    private ValuesSource.Numeric valuesSource;
    private HashMap<Long, Long> bucketMap;
    private DateTimeUnit unit;
    private DateTimeField field;
    private DateTimeZone timeZone;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public DateHistogramAggregator(ValuesSource.Numeric valuesSource, SearchContext context, DateTimeUnit unit, DateTimeZone timeZone, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.bucketMap = new HashMap();
        this.unit = unit;
        this.field = unit.field(timeZone);
        this.timeZone = timeZone;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final FieldDocValues docValues = this.valuesSource.longValues(ctx);
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){

                @Override
                public void collect(int doc) throws IOException {
                    if (DateHistogramAggregator.this.isValidTime(filterDocValues, doc)) {
                        Long value = (Long)docValues.get(doc);
                        if (value != null) {
                            long roundedValue = DateHistogramAggregator.this.field.roundFloor(value * 1000L);
                            if (DateHistogramAggregator.this.bucketMap.containsKey(roundedValue)) {
                                DateHistogramAggregator.this.bucketMap.put(roundedValue, (Long)DateHistogramAggregator.this.bucketMap.get(roundedValue) + 1L);
                            } else {
                                DateHistogramAggregator.this.bucketMap.put(roundedValue, 1L);
                            }
                        }
                        DateHistogramAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){

            @Override
            public void collect(int doc) throws IOException {
                Long value = (Long)docValues.get(doc);
                if (value != null) {
                    long roundedValue = DateHistogramAggregator.this.field.roundFloor(value * 1000L);
                    if (DateHistogramAggregator.this.bucketMap.containsKey(roundedValue)) {
                        DateHistogramAggregator.this.bucketMap.put(roundedValue, (Long)DateHistogramAggregator.this.bucketMap.get(roundedValue) + 1L);
                    } else {
                        DateHistogramAggregator.this.bucketMap.put(roundedValue, 1L);
                    }
                }
                DateHistogramAggregator.this.totalHitCount++;
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.bucketMap == null || this.bucketMap.isEmpty()) {
            return new DateHistogram(this.id(), this.aggregationType(), 0L, this.totalHitCount, 0L, (List<DateHistogram.Bucket>)new ArrayList<DateHistogram.Bucket>(), this.metaData());
        }
        this.totalBucketCount = this.bucketMap.size();
        ArrayList<DateHistogram.Bucket> buckets = new ArrayList<DateHistogram.Bucket>((int)this.totalBucketCount);
        for (Long key : this.bucketMap.keySet()) {
            buckets.add(new DateHistogram.Bucket(key, this.bucketMap.get(key)));
        }
        CollectionUtil.introSort(buckets, AggregationSortOrder.TERM_ASC.comparator(this));
        return new DateHistogram(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, 0L, (List<DateHistogram.Bucket>)buckets, this.metaData());
    }
}

