/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DoubleTerms
extends AggTerms<DoubleTerms, Bucket> {
    public DoubleTerms(long id, AggregationType aggregationType, long totalGroupCount, long totalHitCount, List<Bucket> buckets, Map<String, Object> metaData) {
        super(id, aggregationType, totalGroupCount, totalHitCount, 0L, buckets, metaData);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        List<Bucket> res = this.getBuckets();
        JSONArray jResultArr = new JSONArray();
        JSONArray jColValueArr = null;
        boolean statsFieldHasFloatingPoint = false;
        for (Bucket buck : res) {
            jColValueArr = new JSONArray();
            jColValueArr.put((Object)buck.getTerm());
            jColValueArr.put(buck.getDocCount());
            if (this.aggregationType() == AggregationType.DOUBLE_TERMS_STATS_AGGREGATION) {
                ArrayList<Double> statsTemp = buck.getStatsArr();
                ArrayList statFieldsDataType = (ArrayList)this.metaData().get("stats_field_data_type");
                for (int i = 0; i < statsTemp.size(); ++i) {
                    if (statsTemp.get(i) == Double.NEGATIVE_INFINITY || statsTemp.get(i) == Double.POSITIVE_INFINITY) {
                        jColValueArr.put((Object)"");
                        continue;
                    }
                    statsFieldHasFloatingPoint = ((DRFieldDataType)statFieldsDataType.get(i)).hasFloatingPoint();
                    jColValueArr.put((Object)(statsFieldHasFloatingPoint ? BigDecimal.valueOf(statsTemp.get(i)).toPlainString() : BigDecimal.valueOf(statsTemp.get(i)).setScale(0).toPlainString()));
                }
            }
            jResultArr.put((Object)jColValueArr);
        }
        JSONObject jAggrResult = new JSONObject();
        jAggrResult.put("terms", (Object)jResultArr);
        jAggrResult.put("total_groups", this.totalBucketCount);
        return jAggrResult;
    }

    public static class Bucket
    extends AggTerms.Bucket<Bucket> {
        Double term;

        public Bucket(Double term) {
            this.term = term;
        }

        public Bucket(Double term, Long count) {
            this.term = term;
            this.docCount = count;
        }

        public Double getTerm() {
            return this.term;
        }

        @Override
        public int compare(Bucket other) {
            return this.term == null && other.getTerm() == null ? 0 : (this.term == null ? -1 : (other.getTerm() == null ? 1 : Double.compare(this.term, other.getTerm())));
        }
    }
}

