/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsStatsGenericAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.DoubleTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;

public class DoubleTermsStatsAggregator
extends BucketsStatsGenericAggregator<Double> {
    private ValuesSource.Numeric valuesSource;
    private List<ValuesSource.Numeric> statsValuesSource;
    private List<StatsType> statsType;
    private long totalGroupCount = 0L;
    private long totalHitCount = 0L;

    public DoubleTermsStatsAggregator(ValuesSource.Numeric valuesSource, List<ValuesSource.Numeric> statsValuesSource, List<StatsType> statsType, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData, statsType.size());
        this.valuesSource = valuesSource;
        this.statsValuesSource = statsValuesSource;
        this.statsType = statsType;
        this.totalGroupCount = 0L;
        this.totalHitCount = 0L;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final FieldDocValues docValues = this.valuesSource.doubleValues(ctx);
        final ArrayList<FieldDocValues> statDocValues = new ArrayList<FieldDocValues>();
        for (int i = 0; i < this.statsValuesSource.size(); ++i) {
            statDocValues.add(i, this.statsValuesSource.get(i).doubleValues(ctx));
        }
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){

                @Override
                public void collect(int doc) throws IOException {
                    if (DoubleTermsStatsAggregator.this.isValidTime(filterDocValues, doc)) {
                        Double value = (Double)docValues.get(doc);
                        for (int i = 0; i < DoubleTermsStatsAggregator.this.statsType.size(); ++i) {
                            Double statFieldValue = (Double)((FieldDocValues)statDocValues.get(i)).get(doc);
                            DoubleTermsStatsAggregator.this.collectStatsBucket(i, value, statFieldValue, (StatsType)DoubleTermsStatsAggregator.this.statsType.get(i));
                        }
                        DoubleTermsStatsAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){

            @Override
            public void collect(int doc) throws IOException {
                Double value = (Double)docValues.get(doc);
                for (int i = 0; i < DoubleTermsStatsAggregator.this.statsType.size(); ++i) {
                    Double statFieldValue = (Double)((FieldDocValues)statDocValues.get(i)).get(doc);
                    DoubleTermsStatsAggregator.this.collectStatsBucket(i, value, statFieldValue, (StatsType)DoubleTermsStatsAggregator.this.statsType.get(i));
                }
                DoubleTermsStatsAggregator.this.totalHitCount++;
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        if (this.getBuckets() == null || this.getBuckets().isEmpty()) {
            return new DoubleTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, new ArrayList<DoubleTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        this.totalGroupCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        DoubleTerms.Bucket spare = new DoubleTerms.Bucket(-1.0, 0L);
        int statslen = this.statsType.size();
        Iterator iterator = this.getBuckets().keySet().iterator();
        while (iterator.hasNext()) {
            Double key;
            spare.term = key = (Double)iterator.next();
            spare.docCount = this.getBucketDocCount(key) / (long)statslen;
            spare.statsArr = new ArrayList();
            for (int istats = 0; istats < statslen; ++istats) {
                spare.statsArr.add(this.getStatsBucketValue(istats, key, this.statsType.get(istats)));
            }
            if ((spare = (DoubleTerms.Bucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new DoubleTerms.Bucket(-1.0, 0L);
            }
            ++this.totalGroupCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        DoubleTerms.Bucket[] list = new DoubleTerms.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            DoubleTerms.Bucket bucket;
            list[listIndex] = bucket = (DoubleTerms.Bucket)ordered.pop();
            --listIndex;
        }
        return new DoubleTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, Arrays.asList(list), this.metaData());
    }
}

