/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsSummaryGenericAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.DoubleTermsSummary;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;

public class DoubleTermsSummaryAggregator
extends BucketsSummaryGenericAggregator<Double> {
    private final ValuesSource.Numeric primValuesSource;
    private ValuesSource.Bytes.MultiFieldData secValuesSource;
    private final BytesRefHash multiTermBucketOrds;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public DoubleTermsSummaryAggregator(ValuesSource.Numeric primValuesSource, ValuesSource.Bytes.MultiFieldData secValuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.primValuesSource = primValuesSource;
        this.secValuesSource = secValuesSource;
        this.multiTermBucketOrds = new BytesRefHash();
        this.totalHitCount = 0L;
        this.totalBucketCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final FieldDocValues primDocValues = this.primValuesSource.longValues(context);
        final MultiFieldDocValues multiTermDocValues = this.secValuesSource.docValues(context);
        multiTermDocValues.loadDocValues();
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){
                final BytesRefBuilder values;
                {
                    super(context);
                    this.values = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc) throws IOException {
                    if (DoubleTermsSummaryAggregator.this.isValidTime(filterDocValues, doc)) {
                        Double primOrdinal = (Double)primDocValues.get(doc);
                        this.values.copyChars((CharSequence)multiTermDocValues.getFieldValue(doc).toString());
                        BytesRef bytes = this.values.get();
                        int otherBucketOrdinal = DoubleTermsSummaryAggregator.this.multiTermBucketOrds.add(bytes);
                        if (otherBucketOrdinal < 0) {
                            otherBucketOrdinal = -1 - otherBucketOrdinal;
                        }
                        DoubleTermsSummaryAggregator.this.collectSummaryBucket(primOrdinal, otherBucketOrdinal);
                        DoubleTermsSummaryAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(context){
            final BytesRefBuilder values;
            {
                super(context);
                this.values = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc) throws IOException {
                Double primOrdinal = (Double)primDocValues.get(doc);
                this.values.copyChars((CharSequence)multiTermDocValues.getFieldValue(doc).toString());
                BytesRef bytes = this.values.get();
                int otherBucketOrdinal = DoubleTermsSummaryAggregator.this.multiTermBucketOrds.add(bytes);
                if (otherBucketOrdinal < 0) {
                    otherBucketOrdinal = -1 - otherBucketOrdinal;
                }
                DoubleTermsSummaryAggregator.this.collectSummaryBucket(primOrdinal, otherBucketOrdinal);
                DoubleTermsSummaryAggregator.this.totalHitCount++;
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.getBuckets() == null || this.getBuckets().isEmpty()) {
            return new DoubleTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, new ArrayList<DoubleTermsSummary.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        this.totalBucketCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        DoubleTermsSummary.Bucket spare = new DoubleTermsSummary.Bucket(-1.0, 0L, new ArrayList<StringTerms.Bucket>());
        Iterator iterator = this.getBuckets().keySet().iterator();
        while (iterator.hasNext()) {
            Double key;
            spare.term = key = (Double)iterator.next();
            spare.docCount = this.getBucketDocCount(key);
            if ((spare = (DoubleTermsSummary.Bucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new DoubleTermsSummary.Bucket(-1.0, 0L, new ArrayList<StringTerms.Bucket>());
            }
            ++this.totalBucketCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        DoubleTermsSummary.Bucket[] list = new DoubleTermsSummary.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            DoubleTermsSummary.Bucket bucket = (DoubleTermsSummary.Bucket)ordered.pop();
            HashMap<Integer, Integer> summaryBucketMap = this.getSummaryBucket(bucket.term);
            ArrayList<StringTerms.Bucket> stringTermsBuckets = new ArrayList<StringTerms.Bucket>(summaryBucketMap.size());
            for (Integer key : summaryBucketMap.keySet()) {
                StringTerms.Bucket stringTermsBucket = new StringTerms.Bucket(new BytesRef(), summaryBucketMap.get(key).intValue());
                this.multiTermBucketOrds.get(key.intValue(), stringTermsBucket.termBytes);
                stringTermsBucket.bucketOrd = key.intValue();
                stringTermsBuckets.add(stringTermsBucket);
            }
            CollectionUtil.introSort(stringTermsBuckets, AggregationSortOrder.TERM_ASC.comparator(this));
            bucket.stringTermsBuckets = stringTermsBuckets;
            list[listIndex] = bucket;
            list[listIndex].bucketOrd = bucket.bucketOrd;
            --listIndex;
        }
        return new DoubleTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, Arrays.asList(list), this.metaData());
    }
}

