/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public class GlobalOrdinalsStringTermsAggregator
extends BucketsAggregator {
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private SortedDocValues globalOrds;
    private long totalHitCount;
    private long totalGroupCount = 0L;

    public GlobalOrdinalsStringTermsAggregator(ValuesSource.Bytes.WithOrdinals valuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.totalHitCount = 0L;
        this.totalGroupCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        this.globalOrds = this.valuesSource.globalOrdinalsValues(context);
        this.growBucket(this.globalOrds.getValueCount());
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){

                @Override
                public void collect(int doc) throws IOException {
                    if (GlobalOrdinalsStringTermsAggregator.this.isValidTime(filterDocValues, doc)) {
                        int ord = -1;
                        if (GlobalOrdinalsStringTermsAggregator.this.globalOrds.advanceExact(doc)) {
                            ord = GlobalOrdinalsStringTermsAggregator.this.globalOrds.ordValue();
                        }
                        if (ord >= 0) {
                            GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(ord);
                        } else {
                            GlobalOrdinalsStringTermsAggregator.this.collectNullBucket();
                        }
                        GlobalOrdinalsStringTermsAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(context){

            @Override
            public void collect(int doc) throws IOException {
                int ord = -1;
                if (GlobalOrdinalsStringTermsAggregator.this.globalOrds.advanceExact(doc)) {
                    ord = GlobalOrdinalsStringTermsAggregator.this.globalOrds.ordValue();
                }
                if (ord >= 0) {
                    GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(ord);
                } else {
                    GlobalOrdinalsStringTermsAggregator.this.collectNullBucket();
                }
                GlobalOrdinalsStringTermsAggregator.this.totalHitCount++;
            }
        };
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.globalOrds == null) {
            return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, 0L, (List<StringTerms.Bucket>)new ArrayList<StringTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalGroupCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        OrdBucket spare = new OrdBucket(-1L, 0L);
        for (long globalTermOrd = 0L; globalTermOrd < (long)this.globalOrds.getValueCount(); ++globalTermOrd) {
            long bucketDocCount;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            long l = bucketDocCount = bucketOrd < 0L ? 0L : this.getBucketDocCount((int)bucketOrd);
            if (bucketDocCount == 0L) continue;
            spare.globalOrd = globalTermOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            otherDocCount += bucketDocCount;
            if ((spare = (OrdBucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new OrdBucket(-1L, 0L);
            }
            ++this.totalGroupCount;
        }
        if (this.getNullBucketDocCount() != 0L) {
            spare = new OrdBucket(-1L, 0L);
            spare.globalOrd = -1L;
            spare.bucketOrd = -1L;
            spare.docCount = this.getNullBucketDocCount();
            spare = (OrdBucket)ordered.insertWithOverflow(spare);
            ++this.totalGroupCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTerms.Bucket[] list = new StringTerms.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            OrdBucket bucket = (OrdBucket)ordered.pop();
            BytesRef scratch = new BytesRef();
            if (bucket.globalOrd == -1L) {
                scratch = null;
            } else {
                GlobalOrdinalsStringTermsAggregator.copy(this.globalOrds.lookupOrd((int)bucket.globalOrd), scratch);
            }
            list[listIndex] = new StringTerms.Bucket(scratch, bucket.docCount);
            list[listIndex].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[listIndex].docCount;
            --listIndex;
        }
        return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }

    public boolean needsScores() {
        return false;
    }

    static class OrdBucket
    extends AggTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount) {
            this.globalOrd = globalOrd;
        }

        @Override
        public int compare(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }
    }
}

