/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.DateTimeUnit;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsHistogramAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram.DateHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTermsHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;

public class GlobalOrdinalsStringTermsDHAggregator
extends BucketsHistogramAggregator {
    protected final ValuesSource.Bytes.WithOrdinals valuesSource;
    private ValuesSource.Numeric dateValuesSource;
    protected SortedDocValues globalOrds;
    private DateTimeUnit unit;
    private DateTimeField field;
    private DateTimeZone timeZone;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public GlobalOrdinalsStringTermsDHAggregator(ValuesSource.Bytes.WithOrdinals valuesSource, ValuesSource.Numeric dateValuesSource, SearchContext context, DateTimeUnit unit, DateTimeZone timeZone, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.dateValuesSource = dateValuesSource;
        this.unit = unit;
        this.field = unit.field(timeZone);
        this.timeZone = timeZone;
        this.totalHitCount = 0L;
        this.totalBucketCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        this.globalOrds = this.valuesSource.globalOrdinalsValues(context);
        this.growHistogramBucket(this.globalOrds.getValueCount());
        final FieldDocValues dateDocValues = this.dateValuesSource.longValues(context);
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){

                @Override
                public void collect(int doc) throws IOException {
                    if (GlobalOrdinalsStringTermsDHAggregator.this.isValidTime(filterDocValues, doc)) {
                        int ord = -1;
                        if (GlobalOrdinalsStringTermsDHAggregator.this.globalOrds.advanceExact(doc)) {
                            ord = GlobalOrdinalsStringTermsDHAggregator.this.globalOrds.ordValue();
                        }
                        Long dateValue = (Long)dateDocValues.get(doc);
                        if (ord >= 0) {
                            GlobalOrdinalsStringTermsDHAggregator.this.collectExistingHistogramBucket(ord, GlobalOrdinalsStringTermsDHAggregator.this.field, dateValue);
                        } else {
                            GlobalOrdinalsStringTermsDHAggregator.this.collectNullHistogramBucket(GlobalOrdinalsStringTermsDHAggregator.this.field, dateValue);
                        }
                        GlobalOrdinalsStringTermsDHAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(context){

            @Override
            public void collect(int doc) throws IOException {
                int ord = -1;
                if (GlobalOrdinalsStringTermsDHAggregator.this.globalOrds.advanceExact(doc)) {
                    ord = GlobalOrdinalsStringTermsDHAggregator.this.globalOrds.ordValue();
                }
                Long dateValue = (Long)dateDocValues.get(doc);
                if (ord >= 0) {
                    GlobalOrdinalsStringTermsDHAggregator.this.collectExistingHistogramBucket(ord, GlobalOrdinalsStringTermsDHAggregator.this.field, dateValue);
                } else {
                    GlobalOrdinalsStringTermsDHAggregator.this.collectNullHistogramBucket(GlobalOrdinalsStringTermsDHAggregator.this.field, dateValue);
                }
                GlobalOrdinalsStringTermsDHAggregator.this.totalHitCount++;
            }
        };
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.globalOrds == null) {
            return new StringTermsHistogram(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, 0L, (List<StringTermsHistogram.Bucket>)new ArrayList<StringTermsHistogram.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalBucketCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        OrdBucket spare = new OrdBucket(-1L, 0L);
        for (long globalTermOrd = 0L; globalTermOrd < (long)this.globalOrds.getValueCount(); ++globalTermOrd) {
            long bucketDocCount;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            long l = bucketDocCount = bucketOrd < 0L ? 0L : this.getBucketDocCount((int)bucketOrd);
            if (bucketDocCount == 0L) continue;
            spare.globalOrd = globalTermOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            ++this.totalBucketCount;
            otherDocCount += bucketDocCount;
            if ((spare = (OrdBucket)ordered.insertWithOverflow(spare)) != null) continue;
            spare = new OrdBucket(-1L, 0L);
        }
        if (this.getNullBucketDocCount() != 0L) {
            spare = new OrdBucket(-1L, 0L);
            spare.globalOrd = -1L;
            spare.bucketOrd = -1L;
            spare.docCount = this.getNullBucketDocCount();
            spare = (OrdBucket)ordered.insertWithOverflow(spare);
            ++this.totalBucketCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTermsHistogram.Bucket[] list = new StringTermsHistogram.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            OrdBucket bucket = (OrdBucket)ordered.pop();
            BytesRef scratch = new BytesRef();
            if (bucket.globalOrd == -1L) {
                scratch = null;
            } else {
                GlobalOrdinalsStringTermsDHAggregator.copy(this.globalOrds.lookupOrd((int)bucket.globalOrd), scratch);
            }
            HashMap<Long, Long> termBucketMap = this.getHistogramBucket((int)bucket.globalOrd);
            long totalTermBucketCount = termBucketMap.size();
            ArrayList<DateHistogram.Bucket> histogramBuckets = new ArrayList<DateHistogram.Bucket>((int)totalTermBucketCount);
            for (Long key : termBucketMap.keySet()) {
                histogramBuckets.add(new DateHistogram.Bucket(key, termBucketMap.get(key)));
            }
            CollectionUtil.introSort(histogramBuckets, AggregationSortOrder.TERM_ASC.comparator(this));
            list[listIndex] = new StringTermsHistogram.Bucket(scratch, bucket.docCount, histogramBuckets);
            list[listIndex].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[listIndex].docCount;
            --listIndex;
        }
        return new StringTermsHistogram(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }

    public boolean needsScores() {
        return false;
    }

    static class OrdBucket
    extends AggTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount) {
            this.globalOrd = globalOrd;
        }

        @Override
        public int compare(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }
    }
}

