/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public class GlobalOrdinalsStringTermsStatsAggregator
extends BucketsStatsAggregator {
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private SortedDocValues globalOrds;
    private List<ValuesSource.Numeric> statsValuesSource;
    private List<StatsType> statsType;
    private long totalHitCount;
    private long totalGroupCount = 0L;

    public GlobalOrdinalsStringTermsStatsAggregator(ValuesSource.Bytes.WithOrdinals valuesSource, List<ValuesSource.Numeric> statsValuesSource, List<StatsType> statsType, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData, statsType.size());
        this.valuesSource = valuesSource;
        this.statsValuesSource = statsValuesSource;
        this.statsType = statsType;
        this.totalHitCount = 0L;
        this.totalGroupCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        this.globalOrds = this.valuesSource.globalOrdinalsValues(context);
        for (int i = 0; i < this.statsType.size(); ++i) {
            this.growStatsBucket(i, this.globalOrds.getValueCount(), this.statsType.get(i));
        }
        final ArrayList<FieldDocValues> statDocValues = new ArrayList<FieldDocValues>();
        for (int i = 0; i < this.statsValuesSource.size(); ++i) {
            statDocValues.add(i, this.statsValuesSource.get(i).doubleValues(context));
        }
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){

                @Override
                public void collect(int doc) throws IOException {
                    if (GlobalOrdinalsStringTermsStatsAggregator.this.isValidTime(filterDocValues, doc)) {
                        GlobalOrdinalsStringTermsStatsAggregator.this.collectStatsArray(statDocValues, doc);
                    }
                }
            };
        }
        return new LeafBucketCollector(context){

            @Override
            public void collect(int doc) throws IOException {
                GlobalOrdinalsStringTermsStatsAggregator.this.collectStatsArray(statDocValues, doc);
            }
        };
    }

    public void collectStatsArray(ArrayList<FieldDocValues> statDocValues, int doc) throws IOException {
        int ord = -1;
        for (int i = 0; i < statDocValues.size(); ++i) {
            Double statFieldValue = (Double)statDocValues.get(i).get(doc);
            if (this.globalOrds.advanceExact(doc)) {
                ord = this.globalOrds.ordValue();
            }
            if (ord >= 0) {
                this.collectExistingStatsBucket(i, ord, this.statsType.get(i), statFieldValue);
                continue;
            }
            this.collectNullStatsBucket(i, this.statsType.get(i), statFieldValue);
        }
        ++this.totalHitCount;
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.globalOrds == null) {
            return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, 0L, (List<StringTerms.Bucket>)new ArrayList<StringTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalGroupCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        OrdBucket spare = new OrdBucket(-1L, 0L);
        int statslen = this.statsType.size();
        for (long globalTermOrd = 0L; globalTermOrd < (long)this.globalOrds.getValueCount(); ++globalTermOrd) {
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            Long bucketDocCount = bucketOrd < 0L ? 0L : this.getBucketDocCount((int)bucketOrd);
            if (bucketDocCount == 0L) continue;
            spare.globalOrd = globalTermOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount / (long)statslen;
            spare.statsArr = new ArrayList();
            for (int istats = 0; istats < statslen; ++istats) {
                spare.statsArr.add(bucketOrd < 0L ? 0.0 : this.getStatsBucketValue(istats, (int)bucketOrd, this.statsType.get(istats)));
            }
            otherDocCount += spare.docCount;
            if ((spare = (OrdBucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new OrdBucket(-1L, 0L);
            }
            ++this.totalGroupCount;
        }
        if (this.getNullBucketDocCount() != 0L) {
            spare = new OrdBucket(-1L, 0L);
            spare.globalOrd = -1L;
            spare.bucketOrd = -1L;
            spare.docCount = this.getNullBucketDocCount() / (long)statslen;
            spare.statsArr = new ArrayList();
            for (int istats = 0; istats < statslen; ++istats) {
                spare.statsArr.add(this.getNullStatsBucketValue(istats, this.statsType.get(istats)));
            }
            spare = (OrdBucket)ordered.insertWithOverflow(spare);
            ++this.totalGroupCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTerms.Bucket[] list = new StringTerms.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            OrdBucket bucket = (OrdBucket)ordered.pop();
            BytesRef scratch = new BytesRef();
            if (bucket.globalOrd == -1L) {
                scratch = null;
            } else {
                GlobalOrdinalsStringTermsStatsAggregator.copy(this.globalOrds.lookupOrd((int)bucket.globalOrd), scratch);
            }
            list[listIndex] = new StringTerms.Bucket(scratch, bucket.docCount);
            list[listIndex].statsArr = bucket.getStatsArr();
            list[listIndex].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[listIndex].docCount;
            --listIndex;
        }
        return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }

    public boolean needsScores() {
        return false;
    }

    static class OrdBucket
    extends AggTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount) {
            this.globalOrd = globalOrd;
        }

        @Override
        public int compare(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }
    }
}

