/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsSummaryAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTermsSummary;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;

public class GlobalOrdinalsStringTermsSummaryAggregator
extends BucketsSummaryAggregator {
    private final ValuesSource.Bytes.WithOrdinals primeValuesSource;
    private ValuesSource.Bytes.MultiFieldData secValuesSource;
    private SortedDocValues globalOrds;
    private final BytesRefHash multiTermBucketOrds;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public GlobalOrdinalsStringTermsSummaryAggregator(ValuesSource.Bytes.WithOrdinals primeValuesSource, ValuesSource.Bytes.MultiFieldData secValuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.primeValuesSource = primeValuesSource;
        this.secValuesSource = secValuesSource;
        this.multiTermBucketOrds = new BytesRefHash();
        this.totalHitCount = 0L;
        this.totalBucketCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        this.globalOrds = this.primeValuesSource.globalOrdinalsValues(context);
        this.growSummaryBucket(this.globalOrds.getValueCount());
        final MultiFieldDocValues multiTermDocValues = this.secValuesSource.docValues(context);
        multiTermDocValues.loadDocValues();
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){
                final BytesRefBuilder values;
                {
                    super(context);
                    this.values = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc) throws IOException {
                    if (GlobalOrdinalsStringTermsSummaryAggregator.this.isValidTime(filterDocValues, doc)) {
                        int primOrdinal = -1;
                        if (GlobalOrdinalsStringTermsSummaryAggregator.this.globalOrds.advanceExact(doc)) {
                            primOrdinal = GlobalOrdinalsStringTermsSummaryAggregator.this.globalOrds.ordValue();
                        }
                        this.values.copyChars((CharSequence)multiTermDocValues.getFieldValue(doc).toString());
                        BytesRef bytes = this.values.get();
                        int otherBucketOrdinal = GlobalOrdinalsStringTermsSummaryAggregator.this.multiTermBucketOrds.add(bytes);
                        if (otherBucketOrdinal < 0) {
                            otherBucketOrdinal = -1 - otherBucketOrdinal;
                        }
                        if (primOrdinal >= 0) {
                            GlobalOrdinalsStringTermsSummaryAggregator.this.collectExistingSummaryBucket(primOrdinal, otherBucketOrdinal);
                        } else {
                            GlobalOrdinalsStringTermsSummaryAggregator.this.collectNullSummaryBucket(otherBucketOrdinal);
                        }
                        GlobalOrdinalsStringTermsSummaryAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(context){
            final BytesRefBuilder values;
            {
                super(context);
                this.values = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc) throws IOException {
                int primOrdinal = -1;
                if (GlobalOrdinalsStringTermsSummaryAggregator.this.globalOrds.advanceExact(doc)) {
                    primOrdinal = GlobalOrdinalsStringTermsSummaryAggregator.this.globalOrds.ordValue();
                }
                this.values.copyChars((CharSequence)multiTermDocValues.getFieldValue(doc).toString());
                BytesRef bytes = this.values.get();
                int otherBucketOrdinal = GlobalOrdinalsStringTermsSummaryAggregator.this.multiTermBucketOrds.add(bytes);
                if (otherBucketOrdinal < 0) {
                    otherBucketOrdinal = -1 - otherBucketOrdinal;
                }
                if (primOrdinal >= 0) {
                    GlobalOrdinalsStringTermsSummaryAggregator.this.collectExistingSummaryBucket(primOrdinal, otherBucketOrdinal);
                } else {
                    GlobalOrdinalsStringTermsSummaryAggregator.this.collectNullSummaryBucket(otherBucketOrdinal);
                }
                GlobalOrdinalsStringTermsSummaryAggregator.this.totalHitCount++;
            }
        };
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.globalOrds == null) {
            return new StringTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, 0L, (List<StringTermsSummary.Bucket>)new ArrayList<StringTermsSummary.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalBucketCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        OrdBucket spare = new OrdBucket(-1L, 0L);
        for (long globalTermOrd = 0L; globalTermOrd < (long)this.globalOrds.getValueCount(); ++globalTermOrd) {
            long bucketDocCount;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            long l = bucketDocCount = bucketOrd < 0L ? 0L : this.getBucketDocCount((int)bucketOrd);
            if (bucketDocCount == 0L) continue;
            spare.globalOrd = globalTermOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            otherDocCount += bucketDocCount;
            if ((spare = (OrdBucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new OrdBucket(-1L, 0L);
            }
            ++this.totalBucketCount;
        }
        if (this.getNullBucketDocCount() != 0L) {
            spare = new OrdBucket(-1L, 0L);
            spare.globalOrd = -1L;
            spare.bucketOrd = -1L;
            spare.docCount = this.getNullBucketDocCount();
            spare = (OrdBucket)ordered.insertWithOverflow(spare);
            otherDocCount += this.getNullBucketDocCount();
            ++this.totalBucketCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTermsSummary.Bucket[] list = new StringTermsSummary.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            OrdBucket bucket = (OrdBucket)ordered.pop();
            BytesRef scratch = new BytesRef();
            if (bucket.globalOrd == -1L) {
                scratch = null;
            } else {
                GlobalOrdinalsStringTermsSummaryAggregator.copy(this.globalOrds.lookupOrd((int)bucket.globalOrd), scratch);
            }
            HashMap<Integer, Integer> termBucketMap = this.getSummaryBucket((int)bucket.globalOrd);
            long totalTermBucketCount = termBucketMap.size();
            ArrayList<StringTerms.Bucket> stringTermsBuckets = new ArrayList<StringTerms.Bucket>((int)totalTermBucketCount);
            for (Integer key : termBucketMap.keySet()) {
                StringTerms.Bucket stringTermsBucket = new StringTerms.Bucket(new BytesRef(), termBucketMap.get(key).intValue());
                this.multiTermBucketOrds.get(key.intValue(), stringTermsBucket.termBytes);
                stringTermsBucket.bucketOrd = key.intValue();
                stringTermsBuckets.add(stringTermsBucket);
            }
            CollectionUtil.introSort(stringTermsBuckets, AggregationSortOrder.TERM_ASC.comparator(this));
            list[listIndex] = new StringTermsSummary.Bucket(scratch, bucket.docCount, stringTermsBuckets);
            list[listIndex].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[listIndex].docCount;
            --listIndex;
        }
        return new StringTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }

    public boolean needsScores() {
        return false;
    }

    static class OrdBucket
    extends AggTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount) {
            this.globalOrd = globalOrd;
        }

        @Override
        public int compare(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }
    }
}

