/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsGenericAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;

public class LongTermsAggregator
extends BucketsGenericAggregator<Long> {
    private ValuesSource.Numeric valuesSource;
    private long totalGroupCount = 0L;
    private long totalHitCount = 0L;

    public LongTermsAggregator(ValuesSource.Numeric valuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.totalGroupCount = 0L;
        this.totalHitCount = 0L;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final FieldDocValues docValues = this.valuesSource.longValues(ctx);
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){

                @Override
                public void collect(int doc) throws IOException {
                    if (LongTermsAggregator.this.isValidTime(filterDocValues, doc)) {
                        Long value = (Long)docValues.get(doc);
                        LongTermsAggregator.this.collectBucket(value);
                        LongTermsAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){

            @Override
            public void collect(int doc) throws IOException {
                Long value = (Long)docValues.get(doc);
                LongTermsAggregator.this.collectBucket(value);
                LongTermsAggregator.this.totalHitCount++;
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        if (this.getBuckets() == null || this.getBuckets().isEmpty()) {
            return new LongTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, new ArrayList<LongTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        this.totalGroupCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        LongTerms.Bucket spare = new LongTerms.Bucket(null, 0L);
        Iterator iterator = this.getBuckets().keySet().iterator();
        while (iterator.hasNext()) {
            Long key;
            spare.term = key = (Long)iterator.next();
            spare.docCount = this.getBuckets().get(key);
            spare.bucketOrd = key;
            if ((spare = (LongTerms.Bucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new LongTerms.Bucket(null, 0L);
            }
            ++this.totalGroupCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        LongTerms.Bucket[] list = new LongTerms.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            LongTerms.Bucket bucket;
            list[listIndex] = bucket = (LongTerms.Bucket)ordered.pop();
            --listIndex;
        }
        return new LongTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, Arrays.asList(list), this.metaData());
    }
}

