/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram.DateHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LongTermsHistogram
extends AggTerms<LongTermsHistogram, Bucket> {
    public LongTermsHistogram(long id, AggregationType aggregationType, long totalBucketCount, long totalHitCount, List<Bucket> buckets, Map<String, Object> metaData) {
        super(id, aggregationType, totalBucketCount, totalHitCount, 0L, buckets, metaData);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        List<Bucket> res = this.getBuckets();
        JSONArray jResultArr = new JSONArray();
        for (Bucket buck : res) {
            JSONObject recordObj = new JSONObject();
            recordObj.put("term", (Object)buck.getTerm());
            recordObj.put("count", buck.getDocCount());
            List<DateHistogram.Bucket> histogramBuckets = buck.histogramBuckets;
            JSONArray jHistogramArr = new JSONArray();
            for (DateHistogram.Bucket histogramBucket : histogramBuckets) {
                JSONArray jColValueArr = new JSONArray();
                jColValueArr.put(histogramBucket.getKey());
                jColValueArr.put(histogramBucket.getDocCount());
                jHistogramArr.put((Object)jColValueArr);
            }
            recordObj.put("histogram", (Object)jHistogramArr);
            jResultArr.put((Object)recordObj);
        }
        JSONObject jAggrResult = new JSONObject();
        jAggrResult.put("terms", (Object)jResultArr);
        jAggrResult.put("total_groups", this.totalBucketCount);
        return jAggrResult;
    }

    public static class Bucket
    extends AggTerms.Bucket<Bucket> {
        Long term;
        List<DateHistogram.Bucket> histogramBuckets;

        public Bucket(Long term, long count, List<DateHistogram.Bucket> histogramBuckets) {
            this.term = term;
            this.docCount = count;
            this.histogramBuckets = histogramBuckets;
        }

        public Long getTerm() {
            return this.term;
        }

        @Override
        public int compare(Bucket other) {
            return this.term == null && other.getTerm() == null ? 0 : (this.term == null ? -1 : (other.getTerm() == null ? 1 : Long.compare(this.term, other.getTerm())));
        }
    }
}

