/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.DateTimeUnit;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsHistogramGenericAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram.DateHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTermsHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.CollectionUtil;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;

public class LongTermsHistogramAggregator
extends BucketsHistogramGenericAggregator<Long> {
    private final ValuesSource.Numeric valuesSource;
    private final ValuesSource.Numeric dateValuesSource;
    private DateTimeUnit unit;
    private DateTimeField field;
    private DateTimeZone timeZone;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public LongTermsHistogramAggregator(ValuesSource.Numeric valuesSource, ValuesSource.Numeric dateValuesSource, SearchContext context, DateTimeUnit unit, DateTimeZone timeZone, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.dateValuesSource = dateValuesSource;
        this.unit = unit;
        this.field = unit.field(timeZone);
        this.timeZone = timeZone;
        this.totalHitCount = 0L;
        this.totalBucketCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final FieldDocValues docValues = this.valuesSource.longValues(context);
        final FieldDocValues dateDocValues = this.dateValuesSource.longValues(context);
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){

                @Override
                public void collect(int doc) throws IOException {
                    if (LongTermsHistogramAggregator.this.isValidTime(filterDocValues, doc)) {
                        Long value = (Long)docValues.get(doc);
                        Long dateValue = (Long)dateDocValues.get(doc);
                        LongTermsHistogramAggregator.this.collectHistogramBucket(value, LongTermsHistogramAggregator.this.field, dateValue);
                        LongTermsHistogramAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(context){

            @Override
            public void collect(int doc) throws IOException {
                Long value = (Long)docValues.get(doc);
                Long dateValue = (Long)dateDocValues.get(doc);
                LongTermsHistogramAggregator.this.collectHistogramBucket(value, LongTermsHistogramAggregator.this.field, dateValue);
                LongTermsHistogramAggregator.this.totalHitCount++;
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.getBuckets() == null || this.getBuckets().isEmpty()) {
            return new LongTerms(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, new ArrayList<LongTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        this.totalBucketCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        LongTermsHistogram.Bucket spare = new LongTermsHistogram.Bucket(-1L, 0L, new ArrayList<DateHistogram.Bucket>());
        Iterator iterator = this.getBuckets().keySet().iterator();
        while (iterator.hasNext()) {
            Long key;
            spare.term = key = (Long)iterator.next();
            spare.docCount = this.getBucketDocCount(key);
            spare.bucketOrd = key;
            if ((spare = (LongTermsHistogram.Bucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new LongTermsHistogram.Bucket(-1L, 0L, new ArrayList<DateHistogram.Bucket>());
            }
            ++this.totalBucketCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        LongTermsHistogram.Bucket[] list = new LongTermsHistogram.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            LongTermsHistogram.Bucket bucket = (LongTermsHistogram.Bucket)ordered.pop();
            HashMap<Long, Long> termHistogramBucketMap = this.getHistogramBucket(bucket.term);
            ArrayList<DateHistogram.Bucket> histogramBuckets = new ArrayList<DateHistogram.Bucket>(termHistogramBucketMap.size());
            for (Long key : termHistogramBucketMap.keySet()) {
                histogramBuckets.add(new DateHistogram.Bucket(key, termHistogramBucketMap.get(key)));
            }
            CollectionUtil.introSort(histogramBuckets, AggregationSortOrder.TERM_ASC.comparator(this));
            bucket.histogramBuckets = histogramBuckets;
            list[listIndex] = bucket;
            --listIndex;
        }
        return new LongTermsHistogram(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, Arrays.asList(list), this.metaData());
    }
}

