/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsStatsGenericAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.LongTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;

public class LongTermsStatsAggregator
extends BucketsStatsGenericAggregator<Long> {
    private ValuesSource.Numeric valuesSource;
    private List<ValuesSource.Numeric> statsValuesSource;
    private List<StatsType> statsType;
    private long totalGroupCount = 0L;
    private long totalHitCount = 0L;

    public LongTermsStatsAggregator(ValuesSource.Numeric valuesSource, List<ValuesSource.Numeric> statsValuesSource, List<StatsType> statsType, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData, statsType.size());
        this.valuesSource = valuesSource;
        this.statsValuesSource = statsValuesSource;
        this.statsType = statsType;
        this.totalGroupCount = 0L;
        this.totalHitCount = 0L;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final FieldDocValues docValues = this.valuesSource.longValues(ctx);
        final ArrayList<FieldDocValues> statDocValues = new ArrayList<FieldDocValues>();
        for (int i = 0; i < this.statsValuesSource.size(); ++i) {
            statDocValues.add(i, this.statsValuesSource.get(i).doubleValues(ctx));
        }
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){

                @Override
                public void collect(int doc) throws IOException {
                    if (LongTermsStatsAggregator.this.isValidTime(filterDocValues, doc)) {
                        Long value = (Long)docValues.get(doc);
                        for (int i = 0; i < LongTermsStatsAggregator.this.statsType.size(); ++i) {
                            Double statFieldValue = (Double)((FieldDocValues)statDocValues.get(i)).get(doc);
                            LongTermsStatsAggregator.this.collectStatsBucket(i, value, statFieldValue, (StatsType)LongTermsStatsAggregator.this.statsType.get(i));
                        }
                        LongTermsStatsAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){

            @Override
            public void collect(int doc) throws IOException {
                Long value = (Long)docValues.get(doc);
                for (int i = 0; i < LongTermsStatsAggregator.this.statsType.size(); ++i) {
                    Double statFieldValue = (Double)((FieldDocValues)statDocValues.get(i)).get(doc);
                    LongTermsStatsAggregator.this.collectStatsBucket(i, value, statFieldValue, (StatsType)LongTermsStatsAggregator.this.statsType.get(i));
                }
                LongTermsStatsAggregator.this.totalHitCount++;
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        if (this.getBuckets() == null || this.getBuckets().isEmpty()) {
            return new LongTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, new ArrayList<LongTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        this.totalGroupCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        LongTerms.Bucket spare = new LongTerms.Bucket(-1L, 0L);
        int statslen = this.statsType.size();
        Iterator iterator = this.getBuckets().keySet().iterator();
        while (iterator.hasNext()) {
            Long key;
            spare.term = key = (Long)iterator.next();
            spare.docCount = this.getBucketDocCount(key) / (long)statslen;
            spare.statsArr = new ArrayList();
            for (int istats = 0; istats < statslen; ++istats) {
                spare.statsArr.add(this.getStatsBucketValue(istats, key, this.statsType.get(istats)));
            }
            if ((spare = (LongTerms.Bucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new LongTerms.Bucket(-1L, 0L);
            }
            ++this.totalGroupCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        LongTerms.Bucket[] list = new LongTerms.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            LongTerms.Bucket bucket;
            list[listIndex] = bucket = (LongTerms.Bucket)ordered.pop();
            --listIndex;
        }
        return new LongTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, Arrays.asList(list), this.metaData());
    }
}

