/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LongTermsSummary
extends AggTerms<LongTermsSummary, Bucket> {
    public LongTermsSummary(long id, AggregationType aggregationType, long totalBucketCount, long totalHitCount, List<Bucket> buckets, Map<String, Object> metaData) {
        super(id, aggregationType, totalBucketCount, totalHitCount, 0L, buckets, metaData);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        List<Bucket> res = this.getBuckets();
        JSONArray jResultArr = new JSONArray();
        for (Bucket summaryBucket : res) {
            JSONObject recordObj = new JSONObject();
            recordObj.put("term", (Object)summaryBucket.getTerm());
            recordObj.put("count", summaryBucket.getDocCount());
            List<StringTerms.Bucket> stringTermsBuckets = summaryBucket.stringTermsBuckets;
            JSONArray jSubResultArr = new JSONArray();
            JSONArray jColValueArr = null;
            for (StringTerms.Bucket stringTermsBucket : stringTermsBuckets) {
                String[] fieldValues;
                String subValue = stringTermsBucket.getTermBytes() == null ? null : stringTermsBucket.getTermBytes().utf8ToString();
                jColValueArr = new JSONArray();
                for (String fieldValue : fieldValues = subValue == null ? new String[]{} : subValue.split("_::_")) {
                    if (fieldValue == null || fieldValue.equals("")) continue;
                    jColValueArr.put((Object)fieldValue);
                }
                jColValueArr.put(stringTermsBucket.getDocCount());
                jSubResultArr.put((Object)jColValueArr);
            }
            recordObj.put("summary", (Object)jSubResultArr);
            jResultArr.put((Object)recordObj);
        }
        JSONObject jAggrResult = new JSONObject();
        jAggrResult.put("terms", (Object)jResultArr);
        jAggrResult.put("total_groups", this.totalBucketCount);
        return jAggrResult;
    }

    public static class Bucket
    extends AggTerms.Bucket<Bucket> {
        Long term;
        List<StringTerms.Bucket> stringTermsBuckets;

        public Bucket(Long term, long count, List<StringTerms.Bucket> stringTermsBuckets) {
            this.term = term;
            this.docCount = count;
            this.stringTermsBuckets = stringTermsBuckets;
        }

        public Long getTerm() {
            return this.term;
        }

        @Override
        public int compare(Bucket other) {
            return this.term == null && other.getTerm() == null ? 0 : (this.term == null ? -1 : (other.getTerm() == null ? 1 : Long.compare(this.term, other.getTerm())));
        }
    }
}

