/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;

public class MultiStringTermsAggregator
extends BucketsAggregator {
    protected final BytesRefHash bucketOrds = new BytesRefHash();
    private ValuesSource.Bytes.MultiFieldData valuesSource;
    private long totalGroupCount = 0L;
    private long totalHitCount = 0L;

    public MultiStringTermsAggregator(ValuesSource.Bytes.MultiFieldData valuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.totalGroupCount = 0L;
        this.totalHitCount = 0L;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final MultiFieldDocValues docValues = this.valuesSource.docValues(ctx);
        docValues.loadDocValues();
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){
                final BytesRefBuilder values;
                {
                    super(context);
                    this.values = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc) throws IOException {
                    if (MultiStringTermsAggregator.this.isValidTime(filterDocValues, doc)) {
                        this.values.copyChars((CharSequence)docValues.getFieldValue(doc).toString());
                        BytesRef bytes = this.values.get();
                        long bucketOrdinal = MultiStringTermsAggregator.this.bucketOrds.add(bytes);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            MultiStringTermsAggregator.this.collectExistingBucket((int)bucketOrdinal);
                        } else {
                            MultiStringTermsAggregator.this.collectBucket((int)bucketOrdinal);
                        }
                        MultiStringTermsAggregator.this.totalHitCount++;
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){
            final BytesRefBuilder values;
            {
                super(context);
                this.values = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc) throws IOException {
                this.values.copyChars((CharSequence)docValues.getFieldValue(doc).toString());
                BytesRef bytes = this.values.get();
                long bucketOrdinal = MultiStringTermsAggregator.this.bucketOrds.add(bytes);
                if (bucketOrdinal < 0L) {
                    bucketOrdinal = -1L - bucketOrdinal;
                    MultiStringTermsAggregator.this.collectExistingBucket((int)bucketOrdinal);
                } else {
                    MultiStringTermsAggregator.this.collectBucket((int)bucketOrdinal);
                }
                MultiStringTermsAggregator.this.totalHitCount++;
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        StringTerms.Bucket bucket;
        int i;
        if (this.bucketOrds == null) {
            return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, 0L, (List<StringTerms.Bucket>)new ArrayList<StringTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalGroupCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        StringTerms.Bucket spare = new StringTerms.Bucket(new BytesRef());
        for (int i2 = 0; i2 < this.bucketOrds.size(); ++i2) {
            this.bucketOrds.get(i2, spare.termBytes);
            spare.docCount = this.getBucketDocCount(i2);
            spare.bucketOrd = i2;
            otherDocCount += spare.docCount;
            spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare);
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef());
            }
            ++this.totalGroupCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTerms.Bucket[] list = new StringTerms.Bucket[actualSize];
        long[] survivingBucketOrds = new long[ordered.size()];
        int listIndex = actualSize - 1;
        for (i = ordered.size() - 1; i >= this.offset(); --i) {
            bucket = (StringTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[listIndex] = bucket;
            otherDocCount -= bucket.docCount;
            --listIndex;
        }
        for (i = 0; i < list.length; ++i) {
            bucket = list[i];
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
        }
        return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }
}

