/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.DateTimeUnit;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsHistogramAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram.DateHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTermsHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;

public class MultiStringTermsDHAggregator
extends BucketsHistogramAggregator {
    protected final BytesRefHash bucketOrds = new BytesRefHash();
    private ValuesSource.Bytes.MultiFieldData valuesSource;
    private ValuesSource.Numeric dateValuesSource;
    protected SortedDocValues globalOrds;
    private DateTimeUnit unit;
    private DateTimeField field;
    private DateTimeZone timeZone;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public MultiStringTermsDHAggregator(ValuesSource.Bytes.MultiFieldData valuesSource, ValuesSource.Numeric dateValuesSource, SearchContext context, DateTimeUnit unit, DateTimeZone timeZone, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.dateValuesSource = dateValuesSource;
        this.unit = unit;
        this.field = unit.field(timeZone);
        this.timeZone = timeZone;
        this.totalHitCount = 0L;
        this.totalBucketCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final MultiFieldDocValues docValues = this.valuesSource.docValues(context);
        docValues.loadDocValues();
        final FieldDocValues dateDocValues = this.dateValuesSource.longValues(context);
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){
                final BytesRefBuilder values;
                {
                    super(context);
                    this.values = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc) throws IOException {
                    if (MultiStringTermsDHAggregator.this.isValidTime(filterDocValues, doc)) {
                        MultiStringTermsDHAggregator.this.collectHistogram(this.values, docValues, dateDocValues, doc);
                    }
                }
            };
        }
        return new LeafBucketCollector(context){
            final BytesRefBuilder values;
            {
                super(context);
                this.values = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc) throws IOException {
                MultiStringTermsDHAggregator.this.collectHistogram(this.values, docValues, dateDocValues, doc);
            }
        };
    }

    public void collectHistogram(BytesRefBuilder values, MultiFieldDocValues docValues, FieldDocValues dateDocValues, int doc) throws IOException {
        values.copyChars((CharSequence)docValues.getFieldValue(doc).toString());
        BytesRef bytes = values.get();
        long bucketOrdinal = this.bucketOrds.add(bytes);
        Long dateValue = (Long)dateDocValues.get(doc);
        if (bucketOrdinal < 0L) {
            bucketOrdinal = -1L - bucketOrdinal;
            this.collectExistingHistogramBucket((int)bucketOrdinal, this.field, dateValue);
        } else {
            this.collectHistogramBucket((int)bucketOrdinal, this.field, dateValue);
        }
        ++this.totalHitCount;
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.bucketOrds == null) {
            return new StringTermsHistogram(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, 0L, (List<StringTermsHistogram.Bucket>)new ArrayList<StringTermsHistogram.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalBucketCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        StringTerms.Bucket spare = new StringTerms.Bucket(new BytesRef());
        for (int i = 0; i < this.bucketOrds.size(); ++i) {
            long bucketDocCount;
            this.bucketOrds.get(i, spare.termBytes);
            long l = bucketDocCount = (long)i < 0L ? 0L : this.getBucketDocCount(i);
            if (bucketDocCount == 0L) continue;
            spare.bucketOrd = i;
            spare.docCount = bucketDocCount;
            ++this.totalBucketCount;
            otherDocCount += bucketDocCount;
            if ((spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare)) != null) continue;
            spare = new StringTerms.Bucket(new BytesRef());
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTermsHistogram.Bucket[] list = new StringTermsHistogram.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)ordered.pop();
            HashMap<Long, Long> termBucketMap = this.getHistogramBucket((int)bucket.bucketOrd);
            long totalTermBucketCount = termBucketMap.size();
            ArrayList<DateHistogram.Bucket> histogramBuckets = new ArrayList<DateHistogram.Bucket>((int)totalTermBucketCount);
            for (Long key : termBucketMap.keySet()) {
                histogramBuckets.add(new DateHistogram.Bucket(key, termBucketMap.get(key)));
            }
            CollectionUtil.introSort(histogramBuckets, AggregationSortOrder.TERM_ASC.comparator(this));
            list[listIndex] = new StringTermsHistogram.Bucket(bucket.termBytes, bucket.docCount, histogramBuckets);
            list[listIndex].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[listIndex].docCount;
            --listIndex;
        }
        return new StringTermsHistogram(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }

    public boolean needsScores() {
        return false;
    }

    static class OrdBucket
    extends AggTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount) {
            this.globalOrd = globalOrd;
        }

        @Override
        public int compare(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }
    }
}

