/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;

public class MultiStringTermsStatsAggregator
extends BucketsStatsAggregator {
    protected final BytesRefHash bucketOrds = new BytesRefHash();
    private ValuesSource.Bytes.MultiFieldData valuesSource;
    private List<ValuesSource.Numeric> statsValuesSource;
    private List<StatsType> statsType;
    private long totalGroupCount = 0L;
    private long totalHitCount = 0L;

    public MultiStringTermsStatsAggregator(ValuesSource.Bytes.MultiFieldData valuesSource, List<ValuesSource.Numeric> statsValuesSource, List<StatsType> statsType, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData, statsType.size());
        this.valuesSource = valuesSource;
        this.statsValuesSource = statsValuesSource;
        this.statsType = statsType;
        this.totalGroupCount = 0L;
        this.totalHitCount = 0L;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final MultiFieldDocValues docValues = this.valuesSource.docValues(ctx);
        docValues.loadDocValues();
        final ArrayList<FieldDocValues> statDocValues = new ArrayList<FieldDocValues>();
        for (int i = 0; i < this.statsValuesSource.size(); ++i) {
            statDocValues.add(i, this.statsValuesSource.get(i).doubleValues(ctx));
        }
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){
                final BytesRefBuilder values;
                {
                    super(context);
                    this.values = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc) throws IOException {
                    if (MultiStringTermsStatsAggregator.this.isValidTime(filterDocValues, doc)) {
                        MultiStringTermsStatsAggregator.this.collectStatsArray(this.values, docValues, statDocValues, doc);
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){
            final BytesRefBuilder values;
            {
                super(context);
                this.values = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc) throws IOException {
                MultiStringTermsStatsAggregator.this.collectStatsArray(this.values, docValues, statDocValues, doc);
            }
        };
    }

    public void collectStatsArray(BytesRefBuilder values, MultiFieldDocValues docValues, ArrayList<FieldDocValues> statDocValues, int doc) throws IOException {
        values.copyChars((CharSequence)docValues.getFieldValue(doc).toString());
        BytesRef bytes = values.get();
        long bucketOrdinal = this.bucketOrds.add(bytes);
        for (int i = 0; i < statDocValues.size(); ++i) {
            Double statFieldValue = (Double)statDocValues.get(i).get(doc);
            if (statFieldValue == null) {
                statFieldValue = this.statsType.get(i) == StatsType.MIN ? Double.valueOf(Double.POSITIVE_INFINITY) : (this.statsType.get(i) == StatsType.MAX ? Double.valueOf(Double.NEGATIVE_INFINITY) : Double.valueOf(0.0));
            }
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingStatsBucket(i, (int)bucketOrdinal, this.statsType.get(i), statFieldValue);
                continue;
            }
            this.collectStatsBucket(i, (int)bucketOrdinal, this.statsType.get(i), statFieldValue);
        }
        ++this.totalHitCount;
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        StringTerms.Bucket bucket;
        int i;
        if (this.bucketOrds == null) {
            return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, 0L, (List<StringTerms.Bucket>)new ArrayList<StringTerms.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalGroupCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        StringTerms.Bucket spare = new StringTerms.Bucket(new BytesRef());
        int statslen = this.statsType.size();
        for (int i2 = 0; i2 < this.bucketOrds.size(); ++i2) {
            this.bucketOrds.get(i2, spare.termBytes);
            spare.docCount = this.getBucketDocCount(i2) / (long)statslen;
            spare.statsArr = new ArrayList();
            for (int istats = 0; istats < statslen; ++istats) {
                spare.statsArr.add(this.getStatsBucketValue(istats, i2, this.statsType.get(istats)));
            }
            spare.bucketOrd = i2;
            otherDocCount += spare.docCount;
            if ((spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare)) == null) {
                spare = new StringTerms.Bucket(new BytesRef());
            }
            ++this.totalGroupCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTerms.Bucket[] list = new StringTerms.Bucket[actualSize];
        long[] survivingBucketOrds = new long[ordered.size()];
        int listIndex = actualSize - 1;
        for (i = ordered.size() - 1; i >= this.offset(); --i) {
            bucket = (StringTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[listIndex] = bucket;
            otherDocCount -= bucket.docCount;
            --listIndex;
        }
        for (i = 0; i < list.length; ++i) {
            bucket = list[i];
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
        }
        return new StringTerms(this.id(), this.aggregationType(), this.totalGroupCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }
}

