/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsSummaryAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTermsSummary;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;

public class MultiStringTermsSummaryAggregator
extends BucketsSummaryAggregator {
    private ValuesSource.Bytes.MultiFieldData primeValuesSource;
    private ValuesSource.Bytes.MultiFieldData secValuesSource;
    private final BytesRefHash primMultiTermBucketOrds;
    private final BytesRefHash secMultiTermBucketOrds;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public MultiStringTermsSummaryAggregator(ValuesSource.Bytes.MultiFieldData primeValuesSource, ValuesSource.Bytes.MultiFieldData secValuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.primeValuesSource = primeValuesSource;
        this.secValuesSource = secValuesSource;
        this.primMultiTermBucketOrds = new BytesRefHash();
        this.secMultiTermBucketOrds = new BytesRefHash();
        this.totalHitCount = 0L;
        this.totalBucketCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final MultiFieldDocValues primMultiTermDocValues = this.primeValuesSource.docValues(context);
        primMultiTermDocValues.loadDocValues();
        final MultiFieldDocValues secMultiTermDocValues = this.secValuesSource.docValues(context);
        secMultiTermDocValues.loadDocValues();
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){
                final BytesRefBuilder values;
                {
                    super(context);
                    this.values = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc) throws IOException {
                    if (MultiStringTermsSummaryAggregator.this.isValidTime(filterDocValues, doc)) {
                        MultiStringTermsSummaryAggregator.this.collectSummary(this.values, primMultiTermDocValues, secMultiTermDocValues, doc);
                    }
                }
            };
        }
        return new LeafBucketCollector(context){
            final BytesRefBuilder values;
            {
                super(context);
                this.values = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc) throws IOException {
                MultiStringTermsSummaryAggregator.this.collectSummary(this.values, primMultiTermDocValues, secMultiTermDocValues, doc);
            }
        };
    }

    public void collectSummary(BytesRefBuilder values, MultiFieldDocValues primMultiTermDocValues, MultiFieldDocValues secMultiTermDocValues, int doc) throws IOException {
        values.copyChars((CharSequence)primMultiTermDocValues.getFieldValue(doc).toString());
        BytesRef primBytes = values.get();
        int primOrdinal = this.primMultiTermBucketOrds.add(primBytes);
        values.copyChars((CharSequence)secMultiTermDocValues.getFieldValue(doc).toString());
        BytesRef secBytes = values.get();
        int otherBucketOrdinal = this.secMultiTermBucketOrds.add(secBytes);
        if (otherBucketOrdinal < 0) {
            otherBucketOrdinal = -1 - otherBucketOrdinal;
        }
        if (primOrdinal < 0) {
            primOrdinal = -1 - primOrdinal;
            this.collectExistingSummaryBucket(primOrdinal, otherBucketOrdinal);
        } else {
            this.collectSummaryBucket(primOrdinal, otherBucketOrdinal);
        }
        ++this.totalHitCount;
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.primMultiTermBucketOrds == null) {
            return new StringTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, 0L, (List<StringTermsSummary.Bucket>)new ArrayList<StringTermsSummary.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalBucketCount = 0L;
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        StringTerms.Bucket spare = new StringTerms.Bucket(new BytesRef());
        for (int globalTermOrd = 0; globalTermOrd < this.primMultiTermBucketOrds.size(); ++globalTermOrd) {
            long bucketDocCount;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            long l = bucketDocCount = bucketOrd < 0L ? 0L : this.getBucketDocCount((int)bucketOrd);
            if (bucketDocCount == 0L) continue;
            this.primMultiTermBucketOrds.get(globalTermOrd, spare.termBytes);
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            otherDocCount += bucketDocCount;
            spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare);
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef());
            }
            ++this.totalBucketCount;
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTermsSummary.Bucket[] list = new StringTermsSummary.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)ordered.pop();
            HashMap<Integer, Integer> termBucketMap = this.getSummaryBucket((int)bucket.bucketOrd);
            long totalTermBucketCount = termBucketMap.size();
            ArrayList<StringTerms.Bucket> stringTermsBuckets = new ArrayList<StringTerms.Bucket>((int)totalTermBucketCount);
            for (Integer key : termBucketMap.keySet()) {
                StringTerms.Bucket stringTermsBucket = new StringTerms.Bucket(new BytesRef(), termBucketMap.get(key).intValue());
                this.secMultiTermBucketOrds.get(key.intValue(), stringTermsBucket.termBytes);
                stringTermsBucket.bucketOrd = key.intValue();
                stringTermsBuckets.add(stringTermsBucket);
            }
            CollectionUtil.introSort(stringTermsBuckets, AggregationSortOrder.TERM_ASC.comparator(this));
            list[listIndex] = new StringTermsSummary.Bucket(bucket.termBytes, bucket.docCount, stringTermsBuckets);
            list[listIndex].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[listIndex].docCount;
            --listIndex;
        }
        return new StringTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }

    public boolean needsScores() {
        return false;
    }

    static class OrdBucket
    extends AggTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount) {
            this.globalOrd = globalOrd;
        }

        @Override
        public int compare(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }
    }
}

