/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationSortOrder;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketAggregation;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketPriorityQueue;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.BucketsSummaryStatsAggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTermsSummary;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.MultiFieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;

public class MultiStringTermsSummaryStatsAggregator
extends BucketsSummaryStatsAggregator {
    private ValuesSource.Bytes.MultiFieldData primeValuesSource;
    private ValuesSource.Bytes.MultiFieldData secValuesSource;
    private final BytesRefHash primMultiTermBucketOrds;
    private final BytesRefHash secMultiTermBucketOrds;
    private List<ValuesSource.Numeric> statsValuesSource;
    private List<StatsType> statsType;
    private long totalBucketCount = 0L;
    private long totalHitCount = 0L;

    public MultiStringTermsSummaryStatsAggregator(ValuesSource.Bytes.MultiFieldData primeValuesSource, ValuesSource.Bytes.MultiFieldData secValuesSource, List<ValuesSource.Numeric> statsValuesSource, List<StatsType> statsType, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData, statsType.size());
        this.primeValuesSource = primeValuesSource;
        this.secValuesSource = secValuesSource;
        this.primMultiTermBucketOrds = new BytesRefHash();
        this.secMultiTermBucketOrds = new BytesRefHash();
        this.statsValuesSource = statsValuesSource;
        this.statsType = statsType;
        this.totalHitCount = 0L;
        this.totalBucketCount = 0L;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final MultiFieldDocValues primMultiTermDocValues = this.primeValuesSource.docValues(context);
        primMultiTermDocValues.loadDocValues();
        final MultiFieldDocValues secMultiTermDocValues = this.secValuesSource.docValues(context);
        secMultiTermDocValues.loadDocValues();
        final ArrayList<FieldDocValues> statDocValues = new ArrayList<FieldDocValues>();
        for (int i = 0; i < this.statsValuesSource.size(); ++i) {
            statDocValues.add(i, this.statsValuesSource.get(i).doubleValues(context));
        }
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.filterField);
            return new LeafBucketCollector(context){
                final BytesRefBuilder values;
                {
                    super(context);
                    this.values = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc) throws IOException {
                    if (MultiStringTermsSummaryStatsAggregator.this.isValidTime(filterDocValues, doc)) {
                        MultiStringTermsSummaryStatsAggregator.this.collectSummaryStats(this.values, primMultiTermDocValues, secMultiTermDocValues, statDocValues, doc);
                    }
                }
            };
        }
        return new LeafBucketCollector(context){
            final BytesRefBuilder values;
            {
                super(context);
                this.values = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc) throws IOException {
                MultiStringTermsSummaryStatsAggregator.this.collectSummaryStats(this.values, primMultiTermDocValues, secMultiTermDocValues, statDocValues, doc);
            }
        };
    }

    public void collectSummaryStats(BytesRefBuilder values, MultiFieldDocValues primMultiTermDocValues, MultiFieldDocValues secMultiTermDocValues, ArrayList<FieldDocValues> statDocValues, int doc) throws IOException {
        values.copyChars((CharSequence)primMultiTermDocValues.getFieldValue(doc).toString());
        BytesRef primBytes = values.get();
        int primOrdinal = this.primMultiTermBucketOrds.add(primBytes);
        values.copyChars((CharSequence)secMultiTermDocValues.getFieldValue(doc).toString());
        BytesRef secBytes = values.get();
        int otherBucketOrdinal = this.secMultiTermBucketOrds.add(secBytes);
        if (otherBucketOrdinal < 0) {
            otherBucketOrdinal = -1 - otherBucketOrdinal;
        }
        for (int i = 0; i < statDocValues.size(); ++i) {
            Double statFieldValue = (Double)statDocValues.get(i).get(doc);
            if (primOrdinal < 0) {
                primOrdinal = -1 - primOrdinal;
                this.collectExistingSummaryStatsBucket(primOrdinal, otherBucketOrdinal, i, this.statsType.get(i), statFieldValue);
                continue;
            }
            this.collectSummaryStatsBucket(primOrdinal, otherBucketOrdinal, i, this.statsType.get(i), statFieldValue);
        }
        ++this.totalHitCount;
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public AggregationResult buildAggregation() throws IOException {
        if (this.primMultiTermBucketOrds == null) {
            return new StringTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, 0L, (List<StringTermsSummary.Bucket>)new ArrayList<StringTermsSummary.Bucket>(), this.metaData());
        }
        int maxFetchSize = Math.min(this.getBucketCount(), this.offset() + this.size());
        long otherDocCount = 0L;
        this.totalBucketCount = 0L;
        int statslen = this.statsType.size();
        BucketPriorityQueue<BucketAggregation.Bucket> ordered = new BucketPriorityQueue<BucketAggregation.Bucket>(maxFetchSize, this.sortOrder().comparator(this));
        StringTerms.Bucket spare = new StringTerms.Bucket(new BytesRef());
        for (int globalTermOrd = 0; globalTermOrd < this.primMultiTermBucketOrds.size(); ++globalTermOrd) {
            long bucketCount;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            long l = bucketCount = bucketOrd < 0L ? 0L : (long)this.getGroupBucketCount((int)bucketOrd);
            if (bucketCount == 0L) continue;
            this.primMultiTermBucketOrds.get(globalTermOrd, spare.termBytes);
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketCount;
            spare.statsArr = new ArrayList();
            otherDocCount += spare.docCount;
            boolean isFiltered = false;
            if (this.metaData().containsKey("filter_bucket_count")) {
                if ((long)((Integer)this.metaData().get("filter_bucket_count")).intValue() == spare.docCount) {
                    isFiltered = true;
                }
            } else if (this.metaData().containsKey("filter_min_bucket_count")) {
                if ((long)((Integer)this.metaData().get("filter_min_bucket_count")).intValue() <= spare.docCount) {
                    isFiltered = true;
                }
            } else if (this.metaData().containsKey("filter_max_bucket_count")) {
                if ((long)((Integer)this.metaData().get("filter_max_bucket_count")).intValue() >= spare.docCount) {
                    isFiltered = true;
                }
            } else {
                isFiltered = true;
            }
            if (isFiltered) {
                spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare);
                ++this.totalBucketCount;
            } else {
                spare = null;
            }
            if (spare != null) continue;
            spare = new StringTerms.Bucket(new BytesRef());
        }
        int actualSize = Math.min(this.size(), ordered.size() - this.offset() < 0 ? 0 : ordered.size() - this.offset());
        StringTermsSummary.Bucket[] list = new StringTermsSummary.Bucket[actualSize];
        int listIndex = actualSize - 1;
        for (int i = ordered.size() - 1; i >= this.offset(); --i) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)ordered.pop();
            BytesRef scratch = bucket.termBytes;
            int primOrdinal = this.primMultiTermBucketOrds.add(scratch);
            if (primOrdinal < 0) {
                primOrdinal = -1 - primOrdinal;
            }
            HashMap<Integer, ArrayList<Double>> termBucketMap = this.getSummaryStatsBucket(primOrdinal);
            long totalTermBucketCount = termBucketMap.size();
            ArrayList<StringTerms.Bucket> stringTermsBuckets = new ArrayList<StringTerms.Bucket>((int)totalTermBucketCount);
            for (Integer key : termBucketMap.keySet()) {
                StringTerms.Bucket stringTermsBucket = new StringTerms.Bucket(new BytesRef());
                stringTermsBucket.statsArr = termBucketMap.get(key);
                this.secMultiTermBucketOrds.get(key.intValue(), stringTermsBucket.termBytes);
                stringTermsBucket.bucketOrd = key.intValue();
                stringTermsBuckets.add(stringTermsBucket);
            }
            CollectionUtil.introSort(stringTermsBuckets, AggregationSortOrder.TERM_ASC.comparator(this));
            list[listIndex] = new StringTermsSummary.Bucket(scratch, bucket.docCount, stringTermsBuckets);
            list[listIndex].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[listIndex].docCount;
            --listIndex;
        }
        return new StringTermsSummary(this.id(), this.aggregationType(), this.totalBucketCount, this.totalHitCount, otherDocCount, Arrays.asList(list), this.metaData());
    }

    public boolean needsScores() {
        return false;
    }

    static class OrdBucket
    extends AggTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount) {
            this.globalOrd = globalOrd;
        }

        @Override
        public int compare(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }
    }
}

