/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StringTerms
extends AggTerms<StringTerms, Bucket> {
    public StringTerms(long id, AggregationType aggregationType, long totalGroupCount, long totalHitCount, long otherDocCount, List<Bucket> buckets, Map<String, Object> metaData) {
        super(id, aggregationType, totalGroupCount, totalHitCount, otherDocCount, buckets, metaData);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        List<Bucket> res = this.getBuckets();
        JSONArray jResultArr = new JSONArray();
        JSONArray jColValueArr = null;
        boolean statsFieldHasFloatingPoint = false;
        for (Bucket buck : res) {
            String value = buck.getTermBytes() == null ? null : buck.getTermBytes().utf8ToString();
            jColValueArr = new JSONArray();
            if (this.aggregationType() == AggregationType.MULTI_STRING_TERMS_AGGREGATION || this.aggregationType() == AggregationType.MULTI_STRING_TERMS_STATS_AGGREGATION) {
                String[] fieldValues;
                for (String fieldValue : fieldValues = value == null ? new String[]{} : value.split("_::_")) {
                    if (fieldValue == null || fieldValue.equals("")) continue;
                    jColValueArr.put((Object)fieldValue);
                }
            } else {
                jColValueArr.put((Object)value);
            }
            jColValueArr.put(buck.getDocCount());
            if (this.aggregationType() == AggregationType.STRING_TERMS_STATS_AGGREGATION || this.aggregationType() == AggregationType.MULTI_STRING_TERMS_STATS_AGGREGATION) {
                ArrayList<Double> statsTemp = buck.getStatsArr();
                ArrayList statFieldsDataType = (ArrayList)this.metaData().get("stats_field_data_type");
                for (int i = 0; i < statsTemp.size(); ++i) {
                    if (statsTemp.get(i) == Double.NEGATIVE_INFINITY || statsTemp.get(i) == Double.POSITIVE_INFINITY) {
                        jColValueArr.put((Object)"");
                        continue;
                    }
                    statsFieldHasFloatingPoint = ((DRFieldDataType)statFieldsDataType.get(i)).hasFloatingPoint();
                    jColValueArr.put((Object)(statsFieldHasFloatingPoint ? BigDecimal.valueOf(statsTemp.get(i)).toPlainString() : BigDecimal.valueOf(statsTemp.get(i)).setScale(0).toPlainString()));
                }
            }
            jResultArr.put((Object)jColValueArr);
        }
        JSONObject jAggrResult = new JSONObject();
        jAggrResult.put("terms", (Object)jResultArr);
        jAggrResult.put("total_groups", this.totalBucketCount);
        return jAggrResult;
    }

    public static class Bucket
    extends AggTerms.Bucket<Bucket> {
        BytesRef termBytes;

        public Bucket(BytesRef term) {
            this.termBytes = term;
        }

        public Bucket(BytesRef term, long count) {
            this.termBytes = term;
            this.docCount = count;
        }

        public BytesRef getTermBytes() {
            return this.termBytes;
        }

        @Override
        public ArrayList<Double> getStatsArr() {
            return this.statsArr;
        }

        @Override
        public int compare(Bucket other) {
            return this.termBytes == null && other.termBytes == null ? 0 : (this.termBytes == null ? -1 : (other.termBytes == null ? 1 : this.termBytes.compareTo(other.termBytes)));
        }
    }
}

