/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.histogram.DateHistogram;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StringTermsHistogram
extends AggTerms<StringTermsHistogram, Bucket> {
    public StringTermsHistogram(long id, AggregationType aggregationType, long totalBucketCount, long totalHitCount, long otherDocCount, List<Bucket> buckets, Map<String, Object> metaData) {
        super(id, aggregationType, totalBucketCount, totalHitCount, otherDocCount, buckets, metaData);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        List<Bucket> res = this.getBuckets();
        JSONArray jResultArr = new JSONArray();
        for (Bucket buck : res) {
            String[] termValues;
            String value = buck.getTermBytes() == null ? null : buck.getTermBytes().utf8ToString();
            JSONObject recordObj = new JSONObject();
            String[] stringArray = termValues = value == null ? new String[]{} : value.split("_::_");
            if (termValues.length == 1) {
                recordObj.put("term", (Object)value);
            } else {
                JSONArray jTermColArr = new JSONArray();
                for (String fieldValue : termValues) {
                    if (fieldValue == null || fieldValue.equals("")) continue;
                    jTermColArr.put((Object)fieldValue);
                }
                recordObj.put("term", (Object)jTermColArr);
            }
            recordObj.put("count", buck.getDocCount());
            List<DateHistogram.Bucket> histogramBuckets = buck.histogramBuckets;
            JSONArray jHistogramArr = new JSONArray();
            for (DateHistogram.Bucket histogramBucket : histogramBuckets) {
                JSONArray jColValueArr = new JSONArray();
                jColValueArr.put(histogramBucket.getKey());
                jColValueArr.put(histogramBucket.getDocCount());
                jHistogramArr.put((Object)jColValueArr);
            }
            recordObj.put("histogram", (Object)jHistogramArr);
            jResultArr.put((Object)recordObj);
        }
        JSONObject jAggrResult = new JSONObject();
        jAggrResult.put("terms", (Object)jResultArr);
        jAggrResult.put("total_groups", this.totalBucketCount);
        return jAggrResult;
    }

    public static class Bucket
    extends AggTerms.Bucket<Bucket> {
        BytesRef termBytes;
        List<DateHistogram.Bucket> histogramBuckets;

        public Bucket(BytesRef term, long count, List<DateHistogram.Bucket> histogramBuckets) {
            this.termBytes = term;
            this.docCount = count;
            this.histogramBuckets = histogramBuckets;
        }

        public BytesRef getTermBytes() {
            return this.termBytes;
        }

        @Override
        public int compare(Bucket other) {
            return this.termBytes == null && other.termBytes == null ? 0 : (this.termBytes == null ? -1 : (other.termBytes == null ? 1 : this.termBytes.compareTo(other.termBytes)));
        }
    }
}

