/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationType;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.AggTerms;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.terms.StringTerms;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StringTermsSummary
extends AggTerms<StringTermsSummary, Bucket> {
    public StringTermsSummary(long id, AggregationType aggregationType, long totalBucketCount, long totalHitCount, long otherDocCount, List<Bucket> buckets, Map<String, Object> metaData) {
        super(id, aggregationType, totalBucketCount, totalHitCount, otherDocCount, buckets, metaData);
    }

    @Override
    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        List<Bucket> res = this.getBuckets();
        JSONArray jResultArr = new JSONArray();
        for (Bucket summaryBucket : res) {
            String[] termValues;
            String value = summaryBucket.getTermBytes() == null ? null : summaryBucket.getTermBytes().utf8ToString();
            JSONObject recordObj = new JSONObject();
            String[] stringArray = termValues = value == null ? new String[]{} : value.split("_::_");
            if (termValues.length == 1) {
                recordObj.put("term", (Object)value);
            } else {
                JSONArray jTermColArr = new JSONArray();
                for (String fieldValue : termValues) {
                    if (fieldValue == null || fieldValue.equals("")) continue;
                    jTermColArr.put((Object)fieldValue);
                }
                recordObj.put("term", (Object)jTermColArr);
            }
            recordObj.put("count", summaryBucket.getDocCount());
            List<StringTerms.Bucket> stringTermsBuckets = summaryBucket.stringTermsBuckets;
            JSONArray jSubResultArr = new JSONArray();
            JSONArray jColValueArr = null;
            for (StringTerms.Bucket stringTermsBucket : stringTermsBuckets) {
                String[] fieldValues;
                String subValue = stringTermsBucket.getTermBytes() == null ? null : stringTermsBucket.getTermBytes().utf8ToString();
                jColValueArr = new JSONArray();
                for (String fieldValue : fieldValues = subValue == null ? new String[]{} : subValue.split("_::_")) {
                    if (fieldValue == null || fieldValue.equals("")) continue;
                    jColValueArr.put((Object)fieldValue);
                }
                if (this.aggregationType() == AggregationType.MULTI_STRING_TERMS_SUMMARY_STATS_AGGREGATION) {
                    ArrayList<Double> statsArr = stringTermsBucket.getStatsArr();
                    ArrayList statsFieldsDataType = (ArrayList)this.metaData().get("stats_field_data_type");
                    for (int istats = 0; istats < statsArr.size(); ++istats) {
                        if (statsArr.get(istats) == Double.NEGATIVE_INFINITY || statsArr.get(istats) == Double.POSITIVE_INFINITY) {
                            jColValueArr.put((Object)"");
                            continue;
                        }
                        boolean statsFieldHasFloatingPoint = ((DRFieldDataType)statsFieldsDataType.get(istats)).hasFloatingPoint();
                        jColValueArr.put((Object)(statsFieldHasFloatingPoint ? BigDecimal.valueOf(statsArr.get(istats)).toPlainString() : BigDecimal.valueOf(statsArr.get(istats)).setScale(0).toPlainString()));
                    }
                } else {
                    jColValueArr.put(stringTermsBucket.getDocCount());
                }
                jSubResultArr.put((Object)jColValueArr);
            }
            recordObj.put("summary", (Object)jSubResultArr);
            jResultArr.put((Object)recordObj);
        }
        JSONObject jAggrResult = new JSONObject();
        jAggrResult.put("terms", (Object)jResultArr);
        jAggrResult.put("total_groups", this.totalBucketCount);
        return jAggrResult;
    }

    public static class Bucket
    extends AggTerms.Bucket<Bucket> {
        BytesRef termBytes;
        List<StringTerms.Bucket> stringTermsBuckets;

        public Bucket(BytesRef term, long count, List<StringTerms.Bucket> stringTermsBuckets) {
            this.termBytes = term;
            this.docCount = count;
            this.stringTermsBuckets = stringTermsBuckets;
        }

        public BytesRef getTermBytes() {
            return this.termBytes;
        }

        @Override
        public int compare(Bucket other) {
            return this.termBytes == null && other.termBytes == null ? 0 : (this.termBytes == null ? -1 : (other.termBytes == null ? 1 : this.termBytes.compareTo(other.termBytes)));
        }
    }
}

