/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;

public abstract class FieldDocValues {
    public static FieldDocValues longValues(LeafReaderContext context, String field) throws IOException {
        return new LongFieldDoc(DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field));
    }

    public static FieldDocValues doubleValues(LeafReaderContext context, String field) throws IOException {
        return new DoubleFieldDoc(DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field));
    }

    public abstract Number get(int var1);

    public static final class DoubleFieldDoc
    extends FieldDocValues {
        private final SortedNumericDocValues values;

        public DoubleFieldDoc(SortedNumericDocValues values) {
            this.values = values;
        }

        @Override
        public Double get(int docId) {
            try {
                if (this.values.advanceExact(docId)) {
                    return new Long(this.values.nextValue()).doubleValue();
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static final class LongFieldDoc
    extends FieldDocValues {
        private final SortedNumericDocValues values;

        public LongFieldDoc(SortedNumericDocValues values) {
            this.values = values;
        }

        @Override
        public Long get(int docId) {
            try {
                if (this.values.advanceExact(docId)) {
                    return this.values.nextValue();
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

